package org.kiwiproject.consul.model.query;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.immutables.value.Generated;
import org.kiwiproject.consul.model.health.HealthCheck;
import org.kiwiproject.consul.model.health.Node;
import org.kiwiproject.consul.model.health.Service;

/**
 * Immutable implementation of {@link QueryResult}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableQueryResult.builder()}.
 */
@Generated(from = "QueryResult", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@JsonIgnoreProperties(ignoreUnknown = true)
public final class ImmutableQueryResult extends QueryResult {
  private final Node node;
  private final Service service;
  private final ImmutableList<HealthCheck> checks;
  private final @Nullable DnsQuery dns;
  private final @Nullable String datacenters;
  private final @Nullable Integer failovers;

  private ImmutableQueryResult(
      Node node,
      Service service,
      ImmutableList<HealthCheck> checks,
      @Nullable DnsQuery dns,
      @Nullable String datacenters,
      @Nullable Integer failovers) {
    this.node = node;
    this.service = service;
    this.checks = checks;
    this.dns = dns;
    this.datacenters = datacenters;
    this.failovers = failovers;
  }

  /**
   * @return The value of the {@code node} attribute
   */
  @JsonProperty("Node")
  @Override
  public Node getNode() {
    return node;
  }

  /**
   * @return The value of the {@code service} attribute
   */
  @JsonProperty("Service")
  @Override
  public Service getService() {
    return service;
  }

  /**
   * @return The value of the {@code checks} attribute
   */
  @JsonProperty("Checks")
  @JsonDeserialize(as = ImmutableList.class, contentAs = HealthCheck.class)
  @Override
  public ImmutableList<HealthCheck> getChecks() {
    return checks;
  }

  /**
   * @return The value of the {@code dns} attribute
   */
  @JsonProperty("DNS")
  @Override
  public Optional<DnsQuery> getDns() {
    return Optional.ofNullable(dns);
  }

  /**
   * @return The value of the {@code datacenters} attribute
   */
  @JsonProperty("Datacenters")
  @Override
  public Optional<String> datacenters() {
    return Optional.ofNullable(datacenters);
  }

  /**
   * @return The value of the {@code failovers} attribute
   */
  @JsonProperty("Failovers")
  @Override
  public Optional<Integer> failovers() {
    return Optional.ofNullable(failovers);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link QueryResult#getNode() node} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for node
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableQueryResult withNode(Node value) {
    if (this.node == value) return this;
    Node newValue = Objects.requireNonNull(value, "node");
    return new ImmutableQueryResult(newValue, this.service, this.checks, this.dns, this.datacenters, this.failovers);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link QueryResult#getService() service} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for service
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableQueryResult withService(Service value) {
    if (this.service == value) return this;
    Service newValue = Objects.requireNonNull(value, "service");
    return new ImmutableQueryResult(this.node, newValue, this.checks, this.dns, this.datacenters, this.failovers);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link QueryResult#getChecks() checks}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableQueryResult withChecks(HealthCheck... elements) {
    ImmutableList<HealthCheck> newValue = ImmutableList.copyOf(elements);
    return new ImmutableQueryResult(this.node, this.service, newValue, this.dns, this.datacenters, this.failovers);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link QueryResult#getChecks() checks}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of checks elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableQueryResult withChecks(Iterable<? extends HealthCheck> elements) {
    if (this.checks == elements) return this;
    ImmutableList<HealthCheck> newValue = ImmutableList.copyOf(elements);
    return new ImmutableQueryResult(this.node, this.service, newValue, this.dns, this.datacenters, this.failovers);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link QueryResult#getDns() dns} attribute.
   * @param value The value for dns
   * @return A modified copy of {@code this} object
   */
  public final ImmutableQueryResult withDns(DnsQuery value) {
    DnsQuery newValue = Objects.requireNonNull(value, "dns");
    if (this.dns == newValue) return this;
    return new ImmutableQueryResult(this.node, this.service, this.checks, newValue, this.datacenters, this.failovers);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link QueryResult#getDns() dns} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for dns
   * @return A modified copy of {@code this} object
   */
  @SuppressWarnings("unchecked") // safe covariant cast
  public final ImmutableQueryResult withDns(Optional<? extends DnsQuery> optional) {
    @Nullable DnsQuery value = optional.orElse(null);
    if (this.dns == value) return this;
    return new ImmutableQueryResult(this.node, this.service, this.checks, value, this.datacenters, this.failovers);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link QueryResult#datacenters() datacenters} attribute.
   * @param value The value for datacenters
   * @return A modified copy of {@code this} object
   */
  public final ImmutableQueryResult withDatacenters(String value) {
    String newValue = Objects.requireNonNull(value, "datacenters");
    if (Objects.equals(this.datacenters, newValue)) return this;
    return new ImmutableQueryResult(this.node, this.service, this.checks, this.dns, newValue, this.failovers);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link QueryResult#datacenters() datacenters} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for datacenters
   * @return A modified copy of {@code this} object
   */
  public final ImmutableQueryResult withDatacenters(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.datacenters, value)) return this;
    return new ImmutableQueryResult(this.node, this.service, this.checks, this.dns, value, this.failovers);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link QueryResult#failovers() failovers} attribute.
   * @param value The value for failovers
   * @return A modified copy of {@code this} object
   */
  public final ImmutableQueryResult withFailovers(int value) {
    @Nullable Integer newValue = value;
    if (Objects.equals(this.failovers, newValue)) return this;
    return new ImmutableQueryResult(this.node, this.service, this.checks, this.dns, this.datacenters, newValue);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link QueryResult#failovers() failovers} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for failovers
   * @return A modified copy of {@code this} object
   */
  public final ImmutableQueryResult withFailovers(Optional<Integer> optional) {
    @Nullable Integer value = optional.orElse(null);
    if (Objects.equals(this.failovers, value)) return this;
    return new ImmutableQueryResult(this.node, this.service, this.checks, this.dns, this.datacenters, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableQueryResult} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableQueryResult
        && equalTo(0, (ImmutableQueryResult) another);
  }

  private boolean equalTo(int synthetic, ImmutableQueryResult another) {
    return node.equals(another.node)
        && service.equals(another.service)
        && checks.equals(another.checks)
        && Objects.equals(dns, another.dns)
        && Objects.equals(datacenters, another.datacenters)
        && Objects.equals(failovers, another.failovers);
  }

  /**
   * Computes a hash code from attributes: {@code node}, {@code service}, {@code checks}, {@code dns}, {@code datacenters}, {@code failovers}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + node.hashCode();
    h += (h << 5) + service.hashCode();
    h += (h << 5) + checks.hashCode();
    h += (h << 5) + Objects.hashCode(dns);
    h += (h << 5) + Objects.hashCode(datacenters);
    h += (h << 5) + Objects.hashCode(failovers);
    return h;
  }

  /**
   * Prints the immutable value {@code QueryResult} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("QueryResult")
        .omitNullValues()
        .add("node", node)
        .add("service", service)
        .add("checks", checks)
        .add("dns", dns)
        .add("datacenters", datacenters)
        .add("failovers", failovers)
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "QueryResult", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends QueryResult {
    @Nullable Node node;
    @Nullable Service service;
    @Nullable List<HealthCheck> checks = ImmutableList.of();
    @Nullable Optional<DnsQuery> dns = Optional.empty();
    @Nullable Optional<String> datacenters = Optional.empty();
    @Nullable Optional<Integer> failovers = Optional.empty();
    @JsonProperty("Node")
    public void setNode(Node node) {
      this.node = node;
    }
    @JsonProperty("Service")
    public void setService(Service service) {
      this.service = service;
    }
    @JsonProperty("Checks")
    @JsonDeserialize(as = ImmutableList.class, contentAs = HealthCheck.class)
    public void setChecks(List<HealthCheck> checks) {
      this.checks = checks;
    }
    @JsonProperty("DNS")
    public void setDns(Optional<DnsQuery> dns) {
      this.dns = dns;
    }
    @JsonProperty("Datacenters")
    public void setDatacenters(Optional<String> datacenters) {
      this.datacenters = datacenters;
    }
    @JsonProperty("Failovers")
    public void setFailovers(Optional<Integer> failovers) {
      this.failovers = failovers;
    }
    @Override
    public Node getNode() { throw new UnsupportedOperationException(); }
    @Override
    public Service getService() { throw new UnsupportedOperationException(); }
    @Override
    public List<HealthCheck> getChecks() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<DnsQuery> getDns() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<String> datacenters() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<Integer> failovers() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableQueryResult fromJson(Json json) {
    ImmutableQueryResult.Builder builder = ImmutableQueryResult.builder();
    if (json.node != null) {
      builder.node(json.node);
    }
    if (json.service != null) {
      builder.service(json.service);
    }
    if (json.checks != null) {
      builder.addAllChecks(json.checks);
    }
    if (json.dns != null) {
      builder.dns(json.dns);
    }
    if (json.datacenters != null) {
      builder.datacenters(json.datacenters);
    }
    if (json.failovers != null) {
      builder.failovers(json.failovers);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link QueryResult} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable QueryResult instance
   */
  public static ImmutableQueryResult copyOf(QueryResult instance) {
    if (instance instanceof ImmutableQueryResult) {
      return (ImmutableQueryResult) instance;
    }
    return ImmutableQueryResult.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableQueryResult ImmutableQueryResult}.
   * <pre>
   * ImmutableQueryResult.builder()
   *    .node(org.kiwiproject.consul.model.health.Node) // required {@link QueryResult#getNode() node}
   *    .service(org.kiwiproject.consul.model.health.Service) // required {@link QueryResult#getService() service}
   *    .addChecks|addAllChecks(org.kiwiproject.consul.model.health.HealthCheck) // {@link QueryResult#getChecks() checks} elements
   *    .dns(org.kiwiproject.consul.model.query.DnsQuery) // optional {@link QueryResult#getDns() dns}
   *    .datacenters(String) // optional {@link QueryResult#datacenters() datacenters}
   *    .failovers(Integer) // optional {@link QueryResult#failovers() failovers}
   *    .build();
   * </pre>
   * @return A new ImmutableQueryResult builder
   */
  public static ImmutableQueryResult.Builder builder() {
    return new ImmutableQueryResult.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableQueryResult ImmutableQueryResult}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "QueryResult", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_NODE = 0x1L;
    private static final long INIT_BIT_SERVICE = 0x2L;
    private long initBits = 0x3L;

    private @Nullable Node node;
    private @Nullable Service service;
    private ImmutableList.Builder<HealthCheck> checks = ImmutableList.builder();
    private @Nullable DnsQuery dns;
    private @Nullable String datacenters;
    private @Nullable Integer failovers;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code QueryResult} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(QueryResult instance) {
      Objects.requireNonNull(instance, "instance");
      this.node(instance.getNode());
      this.service(instance.getService());
      addAllChecks(instance.getChecks());
      Optional<DnsQuery> dnsOptional = instance.getDns();
      if (dnsOptional.isPresent()) {
        dns(dnsOptional);
      }
      Optional<String> datacentersOptional = instance.datacenters();
      if (datacentersOptional.isPresent()) {
        datacenters(datacentersOptional);
      }
      Optional<Integer> failoversOptional = instance.failovers();
      if (failoversOptional.isPresent()) {
        failovers(failoversOptional);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link QueryResult#getNode() node} attribute.
     * @param node The value for node 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("Node")
    public final Builder node(Node node) {
      this.node = Objects.requireNonNull(node, "node");
      initBits &= ~INIT_BIT_NODE;
      return this;
    }

    /**
     * Initializes the value for the {@link QueryResult#getService() service} attribute.
     * @param service The value for service 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("Service")
    public final Builder service(Service service) {
      this.service = Objects.requireNonNull(service, "service");
      initBits &= ~INIT_BIT_SERVICE;
      return this;
    }

    /**
     * Adds one element to {@link QueryResult#getChecks() checks} list.
     * @param element A checks element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addChecks(HealthCheck element) {
      this.checks.add(element);
      return this;
    }

    /**
     * Adds elements to {@link QueryResult#getChecks() checks} list.
     * @param elements An array of checks elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addChecks(HealthCheck... elements) {
      this.checks.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link QueryResult#getChecks() checks} list.
     * @param elements An iterable of checks elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("Checks")
    @JsonDeserialize(as = ImmutableList.class, contentAs = HealthCheck.class)
    public final Builder checks(Iterable<? extends HealthCheck> elements) {
      this.checks = ImmutableList.builder();
      return addAllChecks(elements);
    }

    /**
     * Adds elements to {@link QueryResult#getChecks() checks} list.
     * @param elements An iterable of checks elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllChecks(Iterable<? extends HealthCheck> elements) {
      this.checks.addAll(elements);
      return this;
    }

    /**
     * Initializes the optional value {@link QueryResult#getDns() dns} to dns.
     * @param dns The value for dns
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder dns(DnsQuery dns) {
      this.dns = Objects.requireNonNull(dns, "dns");
      return this;
    }

    /**
     * Initializes the optional value {@link QueryResult#getDns() dns} to dns.
     * @param dns The value for dns
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("DNS")
    public final Builder dns(Optional<? extends DnsQuery> dns) {
      this.dns = dns.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link QueryResult#datacenters() datacenters} to datacenters.
     * @param datacenters The value for datacenters
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder datacenters(String datacenters) {
      this.datacenters = Objects.requireNonNull(datacenters, "datacenters");
      return this;
    }

    /**
     * Initializes the optional value {@link QueryResult#datacenters() datacenters} to datacenters.
     * @param datacenters The value for datacenters
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("Datacenters")
    public final Builder datacenters(Optional<String> datacenters) {
      this.datacenters = datacenters.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link QueryResult#failovers() failovers} to failovers.
     * @param failovers The value for failovers
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder failovers(int failovers) {
      this.failovers = failovers;
      return this;
    }

    /**
     * Initializes the optional value {@link QueryResult#failovers() failovers} to failovers.
     * @param failovers The value for failovers
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("Failovers")
    public final Builder failovers(Optional<Integer> failovers) {
      this.failovers = failovers.orElse(null);
      return this;
    }

    /**
     * Builds a new {@link ImmutableQueryResult ImmutableQueryResult}.
     * @return An immutable instance of QueryResult
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableQueryResult build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableQueryResult(node, service, checks.build(), dns, datacenters, failovers);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_NODE) != 0) attributes.add("node");
      if ((initBits & INIT_BIT_SERVICE) != 0) attributes.add("service");
      return "Cannot build QueryResult, some of required attributes are not set " + attributes;
    }
  }
}
