package org.kiwiproject.consul.model.agent;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link Telemetry}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableTelemetry.builder()}.
 */
@Generated(from = "Telemetry", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
@JsonIgnoreProperties(ignoreUnknown = true)
public final class ImmutableTelemetry extends Telemetry {
  private final String statsiteAddr;
  private final String statsdAddr;
  private final String statsitePrefix;
  private final Boolean disableHostname;
  private final String dogStatsdAddr;
  private final @Nullable List<String> dogStatsdTags;

  private ImmutableTelemetry(
      String statsiteAddr,
      String statsdAddr,
      String statsitePrefix,
      Boolean disableHostname,
      String dogStatsdAddr,
      @Nullable List<String> dogStatsdTags) {
    this.statsiteAddr = statsiteAddr;
    this.statsdAddr = statsdAddr;
    this.statsitePrefix = statsitePrefix;
    this.disableHostname = disableHostname;
    this.dogStatsdAddr = dogStatsdAddr;
    this.dogStatsdTags = dogStatsdTags;
  }

  /**
   * @return The value of the {@code statsiteAddr} attribute
   */
  @JsonProperty("StatsiteAddr")
  @Override
  public String getStatsiteAddr() {
    return statsiteAddr;
  }

  /**
   * @return The value of the {@code statsdAddr} attribute
   */
  @JsonProperty("StatsdAddr")
  @Override
  public String getStatsdAddr() {
    return statsdAddr;
  }

  /**
   * @return The value of the {@code statsitePrefix} attribute
   */
  @JsonProperty("StatsitePrefix")
  @Override
  public String getStatsitePrefix() {
    return statsitePrefix;
  }

  /**
   * @return The value of the {@code disableHostname} attribute
   */
  @JsonProperty("DisableHostname")
  @Override
  public Boolean getDisableHostname() {
    return disableHostname;
  }

  /**
   * @return The value of the {@code dogStatsdAddr} attribute
   */
  @JsonProperty("DogStatsdAddr")
  @Override
  public String getDogStatsdAddr() {
    return dogStatsdAddr;
  }

  /**
   * @return The value of the {@code dogStatsdTags} attribute
   */
  @JsonProperty("DogStatsdTags")
  @Override
  public Optional<List<String>> getDogStatsdTags() {
    return Optional.ofNullable(dogStatsdTags);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Telemetry#getStatsiteAddr() statsiteAddr} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for statsiteAddr
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTelemetry withStatsiteAddr(String value) {
    String newValue = Objects.requireNonNull(value, "statsiteAddr");
    if (this.statsiteAddr.equals(newValue)) return this;
    return new ImmutableTelemetry(
        newValue,
        this.statsdAddr,
        this.statsitePrefix,
        this.disableHostname,
        this.dogStatsdAddr,
        this.dogStatsdTags);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Telemetry#getStatsdAddr() statsdAddr} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for statsdAddr
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTelemetry withStatsdAddr(String value) {
    String newValue = Objects.requireNonNull(value, "statsdAddr");
    if (this.statsdAddr.equals(newValue)) return this;
    return new ImmutableTelemetry(
        this.statsiteAddr,
        newValue,
        this.statsitePrefix,
        this.disableHostname,
        this.dogStatsdAddr,
        this.dogStatsdTags);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Telemetry#getStatsitePrefix() statsitePrefix} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for statsitePrefix
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTelemetry withStatsitePrefix(String value) {
    String newValue = Objects.requireNonNull(value, "statsitePrefix");
    if (this.statsitePrefix.equals(newValue)) return this;
    return new ImmutableTelemetry(
        this.statsiteAddr,
        this.statsdAddr,
        newValue,
        this.disableHostname,
        this.dogStatsdAddr,
        this.dogStatsdTags);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Telemetry#getDisableHostname() disableHostname} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for disableHostname
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTelemetry withDisableHostname(Boolean value) {
    Boolean newValue = Objects.requireNonNull(value, "disableHostname");
    if (this.disableHostname.equals(newValue)) return this;
    return new ImmutableTelemetry(
        this.statsiteAddr,
        this.statsdAddr,
        this.statsitePrefix,
        newValue,
        this.dogStatsdAddr,
        this.dogStatsdTags);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link Telemetry#getDogStatsdAddr() dogStatsdAddr} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for dogStatsdAddr
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTelemetry withDogStatsdAddr(String value) {
    String newValue = Objects.requireNonNull(value, "dogStatsdAddr");
    if (this.dogStatsdAddr.equals(newValue)) return this;
    return new ImmutableTelemetry(
        this.statsiteAddr,
        this.statsdAddr,
        this.statsitePrefix,
        this.disableHostname,
        newValue,
        this.dogStatsdTags);
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link Telemetry#getDogStatsdTags() dogStatsdTags} attribute.
   * @param value The value for dogStatsdTags
   * @return A modified copy of {@code this} object
   */
  public final ImmutableTelemetry withDogStatsdTags(List<String> value) {
    List<String> newValue = Objects.requireNonNull(value, "dogStatsdTags");
    if (this.dogStatsdTags == newValue) return this;
    return new ImmutableTelemetry(
        this.statsiteAddr,
        this.statsdAddr,
        this.statsitePrefix,
        this.disableHostname,
        this.dogStatsdAddr,
        newValue);
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link Telemetry#getDogStatsdTags() dogStatsdTags} attribute.
   * A shallow reference equality check is used on unboxed optional value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for dogStatsdTags
   * @return A modified copy of {@code this} object
   */
  @SuppressWarnings("unchecked") // safe covariant cast
  public final ImmutableTelemetry withDogStatsdTags(Optional<? extends List<String>> optional) {
    @Nullable List<String> value = optional.orElse(null);
    if (this.dogStatsdTags == value) return this;
    return new ImmutableTelemetry(
        this.statsiteAddr,
        this.statsdAddr,
        this.statsitePrefix,
        this.disableHostname,
        this.dogStatsdAddr,
        value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableTelemetry} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableTelemetry
        && equalTo(0, (ImmutableTelemetry) another);
  }

  private boolean equalTo(int synthetic, ImmutableTelemetry another) {
    return statsiteAddr.equals(another.statsiteAddr)
        && statsdAddr.equals(another.statsdAddr)
        && statsitePrefix.equals(another.statsitePrefix)
        && disableHostname.equals(another.disableHostname)
        && dogStatsdAddr.equals(another.dogStatsdAddr)
        && Objects.equals(dogStatsdTags, another.dogStatsdTags);
  }

  /**
   * Computes a hash code from attributes: {@code statsiteAddr}, {@code statsdAddr}, {@code statsitePrefix}, {@code disableHostname}, {@code dogStatsdAddr}, {@code dogStatsdTags}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + statsiteAddr.hashCode();
    h += (h << 5) + statsdAddr.hashCode();
    h += (h << 5) + statsitePrefix.hashCode();
    h += (h << 5) + disableHostname.hashCode();
    h += (h << 5) + dogStatsdAddr.hashCode();
    h += (h << 5) + Objects.hashCode(dogStatsdTags);
    return h;
  }

  /**
   * Prints the immutable value {@code Telemetry} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("Telemetry")
        .omitNullValues()
        .add("statsiteAddr", statsiteAddr)
        .add("statsdAddr", statsdAddr)
        .add("statsitePrefix", statsitePrefix)
        .add("disableHostname", disableHostname)
        .add("dogStatsdAddr", dogStatsdAddr)
        .add("dogStatsdTags", dogStatsdTags)
        .toString();
  }

  /**
   * Utility type used to correctly read immutable object from JSON representation.
   * @deprecated Do not use this type directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Generated(from = "Telemetry", generator = "Immutables")
  @Deprecated
  @SuppressWarnings("Immutable")
  @JsonDeserialize
  @JsonAutoDetect(fieldVisibility = JsonAutoDetect.Visibility.NONE)
  static final class Json extends Telemetry {
    @Nullable String statsiteAddr;
    @Nullable String statsdAddr;
    @Nullable String statsitePrefix;
    @Nullable Boolean disableHostname;
    @Nullable String dogStatsdAddr;
    @Nullable Optional<List<String>> dogStatsdTags = Optional.empty();
    @JsonProperty("StatsiteAddr")
    public void setStatsiteAddr(String statsiteAddr) {
      this.statsiteAddr = statsiteAddr;
    }
    @JsonProperty("StatsdAddr")
    public void setStatsdAddr(String statsdAddr) {
      this.statsdAddr = statsdAddr;
    }
    @JsonProperty("StatsitePrefix")
    public void setStatsitePrefix(String statsitePrefix) {
      this.statsitePrefix = statsitePrefix;
    }
    @JsonProperty("DisableHostname")
    public void setDisableHostname(Boolean disableHostname) {
      this.disableHostname = disableHostname;
    }
    @JsonProperty("DogStatsdAddr")
    public void setDogStatsdAddr(String dogStatsdAddr) {
      this.dogStatsdAddr = dogStatsdAddr;
    }
    @JsonProperty("DogStatsdTags")
    public void setDogStatsdTags(Optional<List<String>> dogStatsdTags) {
      this.dogStatsdTags = dogStatsdTags;
    }
    @Override
    public String getStatsiteAddr() { throw new UnsupportedOperationException(); }
    @Override
    public String getStatsdAddr() { throw new UnsupportedOperationException(); }
    @Override
    public String getStatsitePrefix() { throw new UnsupportedOperationException(); }
    @Override
    public Boolean getDisableHostname() { throw new UnsupportedOperationException(); }
    @Override
    public String getDogStatsdAddr() { throw new UnsupportedOperationException(); }
    @Override
    public Optional<List<String>> getDogStatsdTags() { throw new UnsupportedOperationException(); }
  }

  /**
   * @param json A JSON-bindable data structure
   * @return An immutable value type
   * @deprecated Do not use this method directly, it exists only for the <em>Jackson</em>-binding infrastructure
   */
  @Deprecated
  @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
  static ImmutableTelemetry fromJson(Json json) {
    ImmutableTelemetry.Builder builder = ImmutableTelemetry.builder();
    if (json.statsiteAddr != null) {
      builder.statsiteAddr(json.statsiteAddr);
    }
    if (json.statsdAddr != null) {
      builder.statsdAddr(json.statsdAddr);
    }
    if (json.statsitePrefix != null) {
      builder.statsitePrefix(json.statsitePrefix);
    }
    if (json.disableHostname != null) {
      builder.disableHostname(json.disableHostname);
    }
    if (json.dogStatsdAddr != null) {
      builder.dogStatsdAddr(json.dogStatsdAddr);
    }
    if (json.dogStatsdTags != null) {
      builder.dogStatsdTags(json.dogStatsdTags);
    }
    return builder.build();
  }

  /**
   * Creates an immutable copy of a {@link Telemetry} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable Telemetry instance
   */
  public static ImmutableTelemetry copyOf(Telemetry instance) {
    if (instance instanceof ImmutableTelemetry) {
      return (ImmutableTelemetry) instance;
    }
    return ImmutableTelemetry.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableTelemetry ImmutableTelemetry}.
   * <pre>
   * ImmutableTelemetry.builder()
   *    .statsiteAddr(String) // required {@link Telemetry#getStatsiteAddr() statsiteAddr}
   *    .statsdAddr(String) // required {@link Telemetry#getStatsdAddr() statsdAddr}
   *    .statsitePrefix(String) // required {@link Telemetry#getStatsitePrefix() statsitePrefix}
   *    .disableHostname(Boolean) // required {@link Telemetry#getDisableHostname() disableHostname}
   *    .dogStatsdAddr(String) // required {@link Telemetry#getDogStatsdAddr() dogStatsdAddr}
   *    .dogStatsdTags(List&amp;lt;String&amp;gt;) // optional {@link Telemetry#getDogStatsdTags() dogStatsdTags}
   *    .build();
   * </pre>
   * @return A new ImmutableTelemetry builder
   */
  public static ImmutableTelemetry.Builder builder() {
    return new ImmutableTelemetry.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableTelemetry ImmutableTelemetry}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "Telemetry", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_STATSITE_ADDR = 0x1L;
    private static final long INIT_BIT_STATSD_ADDR = 0x2L;
    private static final long INIT_BIT_STATSITE_PREFIX = 0x4L;
    private static final long INIT_BIT_DISABLE_HOSTNAME = 0x8L;
    private static final long INIT_BIT_DOG_STATSD_ADDR = 0x10L;
    private long initBits = 0x1fL;

    private @Nullable String statsiteAddr;
    private @Nullable String statsdAddr;
    private @Nullable String statsitePrefix;
    private @Nullable Boolean disableHostname;
    private @Nullable String dogStatsdAddr;
    private @Nullable List<String> dogStatsdTags;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code Telemetry} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(Telemetry instance) {
      Objects.requireNonNull(instance, "instance");
      this.statsiteAddr(instance.getStatsiteAddr());
      this.statsdAddr(instance.getStatsdAddr());
      this.statsitePrefix(instance.getStatsitePrefix());
      this.disableHostname(instance.getDisableHostname());
      this.dogStatsdAddr(instance.getDogStatsdAddr());
      Optional<List<String>> dogStatsdTagsOptional = instance.getDogStatsdTags();
      if (dogStatsdTagsOptional.isPresent()) {
        dogStatsdTags(dogStatsdTagsOptional);
      }
      return this;
    }

    /**
     * Initializes the value for the {@link Telemetry#getStatsiteAddr() statsiteAddr} attribute.
     * @param statsiteAddr The value for statsiteAddr 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("StatsiteAddr")
    public final Builder statsiteAddr(String statsiteAddr) {
      this.statsiteAddr = Objects.requireNonNull(statsiteAddr, "statsiteAddr");
      initBits &= ~INIT_BIT_STATSITE_ADDR;
      return this;
    }

    /**
     * Initializes the value for the {@link Telemetry#getStatsdAddr() statsdAddr} attribute.
     * @param statsdAddr The value for statsdAddr 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("StatsdAddr")
    public final Builder statsdAddr(String statsdAddr) {
      this.statsdAddr = Objects.requireNonNull(statsdAddr, "statsdAddr");
      initBits &= ~INIT_BIT_STATSD_ADDR;
      return this;
    }

    /**
     * Initializes the value for the {@link Telemetry#getStatsitePrefix() statsitePrefix} attribute.
     * @param statsitePrefix The value for statsitePrefix 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("StatsitePrefix")
    public final Builder statsitePrefix(String statsitePrefix) {
      this.statsitePrefix = Objects.requireNonNull(statsitePrefix, "statsitePrefix");
      initBits &= ~INIT_BIT_STATSITE_PREFIX;
      return this;
    }

    /**
     * Initializes the value for the {@link Telemetry#getDisableHostname() disableHostname} attribute.
     * @param disableHostname The value for disableHostname 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("DisableHostname")
    public final Builder disableHostname(Boolean disableHostname) {
      this.disableHostname = Objects.requireNonNull(disableHostname, "disableHostname");
      initBits &= ~INIT_BIT_DISABLE_HOSTNAME;
      return this;
    }

    /**
     * Initializes the value for the {@link Telemetry#getDogStatsdAddr() dogStatsdAddr} attribute.
     * @param dogStatsdAddr The value for dogStatsdAddr 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("DogStatsdAddr")
    public final Builder dogStatsdAddr(String dogStatsdAddr) {
      this.dogStatsdAddr = Objects.requireNonNull(dogStatsdAddr, "dogStatsdAddr");
      initBits &= ~INIT_BIT_DOG_STATSD_ADDR;
      return this;
    }

    /**
     * Initializes the optional value {@link Telemetry#getDogStatsdTags() dogStatsdTags} to dogStatsdTags.
     * @param dogStatsdTags The value for dogStatsdTags
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder dogStatsdTags(List<String> dogStatsdTags) {
      this.dogStatsdTags = Objects.requireNonNull(dogStatsdTags, "dogStatsdTags");
      return this;
    }

    /**
     * Initializes the optional value {@link Telemetry#getDogStatsdTags() dogStatsdTags} to dogStatsdTags.
     * @param dogStatsdTags The value for dogStatsdTags
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @JsonProperty("DogStatsdTags")
    public final Builder dogStatsdTags(Optional<? extends List<String>> dogStatsdTags) {
      this.dogStatsdTags = dogStatsdTags.orElse(null);
      return this;
    }

    /**
     * Builds a new {@link ImmutableTelemetry ImmutableTelemetry}.
     * @return An immutable instance of Telemetry
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableTelemetry build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableTelemetry(statsiteAddr, statsdAddr, statsitePrefix, disableHostname, dogStatsdAddr, dogStatsdTags);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_STATSITE_ADDR) != 0) attributes.add("statsiteAddr");
      if ((initBits & INIT_BIT_STATSD_ADDR) != 0) attributes.add("statsdAddr");
      if ((initBits & INIT_BIT_STATSITE_PREFIX) != 0) attributes.add("statsitePrefix");
      if ((initBits & INIT_BIT_DISABLE_HOSTNAME) != 0) attributes.add("disableHostname");
      if ((initBits & INIT_BIT_DOG_STATSD_ADDR) != 0) attributes.add("dogStatsdAddr");
      return "Cannot build Telemetry, some of required attributes are not set " + attributes;
    }
  }
}
