package org.kiwiproject.consul.option;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Booleans;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import jakarta.annotation.Nullable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link QueryOptions}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableQueryOptions.builder()}.
 */
@Generated(from = "QueryOptions", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
public final class ImmutableQueryOptions extends QueryOptions {
  private final ImmutableList<String> toQueryParameters;
  private final @Nullable String wait;
  private final @Nullable String token;
  private final @Nullable String hash;
  private final @Nullable BigInteger index;
  private final @Nullable String near;
  private final @Nullable String datacenter;
  private final @Nullable String filter;
  private final @Nullable String namespace;
  private final @Nullable Boolean wan;
  private final @Nullable String segment;
  private final @Nullable String note;
  private final @Nullable Boolean enable;
  private final @Nullable String reason;
  private final ImmutableList<String> nodeMeta;
  private final ImmutableList<String> tag;
  private final ConsistencyMode consistencyMode;
  private transient final boolean isBlocking;
  private transient final boolean hasToken;
  private transient final List<String> nodeMetaQuery;
  private transient final List<String> tagsQuery;

  private ImmutableQueryOptions(ImmutableQueryOptions.Builder builder) {
    this.toQueryParameters = builder.toQueryParameters.build();
    this.wait = builder.wait;
    this.token = builder.token;
    this.hash = builder.hash;
    this.index = builder.index;
    this.near = builder.near;
    this.datacenter = builder.datacenter;
    this.filter = builder.filter;
    this.namespace = builder.namespace;
    this.wan = builder.wan;
    this.segment = builder.segment;
    this.note = builder.note;
    this.enable = builder.enable;
    this.reason = builder.reason;
    this.nodeMeta = builder.nodeMeta.build();
    this.tag = builder.tag.build();
    if (builder.consistencyMode != null) {
      initShim.consistencyMode(builder.consistencyMode);
    }
    this.consistencyMode = initShim.getConsistencyMode();
    this.isBlocking = initShim.isBlocking();
    this.hasToken = initShim.hasToken();
    this.nodeMetaQuery = initShim.getNodeMetaQuery();
    this.tagsQuery = initShim.getTagsQuery();
    this.initShim = null;
  }

  private ImmutableQueryOptions(
      ImmutableList<String> toQueryParameters,
      @Nullable String wait,
      @Nullable String token,
      @Nullable String hash,
      @Nullable BigInteger index,
      @Nullable String near,
      @Nullable String datacenter,
      @Nullable String filter,
      @Nullable String namespace,
      @Nullable Boolean wan,
      @Nullable String segment,
      @Nullable String note,
      @Nullable Boolean enable,
      @Nullable String reason,
      ImmutableList<String> nodeMeta,
      ImmutableList<String> tag,
      ConsistencyMode consistencyMode) {
    this.toQueryParameters = toQueryParameters;
    this.wait = wait;
    this.token = token;
    this.hash = hash;
    this.index = index;
    this.near = near;
    this.datacenter = datacenter;
    this.filter = filter;
    this.namespace = namespace;
    this.wan = wan;
    this.segment = segment;
    this.note = note;
    this.enable = enable;
    this.reason = reason;
    this.nodeMeta = nodeMeta;
    this.tag = tag;
    initShim.consistencyMode(consistencyMode);
    this.consistencyMode = initShim.getConsistencyMode();
    this.isBlocking = initShim.isBlocking();
    this.hasToken = initShim.hasToken();
    this.nodeMetaQuery = initShim.getNodeMetaQuery();
    this.tagsQuery = initShim.getTagsQuery();
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  @SuppressWarnings("Immutable")
  private transient volatile InitShim initShim = new InitShim();

  @Generated(from = "QueryOptions", generator = "Immutables")
  private final class InitShim {
    private byte consistencyModeBuildStage = STAGE_UNINITIALIZED;
    private ConsistencyMode consistencyMode;

    ConsistencyMode getConsistencyMode() {
      if (consistencyModeBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (consistencyModeBuildStage == STAGE_UNINITIALIZED) {
        consistencyModeBuildStage = STAGE_INITIALIZING;
        this.consistencyMode = Objects.requireNonNull(ImmutableQueryOptions.super.getConsistencyMode(), "consistencyMode");
        consistencyModeBuildStage = STAGE_INITIALIZED;
      }
      return this.consistencyMode;
    }

    void consistencyMode(ConsistencyMode consistencyMode) {
      this.consistencyMode = consistencyMode;
      consistencyModeBuildStage = STAGE_INITIALIZED;
    }

    private byte isBlockingBuildStage = STAGE_UNINITIALIZED;
    private boolean isBlocking;

    boolean isBlocking() {
      if (isBlockingBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (isBlockingBuildStage == STAGE_UNINITIALIZED) {
        isBlockingBuildStage = STAGE_INITIALIZING;
        this.isBlocking = ImmutableQueryOptions.super.isBlocking();
        isBlockingBuildStage = STAGE_INITIALIZED;
      }
      return this.isBlocking;
    }

    private byte hasTokenBuildStage = STAGE_UNINITIALIZED;
    private boolean hasToken;

    boolean hasToken() {
      if (hasTokenBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (hasTokenBuildStage == STAGE_UNINITIALIZED) {
        hasTokenBuildStage = STAGE_INITIALIZING;
        this.hasToken = ImmutableQueryOptions.super.hasToken();
        hasTokenBuildStage = STAGE_INITIALIZED;
      }
      return this.hasToken;
    }

    private byte nodeMetaQueryBuildStage = STAGE_UNINITIALIZED;
    private List<String> nodeMetaQuery;

    List<String> getNodeMetaQuery() {
      if (nodeMetaQueryBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (nodeMetaQueryBuildStage == STAGE_UNINITIALIZED) {
        nodeMetaQueryBuildStage = STAGE_INITIALIZING;
        this.nodeMetaQuery = Objects.requireNonNull(ImmutableQueryOptions.super.getNodeMetaQuery(), "nodeMetaQuery");
        nodeMetaQueryBuildStage = STAGE_INITIALIZED;
      }
      return this.nodeMetaQuery;
    }

    private byte tagsQueryBuildStage = STAGE_UNINITIALIZED;
    private List<String> tagsQuery;

    List<String> getTagsQuery() {
      if (tagsQueryBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (tagsQueryBuildStage == STAGE_UNINITIALIZED) {
        tagsQueryBuildStage = STAGE_INITIALIZING;
        this.tagsQuery = Objects.requireNonNull(ImmutableQueryOptions.super.getTagsQuery(), "tagsQuery");
        tagsQueryBuildStage = STAGE_INITIALIZED;
      }
      return this.tagsQuery;
    }

    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      if (consistencyModeBuildStage == STAGE_INITIALIZING) attributes.add("consistencyMode");
      if (isBlockingBuildStage == STAGE_INITIALIZING) attributes.add("isBlocking");
      if (hasTokenBuildStage == STAGE_INITIALIZING) attributes.add("hasToken");
      if (nodeMetaQueryBuildStage == STAGE_INITIALIZING) attributes.add("nodeMetaQuery");
      if (tagsQueryBuildStage == STAGE_INITIALIZING) attributes.add("tagsQuery");
      return "Cannot build QueryOptions, attribute initializers form cycle " + attributes;
    }
  }

  /**
   * @return The value of the {@code toQueryParameters} attribute
   */
  @Override
  public ImmutableList<String> toQueryParameters() {
    return toQueryParameters;
  }

  /**
   * @return The value of the {@code wait} attribute
   */
  @Override
  public Optional<String> getWait() {
    return Optional.ofNullable(wait);
  }

  /**
   * @return The value of the {@code token} attribute
   */
  @Override
  public Optional<String> getToken() {
    return Optional.ofNullable(token);
  }

  /**
   * @return The value of the {@code hash} attribute
   */
  @Override
  public Optional<String> getHash() {
    return Optional.ofNullable(hash);
  }

  /**
   * @return The value of the {@code index} attribute
   */
  @Override
  public Optional<BigInteger> getIndex() {
    return Optional.ofNullable(index);
  }

  /**
   * @return The value of the {@code near} attribute
   */
  @Override
  public Optional<String> getNear() {
    return Optional.ofNullable(near);
  }

  /**
   * @return The value of the {@code datacenter} attribute
   */
  @Override
  public Optional<String> getDatacenter() {
    return Optional.ofNullable(datacenter);
  }

  /**
   * @return The value of the {@code filter} attribute
   */
  @Override
  public Optional<String> getFilter() {
    return Optional.ofNullable(filter);
  }

  /**
   * @return The value of the {@code namespace} attribute
   */
  @Override
  public Optional<String> getNamespace() {
    return Optional.ofNullable(namespace);
  }

  /**
   * @return The value of the {@code wan} attribute
   */
  @Override
  public Optional<Boolean> getWan() {
    return Optional.ofNullable(wan);
  }

  /**
   * @return The value of the {@code segment} attribute
   */
  @Override
  public Optional<String> getSegment() {
    return Optional.ofNullable(segment);
  }

  /**
   * @return The value of the {@code note} attribute
   */
  @Override
  public Optional<String> getNote() {
    return Optional.ofNullable(note);
  }

  /**
   * @return The value of the {@code enable} attribute
   */
  @Override
  public Optional<Boolean> getEnable() {
    return Optional.ofNullable(enable);
  }

  /**
   * @return The value of the {@code reason} attribute
   */
  @Override
  public Optional<String> getReason() {
    return Optional.ofNullable(reason);
  }

  /**
   * @return The value of the {@code nodeMeta} attribute
   */
  @Override
  public ImmutableList<String> getNodeMeta() {
    return nodeMeta;
  }

  /**
   * @return The value of the {@code tag} attribute
   */
  @Override
  public ImmutableList<String> getTag() {
    return tag;
  }

  /**
   * @return The value of the {@code consistencyMode} attribute
   */
  @Override
  public ConsistencyMode getConsistencyMode() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getConsistencyMode()
        : this.consistencyMode;
  }

  /**
   * @return The computed-at-construction value of the {@code isBlocking} attribute
   */
  @Override
  public boolean isBlocking() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.isBlocking()
        : this.isBlocking;
  }

  /**
   * @return The computed-at-construction value of the {@code hasToken} attribute
   */
  @Override
  public boolean hasToken() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.hasToken()
        : this.hasToken;
  }

  /**
   * @return The computed-at-construction value of the {@code nodeMetaQuery} attribute
   */
  @Override
  public List<String> getNodeMetaQuery() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getNodeMetaQuery()
        : this.nodeMetaQuery;
  }

  /**
   * @return The computed-at-construction value of the {@code tagsQuery} attribute
   */
  @Override
  public List<String> getTagsQuery() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getTagsQuery()
        : this.tagsQuery;
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link QueryOptions#toQueryParameters() toQueryParameters}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableQueryOptions withToQueryParameters(String... elements) {
    ImmutableList<String> newValue = ImmutableList.copyOf(elements);
    return validate(new ImmutableQueryOptions(
        newValue,
        this.wait,
        this.token,
        this.hash,
        this.index,
        this.near,
        this.datacenter,
        this.filter,
        this.namespace,
        this.wan,
        this.segment,
        this.note,
        this.enable,
        this.reason,
        this.nodeMeta,
        this.tag,
        this.consistencyMode));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link QueryOptions#toQueryParameters() toQueryParameters}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of toQueryParameters elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableQueryOptions withToQueryParameters(Iterable<String> elements) {
    if (this.toQueryParameters == elements) return this;
    ImmutableList<String> newValue = ImmutableList.copyOf(elements);
    return validate(new ImmutableQueryOptions(
        newValue,
        this.wait,
        this.token,
        this.hash,
        this.index,
        this.near,
        this.datacenter,
        this.filter,
        this.namespace,
        this.wan,
        this.segment,
        this.note,
        this.enable,
        this.reason,
        this.nodeMeta,
        this.tag,
        this.consistencyMode));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link QueryOptions#getWait() wait} attribute.
   * @param value The value for wait
   * @return A modified copy of {@code this} object
   */
  public final ImmutableQueryOptions withWait(String value) {
    String newValue = Objects.requireNonNull(value, "wait");
    if (Objects.equals(this.wait, newValue)) return this;
    return validate(new ImmutableQueryOptions(
        this.toQueryParameters,
        newValue,
        this.token,
        this.hash,
        this.index,
        this.near,
        this.datacenter,
        this.filter,
        this.namespace,
        this.wan,
        this.segment,
        this.note,
        this.enable,
        this.reason,
        this.nodeMeta,
        this.tag,
        this.consistencyMode));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link QueryOptions#getWait() wait} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for wait
   * @return A modified copy of {@code this} object
   */
  public final ImmutableQueryOptions withWait(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.wait, value)) return this;
    return validate(new ImmutableQueryOptions(
        this.toQueryParameters,
        value,
        this.token,
        this.hash,
        this.index,
        this.near,
        this.datacenter,
        this.filter,
        this.namespace,
        this.wan,
        this.segment,
        this.note,
        this.enable,
        this.reason,
        this.nodeMeta,
        this.tag,
        this.consistencyMode));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link QueryOptions#getToken() token} attribute.
   * @param value The value for token
   * @return A modified copy of {@code this} object
   */
  public final ImmutableQueryOptions withToken(String value) {
    String newValue = Objects.requireNonNull(value, "token");
    if (Objects.equals(this.token, newValue)) return this;
    return validate(new ImmutableQueryOptions(
        this.toQueryParameters,
        this.wait,
        newValue,
        this.hash,
        this.index,
        this.near,
        this.datacenter,
        this.filter,
        this.namespace,
        this.wan,
        this.segment,
        this.note,
        this.enable,
        this.reason,
        this.nodeMeta,
        this.tag,
        this.consistencyMode));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link QueryOptions#getToken() token} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for token
   * @return A modified copy of {@code this} object
   */
  public final ImmutableQueryOptions withToken(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.token, value)) return this;
    return validate(new ImmutableQueryOptions(
        this.toQueryParameters,
        this.wait,
        value,
        this.hash,
        this.index,
        this.near,
        this.datacenter,
        this.filter,
        this.namespace,
        this.wan,
        this.segment,
        this.note,
        this.enable,
        this.reason,
        this.nodeMeta,
        this.tag,
        this.consistencyMode));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link QueryOptions#getHash() hash} attribute.
   * @param value The value for hash
   * @return A modified copy of {@code this} object
   */
  public final ImmutableQueryOptions withHash(String value) {
    String newValue = Objects.requireNonNull(value, "hash");
    if (Objects.equals(this.hash, newValue)) return this;
    return validate(new ImmutableQueryOptions(
        this.toQueryParameters,
        this.wait,
        this.token,
        newValue,
        this.index,
        this.near,
        this.datacenter,
        this.filter,
        this.namespace,
        this.wan,
        this.segment,
        this.note,
        this.enable,
        this.reason,
        this.nodeMeta,
        this.tag,
        this.consistencyMode));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link QueryOptions#getHash() hash} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for hash
   * @return A modified copy of {@code this} object
   */
  public final ImmutableQueryOptions withHash(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.hash, value)) return this;
    return validate(new ImmutableQueryOptions(
        this.toQueryParameters,
        this.wait,
        this.token,
        value,
        this.index,
        this.near,
        this.datacenter,
        this.filter,
        this.namespace,
        this.wan,
        this.segment,
        this.note,
        this.enable,
        this.reason,
        this.nodeMeta,
        this.tag,
        this.consistencyMode));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link QueryOptions#getIndex() index} attribute.
   * @param value The value for index
   * @return A modified copy of {@code this} object
   */
  public final ImmutableQueryOptions withIndex(BigInteger value) {
    BigInteger newValue = Objects.requireNonNull(value, "index");
    if (Objects.equals(this.index, newValue)) return this;
    return validate(new ImmutableQueryOptions(
        this.toQueryParameters,
        this.wait,
        this.token,
        this.hash,
        newValue,
        this.near,
        this.datacenter,
        this.filter,
        this.namespace,
        this.wan,
        this.segment,
        this.note,
        this.enable,
        this.reason,
        this.nodeMeta,
        this.tag,
        this.consistencyMode));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link QueryOptions#getIndex() index} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for index
   * @return A modified copy of {@code this} object
   */
  @SuppressWarnings("unchecked") // safe covariant cast
  public final ImmutableQueryOptions withIndex(Optional<? extends BigInteger> optional) {
    @Nullable BigInteger value = optional.orElse(null);
    if (Objects.equals(this.index, value)) return this;
    return validate(new ImmutableQueryOptions(
        this.toQueryParameters,
        this.wait,
        this.token,
        this.hash,
        value,
        this.near,
        this.datacenter,
        this.filter,
        this.namespace,
        this.wan,
        this.segment,
        this.note,
        this.enable,
        this.reason,
        this.nodeMeta,
        this.tag,
        this.consistencyMode));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link QueryOptions#getNear() near} attribute.
   * @param value The value for near
   * @return A modified copy of {@code this} object
   */
  public final ImmutableQueryOptions withNear(String value) {
    String newValue = Objects.requireNonNull(value, "near");
    if (Objects.equals(this.near, newValue)) return this;
    return validate(new ImmutableQueryOptions(
        this.toQueryParameters,
        this.wait,
        this.token,
        this.hash,
        this.index,
        newValue,
        this.datacenter,
        this.filter,
        this.namespace,
        this.wan,
        this.segment,
        this.note,
        this.enable,
        this.reason,
        this.nodeMeta,
        this.tag,
        this.consistencyMode));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link QueryOptions#getNear() near} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for near
   * @return A modified copy of {@code this} object
   */
  public final ImmutableQueryOptions withNear(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.near, value)) return this;
    return validate(new ImmutableQueryOptions(
        this.toQueryParameters,
        this.wait,
        this.token,
        this.hash,
        this.index,
        value,
        this.datacenter,
        this.filter,
        this.namespace,
        this.wan,
        this.segment,
        this.note,
        this.enable,
        this.reason,
        this.nodeMeta,
        this.tag,
        this.consistencyMode));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link QueryOptions#getDatacenter() datacenter} attribute.
   * @param value The value for datacenter
   * @return A modified copy of {@code this} object
   */
  public final ImmutableQueryOptions withDatacenter(String value) {
    String newValue = Objects.requireNonNull(value, "datacenter");
    if (Objects.equals(this.datacenter, newValue)) return this;
    return validate(new ImmutableQueryOptions(
        this.toQueryParameters,
        this.wait,
        this.token,
        this.hash,
        this.index,
        this.near,
        newValue,
        this.filter,
        this.namespace,
        this.wan,
        this.segment,
        this.note,
        this.enable,
        this.reason,
        this.nodeMeta,
        this.tag,
        this.consistencyMode));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link QueryOptions#getDatacenter() datacenter} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for datacenter
   * @return A modified copy of {@code this} object
   */
  public final ImmutableQueryOptions withDatacenter(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.datacenter, value)) return this;
    return validate(new ImmutableQueryOptions(
        this.toQueryParameters,
        this.wait,
        this.token,
        this.hash,
        this.index,
        this.near,
        value,
        this.filter,
        this.namespace,
        this.wan,
        this.segment,
        this.note,
        this.enable,
        this.reason,
        this.nodeMeta,
        this.tag,
        this.consistencyMode));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link QueryOptions#getFilter() filter} attribute.
   * @param value The value for filter
   * @return A modified copy of {@code this} object
   */
  public final ImmutableQueryOptions withFilter(String value) {
    String newValue = Objects.requireNonNull(value, "filter");
    if (Objects.equals(this.filter, newValue)) return this;
    return validate(new ImmutableQueryOptions(
        this.toQueryParameters,
        this.wait,
        this.token,
        this.hash,
        this.index,
        this.near,
        this.datacenter,
        newValue,
        this.namespace,
        this.wan,
        this.segment,
        this.note,
        this.enable,
        this.reason,
        this.nodeMeta,
        this.tag,
        this.consistencyMode));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link QueryOptions#getFilter() filter} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for filter
   * @return A modified copy of {@code this} object
   */
  public final ImmutableQueryOptions withFilter(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.filter, value)) return this;
    return validate(new ImmutableQueryOptions(
        this.toQueryParameters,
        this.wait,
        this.token,
        this.hash,
        this.index,
        this.near,
        this.datacenter,
        value,
        this.namespace,
        this.wan,
        this.segment,
        this.note,
        this.enable,
        this.reason,
        this.nodeMeta,
        this.tag,
        this.consistencyMode));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link QueryOptions#getNamespace() namespace} attribute.
   * @param value The value for namespace
   * @return A modified copy of {@code this} object
   */
  public final ImmutableQueryOptions withNamespace(String value) {
    String newValue = Objects.requireNonNull(value, "namespace");
    if (Objects.equals(this.namespace, newValue)) return this;
    return validate(new ImmutableQueryOptions(
        this.toQueryParameters,
        this.wait,
        this.token,
        this.hash,
        this.index,
        this.near,
        this.datacenter,
        this.filter,
        newValue,
        this.wan,
        this.segment,
        this.note,
        this.enable,
        this.reason,
        this.nodeMeta,
        this.tag,
        this.consistencyMode));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link QueryOptions#getNamespace() namespace} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for namespace
   * @return A modified copy of {@code this} object
   */
  public final ImmutableQueryOptions withNamespace(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.namespace, value)) return this;
    return validate(new ImmutableQueryOptions(
        this.toQueryParameters,
        this.wait,
        this.token,
        this.hash,
        this.index,
        this.near,
        this.datacenter,
        this.filter,
        value,
        this.wan,
        this.segment,
        this.note,
        this.enable,
        this.reason,
        this.nodeMeta,
        this.tag,
        this.consistencyMode));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link QueryOptions#getWan() wan} attribute.
   * @param value The value for wan
   * @return A modified copy of {@code this} object
   */
  public final ImmutableQueryOptions withWan(boolean value) {
    @Nullable Boolean newValue = value;
    if (Objects.equals(this.wan, newValue)) return this;
    return validate(new ImmutableQueryOptions(
        this.toQueryParameters,
        this.wait,
        this.token,
        this.hash,
        this.index,
        this.near,
        this.datacenter,
        this.filter,
        this.namespace,
        newValue,
        this.segment,
        this.note,
        this.enable,
        this.reason,
        this.nodeMeta,
        this.tag,
        this.consistencyMode));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link QueryOptions#getWan() wan} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for wan
   * @return A modified copy of {@code this} object
   */
  public final ImmutableQueryOptions withWan(Optional<Boolean> optional) {
    @Nullable Boolean value = optional.orElse(null);
    if (Objects.equals(this.wan, value)) return this;
    return validate(new ImmutableQueryOptions(
        this.toQueryParameters,
        this.wait,
        this.token,
        this.hash,
        this.index,
        this.near,
        this.datacenter,
        this.filter,
        this.namespace,
        value,
        this.segment,
        this.note,
        this.enable,
        this.reason,
        this.nodeMeta,
        this.tag,
        this.consistencyMode));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link QueryOptions#getSegment() segment} attribute.
   * @param value The value for segment
   * @return A modified copy of {@code this} object
   */
  public final ImmutableQueryOptions withSegment(String value) {
    String newValue = Objects.requireNonNull(value, "segment");
    if (Objects.equals(this.segment, newValue)) return this;
    return validate(new ImmutableQueryOptions(
        this.toQueryParameters,
        this.wait,
        this.token,
        this.hash,
        this.index,
        this.near,
        this.datacenter,
        this.filter,
        this.namespace,
        this.wan,
        newValue,
        this.note,
        this.enable,
        this.reason,
        this.nodeMeta,
        this.tag,
        this.consistencyMode));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link QueryOptions#getSegment() segment} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for segment
   * @return A modified copy of {@code this} object
   */
  public final ImmutableQueryOptions withSegment(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.segment, value)) return this;
    return validate(new ImmutableQueryOptions(
        this.toQueryParameters,
        this.wait,
        this.token,
        this.hash,
        this.index,
        this.near,
        this.datacenter,
        this.filter,
        this.namespace,
        this.wan,
        value,
        this.note,
        this.enable,
        this.reason,
        this.nodeMeta,
        this.tag,
        this.consistencyMode));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link QueryOptions#getNote() note} attribute.
   * @param value The value for note
   * @return A modified copy of {@code this} object
   */
  public final ImmutableQueryOptions withNote(String value) {
    String newValue = Objects.requireNonNull(value, "note");
    if (Objects.equals(this.note, newValue)) return this;
    return validate(new ImmutableQueryOptions(
        this.toQueryParameters,
        this.wait,
        this.token,
        this.hash,
        this.index,
        this.near,
        this.datacenter,
        this.filter,
        this.namespace,
        this.wan,
        this.segment,
        newValue,
        this.enable,
        this.reason,
        this.nodeMeta,
        this.tag,
        this.consistencyMode));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link QueryOptions#getNote() note} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for note
   * @return A modified copy of {@code this} object
   */
  public final ImmutableQueryOptions withNote(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.note, value)) return this;
    return validate(new ImmutableQueryOptions(
        this.toQueryParameters,
        this.wait,
        this.token,
        this.hash,
        this.index,
        this.near,
        this.datacenter,
        this.filter,
        this.namespace,
        this.wan,
        this.segment,
        value,
        this.enable,
        this.reason,
        this.nodeMeta,
        this.tag,
        this.consistencyMode));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link QueryOptions#getEnable() enable} attribute.
   * @param value The value for enable
   * @return A modified copy of {@code this} object
   */
  public final ImmutableQueryOptions withEnable(boolean value) {
    @Nullable Boolean newValue = value;
    if (Objects.equals(this.enable, newValue)) return this;
    return validate(new ImmutableQueryOptions(
        this.toQueryParameters,
        this.wait,
        this.token,
        this.hash,
        this.index,
        this.near,
        this.datacenter,
        this.filter,
        this.namespace,
        this.wan,
        this.segment,
        this.note,
        newValue,
        this.reason,
        this.nodeMeta,
        this.tag,
        this.consistencyMode));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link QueryOptions#getEnable() enable} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for enable
   * @return A modified copy of {@code this} object
   */
  public final ImmutableQueryOptions withEnable(Optional<Boolean> optional) {
    @Nullable Boolean value = optional.orElse(null);
    if (Objects.equals(this.enable, value)) return this;
    return validate(new ImmutableQueryOptions(
        this.toQueryParameters,
        this.wait,
        this.token,
        this.hash,
        this.index,
        this.near,
        this.datacenter,
        this.filter,
        this.namespace,
        this.wan,
        this.segment,
        this.note,
        value,
        this.reason,
        this.nodeMeta,
        this.tag,
        this.consistencyMode));
  }

  /**
   * Copy the current immutable object by setting a <i>present</i> value for the optional {@link QueryOptions#getReason() reason} attribute.
   * @param value The value for reason
   * @return A modified copy of {@code this} object
   */
  public final ImmutableQueryOptions withReason(String value) {
    String newValue = Objects.requireNonNull(value, "reason");
    if (Objects.equals(this.reason, newValue)) return this;
    return validate(new ImmutableQueryOptions(
        this.toQueryParameters,
        this.wait,
        this.token,
        this.hash,
        this.index,
        this.near,
        this.datacenter,
        this.filter,
        this.namespace,
        this.wan,
        this.segment,
        this.note,
        this.enable,
        newValue,
        this.nodeMeta,
        this.tag,
        this.consistencyMode));
  }

  /**
   * Copy the current immutable object by setting an optional value for the {@link QueryOptions#getReason() reason} attribute.
   * An equality check is used on inner nullable value to prevent copying of the same value by returning {@code this}.
   * @param optional A value for reason
   * @return A modified copy of {@code this} object
   */
  public final ImmutableQueryOptions withReason(Optional<String> optional) {
    @Nullable String value = optional.orElse(null);
    if (Objects.equals(this.reason, value)) return this;
    return validate(new ImmutableQueryOptions(
        this.toQueryParameters,
        this.wait,
        this.token,
        this.hash,
        this.index,
        this.near,
        this.datacenter,
        this.filter,
        this.namespace,
        this.wan,
        this.segment,
        this.note,
        this.enable,
        value,
        this.nodeMeta,
        this.tag,
        this.consistencyMode));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link QueryOptions#getNodeMeta() nodeMeta}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableQueryOptions withNodeMeta(String... elements) {
    ImmutableList<String> newValue = ImmutableList.copyOf(elements);
    return validate(new ImmutableQueryOptions(
        this.toQueryParameters,
        this.wait,
        this.token,
        this.hash,
        this.index,
        this.near,
        this.datacenter,
        this.filter,
        this.namespace,
        this.wan,
        this.segment,
        this.note,
        this.enable,
        this.reason,
        newValue,
        this.tag,
        this.consistencyMode));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link QueryOptions#getNodeMeta() nodeMeta}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of nodeMeta elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableQueryOptions withNodeMeta(Iterable<String> elements) {
    if (this.nodeMeta == elements) return this;
    ImmutableList<String> newValue = ImmutableList.copyOf(elements);
    return validate(new ImmutableQueryOptions(
        this.toQueryParameters,
        this.wait,
        this.token,
        this.hash,
        this.index,
        this.near,
        this.datacenter,
        this.filter,
        this.namespace,
        this.wan,
        this.segment,
        this.note,
        this.enable,
        this.reason,
        newValue,
        this.tag,
        this.consistencyMode));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link QueryOptions#getTag() tag}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableQueryOptions withTag(String... elements) {
    ImmutableList<String> newValue = ImmutableList.copyOf(elements);
    return validate(new ImmutableQueryOptions(
        this.toQueryParameters,
        this.wait,
        this.token,
        this.hash,
        this.index,
        this.near,
        this.datacenter,
        this.filter,
        this.namespace,
        this.wan,
        this.segment,
        this.note,
        this.enable,
        this.reason,
        this.nodeMeta,
        newValue,
        this.consistencyMode));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link QueryOptions#getTag() tag}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of tag elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableQueryOptions withTag(Iterable<String> elements) {
    if (this.tag == elements) return this;
    ImmutableList<String> newValue = ImmutableList.copyOf(elements);
    return validate(new ImmutableQueryOptions(
        this.toQueryParameters,
        this.wait,
        this.token,
        this.hash,
        this.index,
        this.near,
        this.datacenter,
        this.filter,
        this.namespace,
        this.wan,
        this.segment,
        this.note,
        this.enable,
        this.reason,
        this.nodeMeta,
        newValue,
        this.consistencyMode));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link QueryOptions#getConsistencyMode() consistencyMode} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for consistencyMode
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableQueryOptions withConsistencyMode(ConsistencyMode value) {
    if (this.consistencyMode == value) return this;
    ConsistencyMode newValue = Objects.requireNonNull(value, "consistencyMode");
    return validate(new ImmutableQueryOptions(
        this.toQueryParameters,
        this.wait,
        this.token,
        this.hash,
        this.index,
        this.near,
        this.datacenter,
        this.filter,
        this.namespace,
        this.wan,
        this.segment,
        this.note,
        this.enable,
        this.reason,
        this.nodeMeta,
        this.tag,
        newValue));
  }

  /**
   * This instance is equal to all instances of {@code ImmutableQueryOptions} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableQueryOptions
        && equalTo(0, (ImmutableQueryOptions) another);
  }

  private boolean equalTo(int synthetic, ImmutableQueryOptions another) {
    return toQueryParameters.equals(another.toQueryParameters)
        && Objects.equals(wait, another.wait)
        && Objects.equals(token, another.token)
        && Objects.equals(hash, another.hash)
        && Objects.equals(index, another.index)
        && Objects.equals(near, another.near)
        && Objects.equals(datacenter, another.datacenter)
        && Objects.equals(filter, another.filter)
        && Objects.equals(namespace, another.namespace)
        && Objects.equals(wan, another.wan)
        && Objects.equals(segment, another.segment)
        && Objects.equals(note, another.note)
        && Objects.equals(enable, another.enable)
        && Objects.equals(reason, another.reason)
        && nodeMeta.equals(another.nodeMeta)
        && tag.equals(another.tag)
        && consistencyMode.equals(another.consistencyMode)
        && isBlocking == another.isBlocking
        && hasToken == another.hasToken
        && nodeMetaQuery.equals(another.nodeMetaQuery)
        && tagsQuery.equals(another.tagsQuery);
  }

  /**
   * Computes a hash code from attributes: {@code toQueryParameters}, {@code wait}, {@code token}, {@code hash}, {@code index}, {@code near}, {@code datacenter}, {@code filter}, {@code namespace}, {@code wan}, {@code segment}, {@code note}, {@code enable}, {@code reason}, {@code nodeMeta}, {@code tag}, {@code consistencyMode}, {@code isBlocking}, {@code hasToken}, {@code nodeMetaQuery}, {@code tagsQuery}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + toQueryParameters.hashCode();
    h += (h << 5) + Objects.hashCode(wait);
    h += (h << 5) + Objects.hashCode(token);
    h += (h << 5) + Objects.hashCode(hash);
    h += (h << 5) + Objects.hashCode(index);
    h += (h << 5) + Objects.hashCode(near);
    h += (h << 5) + Objects.hashCode(datacenter);
    h += (h << 5) + Objects.hashCode(filter);
    h += (h << 5) + Objects.hashCode(namespace);
    h += (h << 5) + Objects.hashCode(wan);
    h += (h << 5) + Objects.hashCode(segment);
    h += (h << 5) + Objects.hashCode(note);
    h += (h << 5) + Objects.hashCode(enable);
    h += (h << 5) + Objects.hashCode(reason);
    h += (h << 5) + nodeMeta.hashCode();
    h += (h << 5) + tag.hashCode();
    h += (h << 5) + consistencyMode.hashCode();
    h += (h << 5) + Booleans.hashCode(isBlocking);
    h += (h << 5) + Booleans.hashCode(hasToken);
    h += (h << 5) + nodeMetaQuery.hashCode();
    h += (h << 5) + tagsQuery.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code QueryOptions} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("QueryOptions")
        .omitNullValues()
        .add("toQueryParameters", toQueryParameters)
        .add("wait", wait)
        .add("token", token)
        .add("hash", hash)
        .add("index", index)
        .add("near", near)
        .add("datacenter", datacenter)
        .add("filter", filter)
        .add("namespace", namespace)
        .add("wan", wan)
        .add("segment", segment)
        .add("note", note)
        .add("enable", enable)
        .add("reason", reason)
        .add("nodeMeta", nodeMeta)
        .add("tag", tag)
        .add("consistencyMode", consistencyMode)
        .add("isBlocking", isBlocking)
        .add("hasToken", hasToken)
        .add("nodeMetaQuery", nodeMetaQuery)
        .add("tagsQuery", tagsQuery)
        .toString();
  }

  private static ImmutableQueryOptions validate(ImmutableQueryOptions instance) {
    instance.validate();
    return instance;
  }

  /**
   * Creates an immutable copy of a {@link QueryOptions} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable QueryOptions instance
   */
  public static ImmutableQueryOptions copyOf(QueryOptions instance) {
    if (instance instanceof ImmutableQueryOptions) {
      return (ImmutableQueryOptions) instance;
    }
    return ImmutableQueryOptions.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableQueryOptions ImmutableQueryOptions}.
   * <pre>
   * ImmutableQueryOptions.builder()
   *    .addToQueryParameters|addAllToQueryParameters(String) // {@link QueryOptions#toQueryParameters() toQueryParameters} elements
   *    .wait(String) // optional {@link QueryOptions#getWait() wait}
   *    .token(String) // optional {@link QueryOptions#getToken() token}
   *    .hash(String) // optional {@link QueryOptions#getHash() hash}
   *    .index(java.math.BigInteger) // optional {@link QueryOptions#getIndex() index}
   *    .near(String) // optional {@link QueryOptions#getNear() near}
   *    .datacenter(String) // optional {@link QueryOptions#getDatacenter() datacenter}
   *    .filter(String) // optional {@link QueryOptions#getFilter() filter}
   *    .namespace(String) // optional {@link QueryOptions#getNamespace() namespace}
   *    .wan(Boolean) // optional {@link QueryOptions#getWan() wan}
   *    .segment(String) // optional {@link QueryOptions#getSegment() segment}
   *    .note(String) // optional {@link QueryOptions#getNote() note}
   *    .enable(Boolean) // optional {@link QueryOptions#getEnable() enable}
   *    .reason(String) // optional {@link QueryOptions#getReason() reason}
   *    .addNodeMeta|addAllNodeMeta(String) // {@link QueryOptions#getNodeMeta() nodeMeta} elements
   *    .addTag|addAllTag(String) // {@link QueryOptions#getTag() tag} elements
   *    .consistencyMode(org.kiwiproject.consul.option.ConsistencyMode) // optional {@link QueryOptions#getConsistencyMode() consistencyMode}
   *    .build();
   * </pre>
   * @return A new ImmutableQueryOptions builder
   */
  public static ImmutableQueryOptions.Builder builder() {
    return new ImmutableQueryOptions.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableQueryOptions ImmutableQueryOptions}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "QueryOptions", generator = "Immutables")
  public static final class Builder {
    private ImmutableList.Builder<String> toQueryParameters = ImmutableList.builder();
    private @Nullable String wait;
    private @Nullable String token;
    private @Nullable String hash;
    private @Nullable BigInteger index;
    private @Nullable String near;
    private @Nullable String datacenter;
    private @Nullable String filter;
    private @Nullable String namespace;
    private @Nullable Boolean wan;
    private @Nullable String segment;
    private @Nullable String note;
    private @Nullable Boolean enable;
    private @Nullable String reason;
    private ImmutableList.Builder<String> nodeMeta = ImmutableList.builder();
    private ImmutableList.Builder<String> tag = ImmutableList.builder();
    private @Nullable ConsistencyMode consistencyMode;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.kiwiproject.consul.option.ParamAdder} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(ParamAdder instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.kiwiproject.consul.option.QueryOptions} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(QueryOptions instance) {
      Objects.requireNonNull(instance, "instance");
      from((short) 0, (Object) instance);
      return this;
    }

    private void from(short _unused, Object object) {
      if (object instanceof ParamAdder) {
        ParamAdder instance = (ParamAdder) object;
        addAllToQueryParameters(instance.toQueryParameters());
      }
      if (object instanceof QueryOptions) {
        QueryOptions instance = (QueryOptions) object;
        Optional<String> noteOptional = instance.getNote();
        if (noteOptional.isPresent()) {
          note(noteOptional);
        }
        Optional<String> reasonOptional = instance.getReason();
        if (reasonOptional.isPresent()) {
          reason(reasonOptional);
        }
        Optional<String> waitOptional = instance.getWait();
        if (waitOptional.isPresent()) {
          wait(waitOptional);
        }
        Optional<Boolean> wanOptional = instance.getWan();
        if (wanOptional.isPresent()) {
          wan(wanOptional);
        }
        Optional<BigInteger> indexOptional = instance.getIndex();
        if (indexOptional.isPresent()) {
          index(indexOptional);
        }
        Optional<String> datacenterOptional = instance.getDatacenter();
        if (datacenterOptional.isPresent()) {
          datacenter(datacenterOptional);
        }
        addAllNodeMeta(instance.getNodeMeta());
        Optional<String> tokenOptional = instance.getToken();
        if (tokenOptional.isPresent()) {
          token(tokenOptional);
        }
        Optional<String> filterOptional = instance.getFilter();
        if (filterOptional.isPresent()) {
          filter(filterOptional);
        }
        Optional<Boolean> enableOptional = instance.getEnable();
        if (enableOptional.isPresent()) {
          enable(enableOptional);
        }
        this.consistencyMode(instance.getConsistencyMode());
        Optional<String> segmentOptional = instance.getSegment();
        if (segmentOptional.isPresent()) {
          segment(segmentOptional);
        }
        Optional<String> namespaceOptional = instance.getNamespace();
        if (namespaceOptional.isPresent()) {
          namespace(namespaceOptional);
        }
        Optional<String> nearOptional = instance.getNear();
        if (nearOptional.isPresent()) {
          near(nearOptional);
        }
        addAllTag(instance.getTag());
        Optional<String> hashOptional = instance.getHash();
        if (hashOptional.isPresent()) {
          hash(hashOptional);
        }
      }
    }

    /**
     * Adds one element to {@link QueryOptions#toQueryParameters() toQueryParameters} list.
     * @param element A toQueryParameters element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addToQueryParameters(String element) {
      this.toQueryParameters.add(element);
      return this;
    }

    /**
     * Adds elements to {@link QueryOptions#toQueryParameters() toQueryParameters} list.
     * @param elements An array of toQueryParameters elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addToQueryParameters(String... elements) {
      this.toQueryParameters.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link QueryOptions#toQueryParameters() toQueryParameters} list.
     * @param elements An iterable of toQueryParameters elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder toQueryParameters(Iterable<String> elements) {
      this.toQueryParameters = ImmutableList.builder();
      return addAllToQueryParameters(elements);
    }

    /**
     * Adds elements to {@link QueryOptions#toQueryParameters() toQueryParameters} list.
     * @param elements An iterable of toQueryParameters elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllToQueryParameters(Iterable<String> elements) {
      this.toQueryParameters.addAll(elements);
      return this;
    }

    /**
     * Initializes the optional value {@link QueryOptions#getWait() wait} to wait.
     * @param wait The value for wait
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder wait(String wait) {
      this.wait = Objects.requireNonNull(wait, "wait");
      return this;
    }

    /**
     * Initializes the optional value {@link QueryOptions#getWait() wait} to wait.
     * @param wait The value for wait
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder wait(Optional<String> wait) {
      this.wait = wait.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link QueryOptions#getToken() token} to token.
     * @param token The value for token
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder token(String token) {
      this.token = Objects.requireNonNull(token, "token");
      return this;
    }

    /**
     * Initializes the optional value {@link QueryOptions#getToken() token} to token.
     * @param token The value for token
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder token(Optional<String> token) {
      this.token = token.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link QueryOptions#getHash() hash} to hash.
     * @param hash The value for hash
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder hash(String hash) {
      this.hash = Objects.requireNonNull(hash, "hash");
      return this;
    }

    /**
     * Initializes the optional value {@link QueryOptions#getHash() hash} to hash.
     * @param hash The value for hash
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder hash(Optional<String> hash) {
      this.hash = hash.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link QueryOptions#getIndex() index} to index.
     * @param index The value for index
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder index(BigInteger index) {
      this.index = Objects.requireNonNull(index, "index");
      return this;
    }

    /**
     * Initializes the optional value {@link QueryOptions#getIndex() index} to index.
     * @param index The value for index
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder index(Optional<? extends BigInteger> index) {
      this.index = index.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link QueryOptions#getNear() near} to near.
     * @param near The value for near
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder near(String near) {
      this.near = Objects.requireNonNull(near, "near");
      return this;
    }

    /**
     * Initializes the optional value {@link QueryOptions#getNear() near} to near.
     * @param near The value for near
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder near(Optional<String> near) {
      this.near = near.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link QueryOptions#getDatacenter() datacenter} to datacenter.
     * @param datacenter The value for datacenter
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder datacenter(String datacenter) {
      this.datacenter = Objects.requireNonNull(datacenter, "datacenter");
      return this;
    }

    /**
     * Initializes the optional value {@link QueryOptions#getDatacenter() datacenter} to datacenter.
     * @param datacenter The value for datacenter
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder datacenter(Optional<String> datacenter) {
      this.datacenter = datacenter.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link QueryOptions#getFilter() filter} to filter.
     * @param filter The value for filter
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder filter(String filter) {
      this.filter = Objects.requireNonNull(filter, "filter");
      return this;
    }

    /**
     * Initializes the optional value {@link QueryOptions#getFilter() filter} to filter.
     * @param filter The value for filter
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder filter(Optional<String> filter) {
      this.filter = filter.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link QueryOptions#getNamespace() namespace} to namespace.
     * @param namespace The value for namespace
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder namespace(String namespace) {
      this.namespace = Objects.requireNonNull(namespace, "namespace");
      return this;
    }

    /**
     * Initializes the optional value {@link QueryOptions#getNamespace() namespace} to namespace.
     * @param namespace The value for namespace
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder namespace(Optional<String> namespace) {
      this.namespace = namespace.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link QueryOptions#getWan() wan} to wan.
     * @param wan The value for wan
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder wan(boolean wan) {
      this.wan = wan;
      return this;
    }

    /**
     * Initializes the optional value {@link QueryOptions#getWan() wan} to wan.
     * @param wan The value for wan
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder wan(Optional<Boolean> wan) {
      this.wan = wan.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link QueryOptions#getSegment() segment} to segment.
     * @param segment The value for segment
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder segment(String segment) {
      this.segment = Objects.requireNonNull(segment, "segment");
      return this;
    }

    /**
     * Initializes the optional value {@link QueryOptions#getSegment() segment} to segment.
     * @param segment The value for segment
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder segment(Optional<String> segment) {
      this.segment = segment.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link QueryOptions#getNote() note} to note.
     * @param note The value for note
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder note(String note) {
      this.note = Objects.requireNonNull(note, "note");
      return this;
    }

    /**
     * Initializes the optional value {@link QueryOptions#getNote() note} to note.
     * @param note The value for note
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder note(Optional<String> note) {
      this.note = note.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link QueryOptions#getEnable() enable} to enable.
     * @param enable The value for enable
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder enable(boolean enable) {
      this.enable = enable;
      return this;
    }

    /**
     * Initializes the optional value {@link QueryOptions#getEnable() enable} to enable.
     * @param enable The value for enable
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder enable(Optional<Boolean> enable) {
      this.enable = enable.orElse(null);
      return this;
    }

    /**
     * Initializes the optional value {@link QueryOptions#getReason() reason} to reason.
     * @param reason The value for reason
     * @return {@code this} builder for chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder reason(String reason) {
      this.reason = Objects.requireNonNull(reason, "reason");
      return this;
    }

    /**
     * Initializes the optional value {@link QueryOptions#getReason() reason} to reason.
     * @param reason The value for reason
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder reason(Optional<String> reason) {
      this.reason = reason.orElse(null);
      return this;
    }

    /**
     * Adds one element to {@link QueryOptions#getNodeMeta() nodeMeta} list.
     * @param element A nodeMeta element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addNodeMeta(String element) {
      this.nodeMeta.add(element);
      return this;
    }

    /**
     * Adds elements to {@link QueryOptions#getNodeMeta() nodeMeta} list.
     * @param elements An array of nodeMeta elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addNodeMeta(String... elements) {
      this.nodeMeta.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link QueryOptions#getNodeMeta() nodeMeta} list.
     * @param elements An iterable of nodeMeta elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder nodeMeta(Iterable<String> elements) {
      this.nodeMeta = ImmutableList.builder();
      return addAllNodeMeta(elements);
    }

    /**
     * Adds elements to {@link QueryOptions#getNodeMeta() nodeMeta} list.
     * @param elements An iterable of nodeMeta elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllNodeMeta(Iterable<String> elements) {
      this.nodeMeta.addAll(elements);
      return this;
    }

    /**
     * Adds one element to {@link QueryOptions#getTag() tag} list.
     * @param element A tag element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addTag(String element) {
      this.tag.add(element);
      return this;
    }

    /**
     * Adds elements to {@link QueryOptions#getTag() tag} list.
     * @param elements An array of tag elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addTag(String... elements) {
      this.tag.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link QueryOptions#getTag() tag} list.
     * @param elements An iterable of tag elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder tag(Iterable<String> elements) {
      this.tag = ImmutableList.builder();
      return addAllTag(elements);
    }

    /**
     * Adds elements to {@link QueryOptions#getTag() tag} list.
     * @param elements An iterable of tag elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllTag(Iterable<String> elements) {
      this.tag.addAll(elements);
      return this;
    }

    /**
     * Initializes the value for the {@link QueryOptions#getConsistencyMode() consistencyMode} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link QueryOptions#getConsistencyMode() consistencyMode}.</em>
     * @param consistencyMode The value for consistencyMode 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder consistencyMode(ConsistencyMode consistencyMode) {
      this.consistencyMode = Objects.requireNonNull(consistencyMode, "consistencyMode");
      return this;
    }

    /**
     * Builds a new {@link ImmutableQueryOptions ImmutableQueryOptions}.
     * @return An immutable instance of QueryOptions
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableQueryOptions build() {
      return ImmutableQueryOptions.validate(new ImmutableQueryOptions(this));
    }
  }
}
