/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.consul.config;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.time.Duration;
import org.slf4j.Logger;

public class CacheConfig {
    @VisibleForTesting
    static final Duration DEFAULT_WATCH_DURATION = Duration.ofSeconds(10L);
    @VisibleForTesting
    static final Duration DEFAULT_BACKOFF_DELAY = Duration.ofSeconds(10L);
    @VisibleForTesting
    static final Duration DEFAULT_MIN_DELAY_BETWEEN_REQUESTS = Duration.ZERO;
    @VisibleForTesting
    static final Duration DEFAULT_MIN_DELAY_ON_EMPTY_RESULT = Duration.ZERO;
    @VisibleForTesting
    static final boolean DEFAULT_TIMEOUT_AUTO_ADJUSTMENT_ENABLED = true;
    @VisibleForTesting
    static final Duration DEFAULT_TIMEOUT_AUTO_ADJUSTMENT_MARGIN = Duration.ofSeconds(2L);
    @VisibleForTesting
    static final RefreshErrorLogConsumer DEFAULT_REFRESH_ERROR_LOG_CONSUMER = Logger::error;
    private final Duration watchDuration;
    private final Duration minBackOffDelay;
    private final Duration maxBackOffDelay;
    private final Duration minDelayBetweenRequests;
    private final Duration minDelayOnEmptyResult;
    private final Duration timeoutAutoAdjustmentMargin;
    private final boolean timeoutAutoAdjustmentEnabled;
    private final RefreshErrorLogConsumer refreshErrorLogConsumer;

    private CacheConfig(Duration watchDuration, Duration minBackOffDelay, Duration maxBackOffDelay, Duration minDelayBetweenRequests, Duration minDelayOnEmptyResult, boolean timeoutAutoAdjustmentEnabled, Duration timeoutAutoAdjustmentMargin, RefreshErrorLogConsumer refreshErrorLogConsumer) {
        this.watchDuration = watchDuration;
        this.minBackOffDelay = minBackOffDelay;
        this.maxBackOffDelay = maxBackOffDelay;
        this.minDelayBetweenRequests = minDelayBetweenRequests;
        this.minDelayOnEmptyResult = minDelayOnEmptyResult;
        this.timeoutAutoAdjustmentEnabled = timeoutAutoAdjustmentEnabled;
        this.timeoutAutoAdjustmentMargin = timeoutAutoAdjustmentMargin;
        this.refreshErrorLogConsumer = refreshErrorLogConsumer;
    }

    public Duration getWatchDuration() {
        return this.watchDuration;
    }

    public Duration getMinimumBackOffDelay() {
        return this.minBackOffDelay;
    }

    public Duration getMaximumBackOffDelay() {
        return this.maxBackOffDelay;
    }

    public boolean isTimeoutAutoAdjustmentEnabled() {
        return this.timeoutAutoAdjustmentEnabled;
    }

    public Duration getTimeoutAutoAdjustmentMargin() {
        return this.timeoutAutoAdjustmentMargin;
    }

    public Duration getMinimumDurationBetweenRequests() {
        return this.minDelayBetweenRequests;
    }

    public Duration getMinimumDurationDelayOnEmptyResult() {
        return this.minDelayOnEmptyResult;
    }

    public RefreshErrorLogConsumer getRefreshErrorLoggingConsumer() {
        return this.refreshErrorLogConsumer;
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonIgnoreType
    public static interface RefreshErrorLogConsumer {
        public void accept(Logger var1, String var2, Throwable var3);
    }

    public static class Builder {
        private static final String DELAY_CANNOT_BE_NULL = "Delay cannot be null";
        private Duration watchDuration = DEFAULT_WATCH_DURATION;
        private Duration minBackOffDelay = DEFAULT_BACKOFF_DELAY;
        private Duration maxBackOffDelay = DEFAULT_BACKOFF_DELAY;
        private Duration minDelayBetweenRequests = DEFAULT_MIN_DELAY_BETWEEN_REQUESTS;
        private Duration minDelayOnEmptyResult = DEFAULT_MIN_DELAY_ON_EMPTY_RESULT;
        private Duration timeoutAutoAdjustmentMargin = DEFAULT_TIMEOUT_AUTO_ADJUSTMENT_MARGIN;
        private boolean timeoutAutoAdjustmentEnabled = true;
        private RefreshErrorLogConsumer refreshErrorLogConsumer = DEFAULT_REFRESH_ERROR_LOG_CONSUMER;

        private Builder() {
        }

        public Builder withWatchDuration(Duration delay) {
            this.watchDuration = (Duration)Preconditions.checkNotNull((Object)delay, (Object)DELAY_CANNOT_BE_NULL);
            Preconditions.checkArgument((!delay.isNegative() ? 1 : 0) != 0, (Object)"Delay must be positive");
            return this;
        }

        public Builder withBackOffDelay(Duration delay) {
            this.minBackOffDelay = (Duration)Preconditions.checkNotNull((Object)delay, (Object)DELAY_CANNOT_BE_NULL);
            this.maxBackOffDelay = delay;
            Preconditions.checkArgument((!delay.isNegative() ? 1 : 0) != 0, (Object)"Delay must be positive");
            return this;
        }

        public Builder withBackOffDelay(Duration minDelay, Duration maxDelay) {
            this.minBackOffDelay = (Duration)Preconditions.checkNotNull((Object)minDelay, (Object)"Minimum delay cannot be null");
            this.maxBackOffDelay = (Duration)Preconditions.checkNotNull((Object)maxDelay, (Object)"Maximum delay cannot be null");
            Preconditions.checkArgument((!minDelay.isNegative() ? 1 : 0) != 0, (Object)"Minimum delay must be positive");
            Preconditions.checkArgument((!maxDelay.minus(minDelay).isNegative() ? 1 : 0) != 0, (Object)"Minimum delay must be less than maximum delay");
            return this;
        }

        public Builder withMinDelayBetweenRequests(Duration delay) {
            this.minDelayBetweenRequests = (Duration)Preconditions.checkNotNull((Object)delay, (Object)DELAY_CANNOT_BE_NULL);
            return this;
        }

        public Builder withMinDelayOnEmptyResult(Duration delay) {
            this.minDelayOnEmptyResult = (Duration)Preconditions.checkNotNull((Object)delay, (Object)DELAY_CANNOT_BE_NULL);
            return this;
        }

        public Builder withTimeoutAutoAdjustmentEnabled(boolean enabled) {
            this.timeoutAutoAdjustmentEnabled = enabled;
            return this;
        }

        public Builder withTimeoutAutoAdjustmentMargin(Duration margin) {
            this.timeoutAutoAdjustmentMargin = (Duration)Preconditions.checkNotNull((Object)margin, (Object)"Margin cannot be null");
            return this;
        }

        public Builder withRefreshErrorLoggedAsWarning() {
            this.refreshErrorLogConsumer = Logger::warn;
            return this;
        }

        public Builder withRefreshErrorLoggedAsError() {
            this.refreshErrorLogConsumer = Logger::error;
            return this;
        }

        public Builder withRefreshErrorLoggedAs(RefreshErrorLogConsumer fn) {
            this.refreshErrorLogConsumer = fn;
            return this;
        }

        public CacheConfig build() {
            return new CacheConfig(this.watchDuration, this.minBackOffDelay, this.maxBackOffDelay, this.minDelayBetweenRequests, this.minDelayOnEmptyResult, this.timeoutAutoAdjustmentEnabled, this.timeoutAutoAdjustmentMargin, this.refreshErrorLogConsumer);
        }
    }
}

