/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.consul.monitoring;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import okhttp3.Request;
import org.kiwiproject.consul.cache.CacheDescriptor;
import org.kiwiproject.consul.monitoring.ClientEventCallback;

public class ClientEventHandler {
    private static final ScheduledExecutorService EVENT_EXECUTOR = Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setNameFormat("event-executor-%s").setDaemon(true).build());
    private final String clientName;
    private final ClientEventCallback callback;

    public ClientEventHandler(String clientName, ClientEventCallback callback) {
        this.clientName = clientName;
        this.callback = callback;
    }

    public void httpRequestSuccess(Request request) {
        EVENT_EXECUTOR.submit(() -> this.callback.onHttpRequestSuccess(this.clientName, request.method(), request.url().query()));
    }

    public void httpRequestInvalid(Request request, Throwable throwable) {
        EVENT_EXECUTOR.submit(() -> this.callback.onHttpRequestInvalid(this.clientName, request.method(), request.url().query(), throwable));
    }

    public void httpRequestFailure(Request request, Throwable throwable) {
        EVENT_EXECUTOR.submit(() -> this.callback.onHttpRequestFailure(this.clientName, request.method(), request.url().query(), throwable));
    }

    public void cacheStart(CacheDescriptor cacheDescriptor) {
        EVENT_EXECUTOR.submit(() -> this.callback.onCacheStart(this.clientName, cacheDescriptor));
    }

    public void cacheStop(CacheDescriptor cacheDescriptor) {
        EVENT_EXECUTOR.submit(() -> this.callback.onCacheStop(this.clientName, cacheDescriptor));
    }

    public void cachePollingError(CacheDescriptor cacheDescriptor, Throwable throwable) {
        EVENT_EXECUTOR.submit(() -> this.callback.onCachePollingError(this.clientName, cacheDescriptor, throwable));
    }

    public void cachePollingSuccess(CacheDescriptor cacheDescriptor, boolean withNotification, Duration duration) {
        EVENT_EXECUTOR.submit(() -> this.callback.onCachePollingSuccess(this.clientName, cacheDescriptor, withNotification, duration));
    }

    public void cachePollingSuccess(CacheDescriptor cacheDescriptor, boolean withNotification, long duration) {
        EVENT_EXECUTOR.submit(() -> this.callback.onCachePollingSuccess(this.clientName, cacheDescriptor, withNotification, Duration.of(duration, ChronoUnit.MILLIS)));
    }

    public void stop() {
        EVENT_EXECUTOR.shutdownNow();
    }
}

