/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.consul.model.agent;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.immutables.value.Value;
import org.kiwiproject.consul.model.agent.ImmutableRegCheck;
import org.kiwiproject.consul.model.agent.ImmutableRegistration;
import org.kiwiproject.consul.model.catalog.ServiceWeights;

@JsonSerialize(as=ImmutableRegistration.class)
@JsonDeserialize(as=ImmutableRegistration.class)
@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@Value.Immutable
@Value.Style(jakarta=true)
public abstract class Registration {
    @JsonProperty(value="Name")
    public abstract String getName();

    @JsonProperty(value="Id")
    public abstract String getId();

    @JsonProperty(value="Address")
    public abstract Optional<String> getAddress();

    @JsonProperty(value="Port")
    public abstract Optional<Integer> getPort();

    @JsonProperty(value="Check")
    public abstract Optional<RegCheck> getCheck();

    @JsonProperty(value="Checks")
    public abstract List<RegCheck> getChecks();

    @JsonProperty(value="Tags")
    public abstract List<String> getTags();

    @JsonProperty(value="Meta")
    public abstract Map<String, String> getMeta();

    @JsonProperty(value="EnableTagOverride")
    public abstract Optional<Boolean> getEnableTagOverride();

    @JsonProperty(value="Weights")
    public abstract Optional<ServiceWeights> getServiceWeights();

    @JsonSerialize(as=ImmutableRegCheck.class)
    @JsonDeserialize(as=ImmutableRegCheck.class)
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @Value.Immutable
    public static abstract class RegCheck {
        @JsonProperty(value="CheckID")
        public abstract Optional<String> getId();

        @JsonProperty(value="Name")
        public abstract Optional<String> getName();

        @JsonProperty(value="Args")
        public abstract Optional<List<String>> getArgs();

        @JsonProperty(value="Interval")
        public abstract Optional<String> getInterval();

        @JsonProperty(value="TTL")
        public abstract Optional<String> getTtl();

        @JsonProperty(value="HTTP")
        public abstract Optional<String> getHttp();

        @JsonProperty(value="TCP")
        public abstract Optional<String> getTcp();

        @JsonProperty(value="GRPC")
        public abstract Optional<String> getGrpc();

        @JsonProperty(value="GRPCUseTLS")
        public abstract Optional<Boolean> getGrpcUseTls();

        @JsonProperty(value="Timeout")
        public abstract Optional<String> getTimeout();

        @JsonProperty(value="Notes")
        public abstract Optional<String> getNotes();

        @JsonProperty(value="DeregisterCriticalServiceAfter")
        public abstract Optional<String> getDeregisterCriticalServiceAfter();

        @JsonProperty(value="TLSSkipVerify")
        public abstract Optional<Boolean> getTlsSkipVerify();

        @JsonProperty(value="Status")
        public abstract Optional<String> getStatus();

        @JsonProperty(value="SuccessBeforePassing")
        public abstract Optional<Integer> getSuccessBeforePassing();

        @JsonProperty(value="FailuresBeforeCritical")
        public abstract Optional<Integer> getFailuresBeforeCritical();

        public static RegCheck ttl(long ttl) {
            return ImmutableRegCheck.builder().ttl(String.format("%ss", ttl)).build();
        }

        public static RegCheck args(List<String> args, long interval) {
            return ImmutableRegCheck.builder().args(args).interval(String.format("%ss", interval)).build();
        }

        public static RegCheck args(List<String> args, long interval, long timeout) {
            return ImmutableRegCheck.builder().args(args).interval(String.format("%ss", interval)).timeout(String.format("%ss", timeout)).build();
        }

        public static RegCheck args(List<String> args, long interval, long timeout, String notes) {
            return ImmutableRegCheck.builder().args(args).interval(String.format("%ss", interval)).timeout(String.format("%ss", timeout)).notes(notes).build();
        }

        public static RegCheck http(String http, long interval) {
            return ImmutableRegCheck.builder().http(http).interval(String.format("%ss", interval)).build();
        }

        public static RegCheck http(String http, long interval, long timeout) {
            return ImmutableRegCheck.builder().http(http).interval(String.format("%ss", interval)).timeout(String.format("%ss", timeout)).build();
        }

        public static RegCheck http(String http, long interval, long timeout, String notes) {
            return ImmutableRegCheck.builder().http(http).interval(String.format("%ss", interval)).timeout(String.format("%ss", timeout)).notes(notes).build();
        }

        public static RegCheck tcp(String tcp, long interval) {
            return ImmutableRegCheck.builder().tcp(tcp).interval(String.format("%ss", interval)).build();
        }

        public static RegCheck tcp(String tcp, long interval, long timeout) {
            return ImmutableRegCheck.builder().tcp(tcp).interval(String.format("%ss", interval)).timeout(String.format("%ss", timeout)).build();
        }

        public static RegCheck tcp(String tcp, long interval, long timeout, String notes) {
            return ImmutableRegCheck.builder().tcp(tcp).interval(String.format("%ss", interval)).timeout(String.format("%ss", timeout)).notes(notes).build();
        }

        public static RegCheck grpc(String grpc, long interval) {
            return RegCheck.grpc(grpc, interval, false);
        }

        public static RegCheck grpc(String grpc, long interval, boolean useTls) {
            return ImmutableRegCheck.builder().grpc(grpc).grpcUseTls(useTls).interval(String.format("%ss", interval)).build();
        }

        @Value.Check
        protected void validate() {
            Preconditions.checkState((this.getHttp().isPresent() || this.getTtl().isPresent() || this.getArgs().isPresent() || this.getTcp().isPresent() || this.getGrpc().isPresent() ? 1 : 0) != 0, (Object)"Check must specify either http, tcp, ttl, grpc or args");
            if (this.getHttp().isPresent() || this.getArgs().isPresent() || this.getTcp().isPresent() || this.getGrpc().isPresent()) {
                Preconditions.checkState((boolean)this.getInterval().isPresent(), (Object)"Interval must be set if check type is http, tcp, grpc or args");
            }
        }
    }
}

