/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.consul.model.event;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import org.immutables.value.Generated;
import org.kiwiproject.consul.model.event.Event;
import org.kiwiproject.consul.util.Base64EncodingDeserializer;

@Generated(from="Event", generator="Immutables")
public final class ImmutableEvent
extends Event {
    private final String id;
    private final String name;
    @Nullable
    private final String payload;
    @Nullable
    private final String nodeFilter;
    @Nullable
    private final String serviceFilter;
    @Nullable
    private final String tagFilter;
    private final int version;
    private final Long lTime;

    private ImmutableEvent(String id, String name, @Nullable String payload, @Nullable String nodeFilter, @Nullable String serviceFilter, @Nullable String tagFilter, int version, Long lTime) {
        this.id = id;
        this.name = name;
        this.payload = payload;
        this.nodeFilter = nodeFilter;
        this.serviceFilter = serviceFilter;
        this.tagFilter = tagFilter;
        this.version = version;
        this.lTime = lTime;
    }

    @Override
    @JsonProperty(value="ID")
    public String getId() {
        return this.id;
    }

    @Override
    @JsonProperty(value="Name")
    public String getName() {
        return this.name;
    }

    @Override
    @JsonProperty(value="Payload")
    @JsonDeserialize(using=Base64EncodingDeserializer.class)
    public Optional<String> getPayload() {
        return Optional.ofNullable(this.payload);
    }

    @Override
    @JsonProperty(value="NodeFilter")
    public Optional<String> getNodeFilter() {
        return Optional.ofNullable(this.nodeFilter);
    }

    @Override
    @JsonProperty(value="ServiceFilter")
    public Optional<String> getServiceFilter() {
        return Optional.ofNullable(this.serviceFilter);
    }

    @Override
    @JsonProperty(value="TagFilter")
    public Optional<String> getTagFilter() {
        return Optional.ofNullable(this.tagFilter);
    }

    @Override
    @JsonProperty(value="Version")
    public int getVersion() {
        return this.version;
    }

    @Override
    @JsonProperty(value="LTime")
    public Long getLTime() {
        return this.lTime;
    }

    public final ImmutableEvent withId(String value) {
        String newValue = Objects.requireNonNull(value, "id");
        if (this.id.equals(newValue)) {
            return this;
        }
        return new ImmutableEvent(newValue, this.name, this.payload, this.nodeFilter, this.serviceFilter, this.tagFilter, this.version, this.lTime);
    }

    public final ImmutableEvent withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new ImmutableEvent(this.id, newValue, this.payload, this.nodeFilter, this.serviceFilter, this.tagFilter, this.version, this.lTime);
    }

    public final ImmutableEvent withPayload(String value) {
        String newValue = Objects.requireNonNull(value, "payload");
        if (Objects.equals(this.payload, newValue)) {
            return this;
        }
        return new ImmutableEvent(this.id, this.name, newValue, this.nodeFilter, this.serviceFilter, this.tagFilter, this.version, this.lTime);
    }

    public final ImmutableEvent withPayload(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.payload, value)) {
            return this;
        }
        return new ImmutableEvent(this.id, this.name, value, this.nodeFilter, this.serviceFilter, this.tagFilter, this.version, this.lTime);
    }

    public final ImmutableEvent withNodeFilter(String value) {
        String newValue = Objects.requireNonNull(value, "nodeFilter");
        if (Objects.equals(this.nodeFilter, newValue)) {
            return this;
        }
        return new ImmutableEvent(this.id, this.name, this.payload, newValue, this.serviceFilter, this.tagFilter, this.version, this.lTime);
    }

    public final ImmutableEvent withNodeFilter(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.nodeFilter, value)) {
            return this;
        }
        return new ImmutableEvent(this.id, this.name, this.payload, value, this.serviceFilter, this.tagFilter, this.version, this.lTime);
    }

    public final ImmutableEvent withServiceFilter(String value) {
        String newValue = Objects.requireNonNull(value, "serviceFilter");
        if (Objects.equals(this.serviceFilter, newValue)) {
            return this;
        }
        return new ImmutableEvent(this.id, this.name, this.payload, this.nodeFilter, newValue, this.tagFilter, this.version, this.lTime);
    }

    public final ImmutableEvent withServiceFilter(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.serviceFilter, value)) {
            return this;
        }
        return new ImmutableEvent(this.id, this.name, this.payload, this.nodeFilter, value, this.tagFilter, this.version, this.lTime);
    }

    public final ImmutableEvent withTagFilter(String value) {
        String newValue = Objects.requireNonNull(value, "tagFilter");
        if (Objects.equals(this.tagFilter, newValue)) {
            return this;
        }
        return new ImmutableEvent(this.id, this.name, this.payload, this.nodeFilter, this.serviceFilter, newValue, this.version, this.lTime);
    }

    public final ImmutableEvent withTagFilter(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.tagFilter, value)) {
            return this;
        }
        return new ImmutableEvent(this.id, this.name, this.payload, this.nodeFilter, this.serviceFilter, value, this.version, this.lTime);
    }

    public final ImmutableEvent withVersion(int value) {
        if (this.version == value) {
            return this;
        }
        return new ImmutableEvent(this.id, this.name, this.payload, this.nodeFilter, this.serviceFilter, this.tagFilter, value, this.lTime);
    }

    public final ImmutableEvent withLTime(Long value) {
        Long newValue = Objects.requireNonNull(value, "lTime");
        if (this.lTime.equals(newValue)) {
            return this;
        }
        return new ImmutableEvent(this.id, this.name, this.payload, this.nodeFilter, this.serviceFilter, this.tagFilter, this.version, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableEvent && this.equalsByValue((ImmutableEvent)another);
    }

    private boolean equalsByValue(ImmutableEvent another) {
        return this.id.equals(another.id) && this.name.equals(another.name) && Objects.equals(this.payload, another.payload) && Objects.equals(this.nodeFilter, another.nodeFilter) && Objects.equals(this.serviceFilter, another.serviceFilter) && Objects.equals(this.tagFilter, another.tagFilter) && this.version == another.version && this.lTime.equals(another.lTime);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.id.hashCode();
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + Objects.hashCode(this.payload);
        h += (h << 5) + Objects.hashCode(this.nodeFilter);
        h += (h << 5) + Objects.hashCode(this.serviceFilter);
        h += (h << 5) + Objects.hashCode(this.tagFilter);
        h += (h << 5) + this.version;
        h += (h << 5) + this.lTime.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Event").omitNullValues().add("id", (Object)this.id).add("name", (Object)this.name).add("payload", (Object)this.payload).add("nodeFilter", (Object)this.nodeFilter).add("serviceFilter", (Object)this.serviceFilter).add("tagFilter", (Object)this.tagFilter).add("version", this.version).add("lTime", (Object)this.lTime).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableEvent fromJson(Json json) {
        Builder builder = ImmutableEvent.builder();
        if (json._id != null) {
            builder.id(json._id);
        }
        if (json._name != null) {
            builder.name(json._name);
        }
        if (json._payload != null) {
            builder.payload(json._payload);
        }
        if (json._nodeFilter != null) {
            builder.nodeFilter(json._nodeFilter);
        }
        if (json._serviceFilter != null) {
            builder.serviceFilter(json._serviceFilter);
        }
        if (json._tagFilter != null) {
            builder.tagFilter(json._tagFilter);
        }
        if (json.versionIsSet) {
            builder.version(json._version);
        }
        if (json._lTime != null) {
            builder.lTime(json._lTime);
        }
        return builder.build();
    }

    public static ImmutableEvent copyOf(Event instance) {
        if (instance instanceof ImmutableEvent) {
            return (ImmutableEvent)instance;
        }
        return ImmutableEvent.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="Event", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long INIT_BIT_NAME = 2L;
        private static final long INIT_BIT_VERSION = 4L;
        private static final long INIT_BIT_L_TIME = 8L;
        private long initBits = 15L;
        @Nullable
        private String id;
        @Nullable
        private String name;
        @Nullable
        private String payload;
        @Nullable
        private String nodeFilter;
        @Nullable
        private String serviceFilter;
        @Nullable
        private String tagFilter;
        private int version;
        @Nullable
        private Long lTime;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(Event instance) {
            Optional<String> tagFilterOptional;
            Optional<String> serviceFilterOptional;
            Optional<String> nodeFilterOptional;
            Objects.requireNonNull(instance, "instance");
            this.id(instance.getId());
            this.name(instance.getName());
            Optional<String> payloadOptional = instance.getPayload();
            if (payloadOptional.isPresent()) {
                this.payload(payloadOptional);
            }
            if ((nodeFilterOptional = instance.getNodeFilter()).isPresent()) {
                this.nodeFilter(nodeFilterOptional);
            }
            if ((serviceFilterOptional = instance.getServiceFilter()).isPresent()) {
                this.serviceFilter(serviceFilterOptional);
            }
            if ((tagFilterOptional = instance.getTagFilter()).isPresent()) {
                this.tagFilter(tagFilterOptional);
            }
            this.version(instance.getVersion());
            this.lTime(instance.getLTime());
            return this;
        }

        @JsonProperty(value="ID")
        @CanIgnoreReturnValue
        public final Builder id(String id) {
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="Name")
        @CanIgnoreReturnValue
        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder payload(String payload) {
            this.payload = Objects.requireNonNull(payload, "payload");
            return this;
        }

        @JsonProperty(value="Payload")
        @JsonDeserialize(using=Base64EncodingDeserializer.class)
        @CanIgnoreReturnValue
        public final Builder payload(Optional<String> payload) {
            this.payload = payload.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder nodeFilter(String nodeFilter) {
            this.nodeFilter = Objects.requireNonNull(nodeFilter, "nodeFilter");
            return this;
        }

        @JsonProperty(value="NodeFilter")
        @CanIgnoreReturnValue
        public final Builder nodeFilter(Optional<String> nodeFilter) {
            this.nodeFilter = nodeFilter.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder serviceFilter(String serviceFilter) {
            this.serviceFilter = Objects.requireNonNull(serviceFilter, "serviceFilter");
            return this;
        }

        @JsonProperty(value="ServiceFilter")
        @CanIgnoreReturnValue
        public final Builder serviceFilter(Optional<String> serviceFilter) {
            this.serviceFilter = serviceFilter.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder tagFilter(String tagFilter) {
            this.tagFilter = Objects.requireNonNull(tagFilter, "tagFilter");
            return this;
        }

        @JsonProperty(value="TagFilter")
        @CanIgnoreReturnValue
        public final Builder tagFilter(Optional<String> tagFilter) {
            this.tagFilter = tagFilter.orElse(null);
            return this;
        }

        @JsonProperty(value="Version")
        @CanIgnoreReturnValue
        public final Builder version(int version) {
            this.version = version;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @JsonProperty(value="LTime")
        @CanIgnoreReturnValue
        public final Builder lTime(Long lTime) {
            this.lTime = Objects.requireNonNull(lTime, "lTime");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public ImmutableEvent build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableEvent(this.id, this.name, this.payload, this.nodeFilter, this.serviceFilter, this.tagFilter, this.version, this.lTime);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("name");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("version");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("lTime");
            }
            return "Cannot build Event, some of required attributes are not set " + String.valueOf(attributes);
        }
    }

    @Deprecated
    @JsonDeserialize
    @Generated(from="Event", generator="Immutables")
    static final class Json
    extends Event {
        @JsonIgnore
        @Nullable
        String _id;
        @JsonIgnore
        @Nullable
        String _name;
        @JsonIgnore
        @Nullable
        Optional<String> _payload = Optional.empty();
        @JsonIgnore
        @Nullable
        Optional<String> _nodeFilter = Optional.empty();
        @JsonIgnore
        @Nullable
        Optional<String> _serviceFilter = Optional.empty();
        @JsonIgnore
        @Nullable
        Optional<String> _tagFilter = Optional.empty();
        @JsonIgnore
        int _version;
        @JsonIgnore
        boolean versionIsSet;
        @JsonIgnore
        @Nullable
        Long _lTime;

        Json() {
        }

        @JsonProperty(value="ID")
        public void setId(String id) {
            this._id = id;
        }

        @JsonProperty(value="Name")
        public void setName(String name) {
            this._name = name;
        }

        @JsonProperty(value="Payload")
        @JsonDeserialize(using=Base64EncodingDeserializer.class)
        public void setPayload(Optional<String> payload) {
            this._payload = payload;
        }

        @JsonProperty(value="NodeFilter")
        public void setNodeFilter(Optional<String> nodeFilter) {
            this._nodeFilter = nodeFilter;
        }

        @JsonProperty(value="ServiceFilter")
        public void setServiceFilter(Optional<String> serviceFilter) {
            this._serviceFilter = serviceFilter;
        }

        @JsonProperty(value="TagFilter")
        public void setTagFilter(Optional<String> tagFilter) {
            this._tagFilter = tagFilter;
        }

        @JsonProperty(value="Version")
        public void setVersion(int version) {
            this._version = version;
            this.versionIsSet = true;
        }

        @JsonProperty(value="LTime")
        public void setLTime(Long lTime) {
            this._lTime = lTime;
        }

        @Override
        public String getId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getPayload() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getNodeFilter() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getServiceFilter() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getTagFilter() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getVersion() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Long getLTime() {
            throw new UnsupportedOperationException();
        }
    }
}

