/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.consul.option;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jspecify.annotations.Nullable;

public class ConsistencyMode {
    public static final ConsistencyMode DEFAULT = new ConsistencyMode("DEFAULT", 0, null);
    public static final ConsistencyMode STALE = new ConsistencyMode("STALE", 1, "stale");
    public static final ConsistencyMode CONSISTENT = new ConsistencyMode("CONSISTENT", 2, "consistent");
    private final String name;
    private final int ordinal;
    private final String param;
    private final Map<String, String> additionalHeaders;

    private ConsistencyMode(String name, int ordinal, String param) {
        this(name, ordinal, param, Map.of());
    }

    private ConsistencyMode(String name, int ordinal, String param, Map<String, String> headers) {
        this.name = name;
        this.ordinal = ordinal;
        this.param = param;
        this.additionalHeaders = headers;
    }

    public final Optional<String> toParam() {
        return Optional.ofNullable(this.param);
    }

    public final Map<String, String> getAdditionalHeaders() {
        return this.additionalHeaders;
    }

    @Deprecated(since="1.8.0", forRemoval=true)
    public static ConsistencyMode createCachedConsistencyWithMaxAgeAndStale(Optional<Long> maxAgeInSeconds, Optional<Long> maxStaleInSeconds) {
        return ConsistencyMode.createCachedConsistencyWithMaxAgeAndStale(maxAgeInSeconds.orElse(null), maxStaleInSeconds.orElse(null));
    }

    public static ConsistencyMode createCachedConsistencyWithMaxAgeAndStale(@Nullable Long maxAgeInSeconds, @Nullable Long maxStaleInSeconds) {
        Object maxAge = "";
        if (Objects.nonNull(maxAgeInSeconds)) {
            if (maxAgeInSeconds < 0L) {
                throw new IllegalArgumentException("maxAgeInSeconds must be greater than or equal to 0");
            }
            maxAge = (String)maxAge + String.format("max-age=%d", maxAgeInSeconds);
        }
        if (Objects.nonNull(maxStaleInSeconds)) {
            if (maxStaleInSeconds < 0L) {
                throw new IllegalArgumentException("maxStaleInSeconds must be greater than or equal to 0");
            }
            if (!((String)maxAge).isEmpty()) {
                maxAge = (String)maxAge + ",";
            }
            maxAge = (String)maxAge + String.format("stale-if-error=%d", maxStaleInSeconds);
        }
        Map<Object, Object> headers = ((String)maxAge).isEmpty() ? Map.of() : Map.of("Cache-Control", maxAge);
        return new ConsistencyMode("CACHED", 3, "cached", headers);
    }

    public final String name() {
        return this.name;
    }

    public final String toString() {
        StringBuilder builder = new StringBuilder(this.name());
        for (Map.Entry<String, String> entry : this.getAdditionalHeaders().entrySet()) {
            builder.append(String.format("[%s=%s]", entry.getKey(), entry.getValue()));
        }
        return builder.toString();
    }

    public int ordinal() {
        return this.ordinal;
    }

    public static ConsistencyMode[] values() {
        ConsistencyMode[] res = new ConsistencyMode[]{DEFAULT, STALE, CONSISTENT};
        return res;
    }
}

