/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.consul;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.net.HostAndPort;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.net.Proxy;
import java.net.URL;
import java.time.Duration;
import java.util.Base64;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.IntSupplier;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.X509TrustManager;
import okhttp3.ConnectionPool;
import okhttp3.Dispatcher;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import org.jspecify.annotations.Nullable;
import org.kiwiproject.consul.AclClient;
import org.kiwiproject.consul.AgentClient;
import org.kiwiproject.consul.CatalogClient;
import org.kiwiproject.consul.CoordinateClient;
import org.kiwiproject.consul.EventClient;
import org.kiwiproject.consul.HealthClient;
import org.kiwiproject.consul.KeyValueClient;
import org.kiwiproject.consul.OperatorClient;
import org.kiwiproject.consul.PreparedQueryClient;
import org.kiwiproject.consul.SessionClient;
import org.kiwiproject.consul.SnapshotClient;
import org.kiwiproject.consul.StatusClient;
import org.kiwiproject.consul.cache.TimeoutInterceptor;
import org.kiwiproject.consul.config.ClientConfig;
import org.kiwiproject.consul.monitoring.ClientEventCallback;
import org.kiwiproject.consul.monitoring.NoOpClientEventCallback;
import org.kiwiproject.consul.util.Jackson;
import org.kiwiproject.consul.util.TrustManagerUtils;
import org.kiwiproject.consul.util.Urls;
import org.kiwiproject.consul.util.bookend.ConsulBookend;
import org.kiwiproject.consul.util.bookend.ConsulBookendInterceptor;
import org.kiwiproject.consul.util.failover.ConsulFailoverInterceptor;
import org.kiwiproject.consul.util.failover.strategy.ConsulFailoverStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.jackson.JacksonConverterFactory;

public class Consul {
    private static final Logger LOG = LoggerFactory.getLogger(Consul.class);
    public static final String DEFAULT_HTTP_HOST = "localhost";
    public static final int DEFAULT_HTTP_PORT = 8500;
    private final AgentClient agentClient;
    private final AclClient aclClient;
    private final HealthClient healthClient;
    private final KeyValueClient keyValueClient;
    private final CatalogClient catalogClient;
    private final StatusClient statusClient;
    private final SessionClient sessionClient;
    private final EventClient eventClient;
    private final PreparedQueryClient preparedQueryClient;
    private final CoordinateClient coordinateClient;
    private final OperatorClient operatorClient;
    private final SnapshotClient snapshotClient;
    private final ExecutorService executorService;
    private final ConnectionPool connectionPool;
    private final OkHttpClient okHttpClient;
    private boolean destroyed;

    protected Consul(AgentClient agentClient, HealthClient healthClient, KeyValueClient keyValueClient, CatalogClient catalogClient, StatusClient statusClient, SessionClient sessionClient, EventClient eventClient, PreparedQueryClient preparedQueryClient, CoordinateClient coordinateClient, OperatorClient operatorClient, ExecutorService executorService, ConnectionPool connectionPool, AclClient aclClient, SnapshotClient snapshotClient, OkHttpClient okHttpClient) {
        this.agentClient = agentClient;
        this.healthClient = healthClient;
        this.keyValueClient = keyValueClient;
        this.catalogClient = catalogClient;
        this.statusClient = statusClient;
        this.sessionClient = sessionClient;
        this.eventClient = eventClient;
        this.preparedQueryClient = preparedQueryClient;
        this.coordinateClient = coordinateClient;
        this.operatorClient = operatorClient;
        this.executorService = executorService;
        this.connectionPool = connectionPool;
        this.aclClient = aclClient;
        this.snapshotClient = snapshotClient;
        this.okHttpClient = okHttpClient;
    }

    public void destroy() {
        this.destroyed = true;
        this.okHttpClient.dispatcher().cancelAll();
        this.executorService.shutdownNow();
        this.connectionPool.evictAll();
    }

    public boolean isDestroyed() {
        return this.destroyed;
    }

    public AgentClient agentClient() {
        return this.agentClient;
    }

    public AclClient aclClient() {
        return this.aclClient;
    }

    public CatalogClient catalogClient() {
        return this.catalogClient;
    }

    public HealthClient healthClient() {
        return this.healthClient;
    }

    public KeyValueClient keyValueClient() {
        return this.keyValueClient;
    }

    public StatusClient statusClient() {
        return this.statusClient;
    }

    public SessionClient sessionClient() {
        return this.sessionClient;
    }

    public EventClient eventClient() {
        return this.eventClient;
    }

    public PreparedQueryClient preparedQueryClient() {
        return this.preparedQueryClient;
    }

    public CoordinateClient coordinateClient() {
        return this.coordinateClient;
    }

    public OperatorClient operatorClient() {
        return this.operatorClient;
    }

    public SnapshotClient snapshotClient() {
        return this.snapshotClient;
    }

    public static Builder builder() {
        return new Builder();
    }

    @VisibleForTesting
    public static Consul newClient() {
        return Consul.builder().build();
    }

    public static class Builder {
        private static final String NEGATIVE_VALUE = "Negative value";
        private String scheme = "http";
        private URL url;
        private SSLContext sslContext;
        private X509TrustManager trustManager;
        private HostnameVerifier hostnameVerifier;
        private Proxy proxy;
        private boolean ping;
        private Interceptor authInterceptor;
        private Interceptor aclTokenInterceptor;
        private Interceptor headerInterceptor;
        private Interceptor consulBookendInterceptor;
        private ConsulFailoverInterceptor consulFailoverInterceptor;
        private int numTimesConsulFailoverInterceptorSet;
        private int maxFailoverAttempts;
        private final NetworkTimeoutConfig.Builder networkTimeoutConfigBuilder = new NetworkTimeoutConfig.Builder();
        private ExecutorService executorService;
        private ConnectionPool connectionPool;
        private ClientConfig clientConfig;
        private ClientEventCallback clientEventCallback;

        Builder() {
            this.url = Urls.newUrl(this.scheme, Consul.DEFAULT_HTTP_HOST, 8500);
        }

        public Builder withUrl(URL url) {
            this.url = url;
            return this;
        }

        public Builder withHttps(boolean withHttps) {
            this.scheme = withHttps ? "https" : "http";
            if (!this.url.getProtocol().equals(this.scheme)) {
                this.url = Urls.newUrl(this.scheme, this.url.getHost(), this.url.getPort());
            }
            return this;
        }

        public Builder withPing(boolean ping) {
            this.ping = ping;
            return this;
        }

        public Builder withBasicAuth(String username, String password) {
            String credentials = username + ":" + password;
            String basic = "Basic " + Base64.getEncoder().encodeToString(credentials.getBytes());
            this.authInterceptor = chain -> {
                Request original = chain.request();
                Request.Builder requestBuilder = original.newBuilder().header("Authorization", basic).method(original.method(), original.body());
                Request request = requestBuilder.build();
                return chain.proceed(request);
            };
            return this;
        }

        public Builder withTokenAuth(String token) {
            this.authInterceptor = chain -> {
                Request original = chain.request();
                Request.Builder requestBuilder = original.newBuilder().header("X-Consul-Token", token).method(original.method(), original.body());
                Request request = requestBuilder.build();
                return chain.proceed(request);
            };
            return this;
        }

        public Builder withAclToken(String token) {
            this.aclTokenInterceptor = chain -> {
                Request original = chain.request();
                HttpUrl originalUrl = original.url();
                String rewrittenUrl = originalUrl.queryParameterNames().isEmpty() ? originalUrl.url().toExternalForm() + "?token=" + token : originalUrl.url().toExternalForm() + "&token=" + token;
                Request.Builder requestBuilder = original.newBuilder().url(rewrittenUrl).method(original.method(), original.body());
                Request request = requestBuilder.build();
                return chain.proceed(request);
            };
            return this;
        }

        public Builder withHeaders(Map<String, String> headers) {
            this.headerInterceptor = chain -> {
                Request.Builder requestBuilder = chain.request().newBuilder();
                for (Map.Entry header : headers.entrySet()) {
                    requestBuilder.addHeader((String)header.getKey(), (String)header.getValue());
                }
                return chain.proceed(requestBuilder.build());
            };
            return this;
        }

        public Builder withConsulBookend(ConsulBookend consulBookend) {
            this.consulBookendInterceptor = new ConsulBookendInterceptor(consulBookend);
            return this;
        }

        public Builder withHostAndPort(HostAndPort hostAndPort) {
            this.url = Urls.newUrl(this.scheme, hostAndPort.getHost(), hostAndPort.getPort());
            return this;
        }

        public Builder withConsulFailoverInterceptor(ConsulFailoverInterceptor failoverInterceptor) {
            Preconditions.checkArgument((boolean)Objects.nonNull(failoverInterceptor), (Object)"failoverInterceptor must not be null");
            this.logWarningIfConsulFailoverInterceptorAlreadySet("withConsulFailoverInterceptor");
            this.consulFailoverInterceptor = failoverInterceptor;
            ++this.numTimesConsulFailoverInterceptorSet;
            return this;
        }

        public Builder withMultipleHostAndPort(Collection<HostAndPort> hostAndPort, long blacklistTimeInMillis) {
            Preconditions.checkArgument((blacklistTimeInMillis >= 0L ? 1 : 0) != 0, (Object)"Blacklist time must be positive (or zero)");
            Preconditions.checkArgument((hostAndPort.size() >= 2 ? 1 : 0) != 0, (Object)"Minimum of 2 addresses are required");
            this.logWarningIfConsulFailoverInterceptorAlreadySet("withMultipleHostAndPort");
            this.consulFailoverInterceptor = new ConsulFailoverInterceptor(hostAndPort, blacklistTimeInMillis);
            ++this.numTimesConsulFailoverInterceptorSet;
            this.withHostAndPort(hostAndPort.stream().findFirst().orElseThrow());
            return this;
        }

        public Builder withMultipleHostAndPort(Collection<HostAndPort> hostAndPort, Duration blacklistTime) {
            return this.withMultipleHostAndPort(hostAndPort, blacklistTime.toMillis());
        }

        public Builder withMultipleHostAndPort(Collection<HostAndPort> hostAndPort, long blacklistTime, TimeUnit blacklistTimeUnit) {
            return this.withMultipleHostAndPort(hostAndPort, blacklistTimeUnit.toMillis(blacklistTime));
        }

        public Builder withFailoverInterceptorUsingStrategy(ConsulFailoverStrategy strategy) {
            Preconditions.checkArgument((boolean)Objects.nonNull(strategy), (Object)"Must not provide a null strategy");
            this.logWarningIfConsulFailoverInterceptorAlreadySet("withFailoverInterceptorUsingStrategy");
            this.consulFailoverInterceptor = new ConsulFailoverInterceptor(strategy);
            ++this.numTimesConsulFailoverInterceptorSet;
            return this;
        }

        @Deprecated(since="1.3.0", forRemoval=true)
        public Builder withFailoverInterceptor(ConsulFailoverStrategy strategy) {
            return this.withFailoverInterceptorUsingStrategy(strategy);
        }

        private void logWarningIfConsulFailoverInterceptorAlreadySet(String methodName) {
            if (this.numTimesConsulFailoverInterceptorSet > 0) {
                LOG.warn("A ConsulFailoverInterceptor was already present; this invocation to '{}' overrides it! Make sure only one method to set a failover interceptor is called.", (Object)methodName);
            }
        }

        @VisibleForTesting
        int numTimesConsulFailoverInterceptorSet() {
            return this.numTimesConsulFailoverInterceptorSet;
        }

        public Builder withMaxFailoverAttempts(int maxFailoverAttempts) {
            Preconditions.checkArgument((maxFailoverAttempts > 0 ? 1 : 0) != 0, (Object)"maxFailoverAttempts must be positive");
            this.maxFailoverAttempts = maxFailoverAttempts;
            return this;
        }

        public Builder withUrl(String url) {
            this.url = Urls.newUrl(url);
            return this;
        }

        public Builder withSslContext(SSLContext sslContext) {
            this.sslContext = sslContext;
            return this;
        }

        public Builder withTrustManager(X509TrustManager trustManager) {
            this.trustManager = trustManager;
            return this;
        }

        public Builder withHostnameVerifier(HostnameVerifier hostnameVerifier) {
            this.hostnameVerifier = hostnameVerifier;
            return this;
        }

        public Builder withProxy(Proxy proxy) {
            this.proxy = proxy;
            return this;
        }

        public Builder withConnectTimeoutMillis(long timeoutMillis) {
            Preconditions.checkArgument((timeoutMillis >= 0L ? 1 : 0) != 0, (Object)NEGATIVE_VALUE);
            this.networkTimeoutConfigBuilder.withConnectTimeout((int)timeoutMillis);
            return this;
        }

        public Builder withReadTimeoutMillis(long timeoutMillis) {
            Preconditions.checkArgument((timeoutMillis >= 0L ? 1 : 0) != 0, (Object)NEGATIVE_VALUE);
            this.networkTimeoutConfigBuilder.withReadTimeout((int)timeoutMillis);
            return this;
        }

        public Builder withWriteTimeoutMillis(long timeoutMillis) {
            Preconditions.checkArgument((timeoutMillis >= 0L ? 1 : 0) != 0, (Object)NEGATIVE_VALUE);
            this.networkTimeoutConfigBuilder.withWriteTimeout((int)timeoutMillis);
            return this;
        }

        public Builder withExecutorService(ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        public Builder withConnectionPool(ConnectionPool connectionPool) {
            this.connectionPool = connectionPool;
            return this;
        }

        public Builder withClientConfiguration(ClientConfig clientConfig) {
            this.clientConfig = clientConfig;
            return this;
        }

        public Builder withClientEventCallback(ClientEventCallback callback) {
            this.clientEventCallback = callback;
            return this;
        }

        public Consul build() {
            ExecutorService localExecutorService = this.executorService;
            if (Objects.isNull(localExecutorService)) {
                ThreadFactory threadFactory = Builder.newDaemonThreadFactory();
                localExecutorService = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), threadFactory);
            }
            if (Objects.isNull(this.connectionPool)) {
                this.connectionPool = new ConnectionPool();
            }
            ClientConfig config = Objects.nonNull(this.clientConfig) ? this.clientConfig : new ClientConfig();
            OkHttpClient okHttpClient = this.createOkHttpClient(this.sslContext, this.trustManager, this.hostnameVerifier, this.proxy, localExecutorService, this.connectionPool, config);
            NetworkTimeoutConfig networkTimeoutConfig = new NetworkTimeoutConfig.Builder().withConnectTimeout(() -> ((OkHttpClient)okHttpClient).connectTimeoutMillis()).withReadTimeout(() -> ((OkHttpClient)okHttpClient).readTimeoutMillis()).withWriteTimeout(() -> ((OkHttpClient)okHttpClient).writeTimeoutMillis()).build();
            Retrofit retrofit = this.createRetrofit(this.buildUrl(this.url), Jackson.MAPPER, okHttpClient);
            ClientEventCallback eventCallback = Objects.nonNull(this.clientEventCallback) ? this.clientEventCallback : new NoOpClientEventCallback();
            AgentClient agentClient = new AgentClient(retrofit, config, eventCallback);
            HealthClient healthClient = new HealthClient(retrofit, config, eventCallback, networkTimeoutConfig);
            KeyValueClient keyValueClient = new KeyValueClient(retrofit, config, eventCallback, networkTimeoutConfig);
            CatalogClient catalogClient = new CatalogClient(retrofit, config, eventCallback, networkTimeoutConfig);
            StatusClient statusClient = new StatusClient(retrofit, config, eventCallback);
            SessionClient sessionClient = new SessionClient(retrofit, config, eventCallback);
            EventClient eventClient = new EventClient(retrofit, config, eventCallback);
            PreparedQueryClient preparedQueryClient = new PreparedQueryClient(retrofit, config, eventCallback);
            CoordinateClient coordinateClient = new CoordinateClient(retrofit, config, eventCallback);
            OperatorClient operatorClient = new OperatorClient(retrofit, config, eventCallback);
            AclClient aclClient = new AclClient(retrofit, config, eventCallback);
            SnapshotClient snapshotClient = new SnapshotClient(retrofit, config, eventCallback);
            if (this.ping) {
                agentClient.ping();
            }
            return new Consul(agentClient, healthClient, keyValueClient, catalogClient, statusClient, sessionClient, eventClient, preparedQueryClient, coordinateClient, operatorClient, localExecutorService, this.connectionPool, aclClient, snapshotClient, okHttpClient);
        }

        private static ThreadFactory newDaemonThreadFactory() {
            return new ThreadFactoryBuilder().setNameFormat("Consul-Client-OkHttp-Dispatcher-%d").setDaemon(true).build();
        }

        private String buildUrl(URL url) {
            return url.toExternalForm().replaceAll("/$", "") + "/v1/";
        }

        private OkHttpClient createOkHttpClient(SSLContext sslContext, X509TrustManager trustManager, HostnameVerifier hostnameVerifier, Proxy proxy, ExecutorService executorService, ConnectionPool connectionPool, ClientConfig clientConfig) {
            OkHttpClient.Builder builder = new OkHttpClient.Builder();
            if (Objects.nonNull(this.authInterceptor)) {
                builder.addInterceptor(this.authInterceptor);
            }
            if (Objects.nonNull(this.aclTokenInterceptor)) {
                builder.addInterceptor(this.aclTokenInterceptor);
            }
            if (Objects.nonNull(this.headerInterceptor)) {
                builder.addInterceptor(this.headerInterceptor);
            }
            if (Objects.nonNull(this.consulBookendInterceptor)) {
                builder.addInterceptor(this.consulBookendInterceptor);
            }
            this.addConsulFailoverInterceptor(builder);
            Builder.addSslSocketFactory(sslContext, trustManager, builder);
            if (Objects.nonNull(hostnameVerifier)) {
                builder.hostnameVerifier(hostnameVerifier);
            }
            if (Objects.nonNull(proxy)) {
                builder.proxy(proxy);
            }
            NetworkTimeoutConfig networkTimeoutConfig = this.networkTimeoutConfigBuilder.build();
            Builder.addTimeouts(builder, networkTimeoutConfig);
            builder.addInterceptor((Interceptor)new TimeoutInterceptor(clientConfig.getCacheConfig()));
            Dispatcher dispatcher = new Dispatcher(executorService);
            dispatcher.setMaxRequests(Integer.MAX_VALUE);
            dispatcher.setMaxRequestsPerHost(Integer.MAX_VALUE);
            builder.dispatcher(dispatcher);
            if (Objects.nonNull(connectionPool)) {
                builder.connectionPool(connectionPool);
            }
            return builder.build();
        }

        private void addConsulFailoverInterceptor(OkHttpClient.Builder builder) {
            if (Objects.isNull(this.consulFailoverInterceptor)) {
                return;
            }
            if (this.maxFailoverAttempts > 0) {
                this.consulFailoverInterceptor.withMaxFailoverAttempts(this.maxFailoverAttempts);
            }
            builder.addInterceptor((Interceptor)this.consulFailoverInterceptor);
        }

        @VisibleForTesting
        static void addSslSocketFactory(@Nullable SSLContext sslContext, @Nullable X509TrustManager trustManager, OkHttpClient.Builder builder) {
            if (Objects.isNull(sslContext)) {
                return;
            }
            SSLSocketFactory socketFactory = sslContext.getSocketFactory();
            if (Objects.nonNull(trustManager)) {
                builder.sslSocketFactory(socketFactory, trustManager);
            } else {
                builder.sslSocketFactory(socketFactory, TrustManagerUtils.getDefaultTrustManager());
            }
        }

        private static void addTimeouts(OkHttpClient.Builder builder, NetworkTimeoutConfig networkTimeoutConfig) {
            if (networkTimeoutConfig.getClientConnectTimeoutMillis() >= 0) {
                builder.connectTimeout((long)networkTimeoutConfig.getClientConnectTimeoutMillis(), TimeUnit.MILLISECONDS);
            }
            if (networkTimeoutConfig.getClientReadTimeoutMillis() >= 0) {
                builder.readTimeout((long)networkTimeoutConfig.getClientReadTimeoutMillis(), TimeUnit.MILLISECONDS);
            }
            if (networkTimeoutConfig.getClientWriteTimeoutMillis() >= 0) {
                builder.writeTimeout((long)networkTimeoutConfig.getClientWriteTimeoutMillis(), TimeUnit.MILLISECONDS);
            }
        }

        private Retrofit createRetrofit(String url, ObjectMapper mapper, OkHttpClient okHttpClient) {
            URL consulUrl = Urls.newUrl(url);
            URL baseUrl = Urls.newUrl(consulUrl.getProtocol(), consulUrl.getHost(), consulUrl.getPort(), consulUrl.getFile());
            return new Retrofit.Builder().baseUrl(baseUrl.toExternalForm()).addConverterFactory((Converter.Factory)JacksonConverterFactory.create((ObjectMapper)mapper)).client(okHttpClient).build();
        }
    }

    public static class NetworkTimeoutConfig {
        private final IntSupplier readTimeoutMillisSupplier;
        private final IntSupplier writeTimeoutMillisSupplier;
        private final IntSupplier connectTimeoutMillisSupplier;

        private NetworkTimeoutConfig(IntSupplier readTimeoutMillisSupplier, IntSupplier writeTimeoutMillisSupplier, IntSupplier connectTimeoutMillisSupplier) {
            this.readTimeoutMillisSupplier = readTimeoutMillisSupplier;
            this.writeTimeoutMillisSupplier = writeTimeoutMillisSupplier;
            this.connectTimeoutMillisSupplier = connectTimeoutMillisSupplier;
        }

        public int getClientReadTimeoutMillis() {
            return this.readTimeoutMillisSupplier.getAsInt();
        }

        public int getClientWriteTimeoutMillis() {
            return this.writeTimeoutMillisSupplier.getAsInt();
        }

        public int getClientConnectTimeoutMillis() {
            return this.connectTimeoutMillisSupplier.getAsInt();
        }

        public static class Builder {
            private IntSupplier readTimeoutMillisSupplier = () -> -1;
            private IntSupplier writeTimeoutMillisSupplier = () -> -1;
            private IntSupplier connectTimeoutMillisSupplier = () -> -1;

            public Builder withReadTimeout(IntSupplier timeoutSupplier) {
                this.readTimeoutMillisSupplier = timeoutSupplier;
                return this;
            }

            public Builder withReadTimeout(int millis) {
                return this.withReadTimeout(() -> millis);
            }

            public Builder withWriteTimeout(IntSupplier timeoutSupplier) {
                this.writeTimeoutMillisSupplier = timeoutSupplier;
                return this;
            }

            public Builder withWriteTimeout(int millis) {
                return this.withWriteTimeout(() -> millis);
            }

            public Builder withConnectTimeout(IntSupplier timeoutSupplier) {
                this.connectTimeoutMillisSupplier = timeoutSupplier;
                return this;
            }

            public Builder withConnectTimeout(int millis) {
                return this.withConnectTimeout(() -> millis);
            }

            public NetworkTimeoutConfig build() {
                return new NetworkTimeoutConfig(this.readTimeoutMillisSupplier, this.writeTimeoutMillisSupplier, this.connectTimeoutMillisSupplier);
            }
        }
    }
}

