/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.consul.model;

import com.google.common.annotations.VisibleForTesting;
import java.math.BigInteger;
import java.util.Objects;
import java.util.Optional;
import org.jspecify.annotations.Nullable;

public class ConsulResponse<T> {
    private final T response;
    private final long lastContact;
    private final boolean knownLeader;
    private final BigInteger index;
    private final CacheResponseInfo cacheResponseInfo;

    @VisibleForTesting
    static @Nullable CacheResponseInfo buildCacheResponseInfo(String headerHitMiss, String headerAge) throws NumberFormatException {
        if (Objects.nonNull(headerHitMiss)) {
            return new CacheResponseInfoImpl(headerHitMiss, headerAge);
        }
        return null;
    }

    public ConsulResponse(T response, long lastContact, boolean knownLeader, BigInteger index, String headerHitMiss, String headerAge) throws NumberFormatException {
        this(response, lastContact, knownLeader, index, ConsulResponse.buildCacheResponseInfo(headerHitMiss, headerAge));
    }

    @Deprecated(since="1.8.0", forRemoval=true)
    public ConsulResponse(T response, long lastContact, boolean knownLeader, BigInteger index, Optional<CacheResponseInfo> cacheInfo) {
        this(response, lastContact, knownLeader, index, (CacheResponseInfo)cacheInfo.orElse(null));
    }

    public ConsulResponse(T response, long lastContact, boolean knownLeader, BigInteger index, @Nullable CacheResponseInfo cacheInfo) {
        this.response = response;
        this.lastContact = lastContact;
        this.knownLeader = knownLeader;
        this.index = index;
        this.cacheResponseInfo = cacheInfo;
    }

    public T getResponse() {
        return this.response;
    }

    public long getLastContact() {
        return this.lastContact;
    }

    public boolean isKnownLeader() {
        return this.knownLeader;
    }

    public BigInteger getIndex() {
        return this.index;
    }

    @Deprecated(since="1.1.0", forRemoval=true)
    public Optional<CacheResponseInfo> getCacheReponseInfo() {
        return this.getCacheResponseInfo();
    }

    public Optional<CacheResponseInfo> getCacheResponseInfo() {
        return Optional.ofNullable(this.cacheResponseInfo);
    }

    public @Nullable CacheResponseInfo getCacheResponseInfoOrNull() {
        return this.cacheResponseInfo;
    }

    public String toString() {
        return "ConsulResponse{response=" + String.valueOf(this.response) + ", lastContact=" + this.lastContact + ", knownLeader=" + this.knownLeader + ", index=" + String.valueOf(this.index) + ", cache=" + String.valueOf(this.cacheResponseInfo) + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (Objects.isNull(o) || this.getClass() != o.getClass()) {
            return false;
        }
        ConsulResponse that = (ConsulResponse)o;
        return com.google.common.base.Objects.equal(this.response, that.response) && com.google.common.base.Objects.equal((Object)this.lastContact, (Object)that.lastContact) && com.google.common.base.Objects.equal((Object)this.knownLeader, (Object)that.knownLeader) && com.google.common.base.Objects.equal((Object)this.index, (Object)that.index);
    }

    public int hashCode() {
        return com.google.common.base.Objects.hashCode((Object[])new Object[]{this.response, this.lastContact, this.knownLeader, this.index});
    }

    private static class CacheResponseInfoImpl
    implements CacheResponseInfo {
        private final Long ageInSeconds;
        private final boolean cacheHit;

        public CacheResponseInfoImpl(String headerHitMiss, String headerAge) throws NumberFormatException {
            this.cacheHit = headerHitMiss.equals("HIT");
            Long val = null;
            if (Objects.nonNull(headerAge)) {
                val = Long.parseLong(headerAge);
            }
            this.ageInSeconds = val;
        }

        @Override
        public Optional<Long> getAgeInSeconds() {
            return Optional.ofNullable(this.ageInSeconds);
        }

        @Override
        public boolean isCacheHit() {
            return this.cacheHit;
        }

        public String toString() {
            return String.format("Cache[%s, age=%d]", this.cacheHit ? "HIT" : "MISS", this.ageInSeconds);
        }
    }

    public static interface CacheResponseInfo {
        public Optional<Long> getAgeInSeconds();

        public boolean isCacheHit();
    }
}

