/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.consul.model.agent;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.immutables.value.Generated;
import org.kiwiproject.consul.model.agent.Check;

@JsonIgnoreProperties(ignoreUnknown=true)
@Generated(from="Check", generator="Immutables")
public final class ImmutableCheck
extends Check {
    private final String id;
    private final String name;
    @Nullable
    private final String notes;
    @Nullable
    private final String output;
    @Nullable
    private final List<String> args;
    @Nullable
    private final String interval;
    @Nullable
    private final String ttl;
    @Nullable
    private final String http;
    @Nullable
    private final String tcp;
    @Nullable
    private final String grpc;
    @Nullable
    private final Boolean grpcUseTls;
    @Nullable
    private final String serviceId;
    private final ImmutableList<String> serviceTags;
    @Nullable
    private final String deregisterCriticalServiceAfter;

    private ImmutableCheck(String id, String name, @Nullable String notes, @Nullable String output, @Nullable List<String> args, @Nullable String interval, @Nullable String ttl, @Nullable String http, @Nullable String tcp, @Nullable String grpc, @Nullable Boolean grpcUseTls, @Nullable String serviceId, ImmutableList<String> serviceTags, @Nullable String deregisterCriticalServiceAfter) {
        this.id = id;
        this.name = name;
        this.notes = notes;
        this.output = output;
        this.args = args;
        this.interval = interval;
        this.ttl = ttl;
        this.http = http;
        this.tcp = tcp;
        this.grpc = grpc;
        this.grpcUseTls = grpcUseTls;
        this.serviceId = serviceId;
        this.serviceTags = serviceTags;
        this.deregisterCriticalServiceAfter = deregisterCriticalServiceAfter;
    }

    @Override
    @JsonProperty(value="ID")
    public String getId() {
        return this.id;
    }

    @Override
    @JsonProperty(value="Name")
    public String getName() {
        return this.name;
    }

    @Override
    @JsonProperty(value="Notes")
    public Optional<String> getNotes() {
        return Optional.ofNullable(this.notes);
    }

    @Override
    @JsonProperty(value="Output")
    public Optional<String> getOutput() {
        return Optional.ofNullable(this.output);
    }

    @Override
    @JsonProperty(value="Args")
    public Optional<List<String>> getArgs() {
        return Optional.ofNullable(this.args);
    }

    @Override
    @JsonProperty(value="Interval")
    public Optional<String> getInterval() {
        return Optional.ofNullable(this.interval);
    }

    @Override
    @JsonProperty(value="TTL")
    public Optional<String> getTtl() {
        return Optional.ofNullable(this.ttl);
    }

    @Override
    @JsonProperty(value="HTTP")
    public Optional<String> getHttp() {
        return Optional.ofNullable(this.http);
    }

    @Override
    @JsonProperty(value="TCP")
    public Optional<String> getTcp() {
        return Optional.ofNullable(this.tcp);
    }

    @Override
    @JsonProperty(value="GRPC")
    public Optional<String> getGrpc() {
        return Optional.ofNullable(this.grpc);
    }

    @Override
    @JsonProperty(value="GRPCUseTLS")
    public Optional<Boolean> getGrpcUseTls() {
        return Optional.ofNullable(this.grpcUseTls);
    }

    @Override
    @JsonProperty(value="ServiceID")
    public Optional<String> getServiceId() {
        return Optional.ofNullable(this.serviceId);
    }

    @JsonProperty(value="ServiceTags")
    @JsonDeserialize(as=ImmutableList.class, contentAs=String.class)
    public ImmutableList<String> getServiceTags() {
        return this.serviceTags;
    }

    @Override
    @JsonProperty(value="DeregisterCriticalServiceAfter")
    public Optional<String> getDeregisterCriticalServiceAfter() {
        return Optional.ofNullable(this.deregisterCriticalServiceAfter);
    }

    public final ImmutableCheck withId(String value) {
        String newValue = Objects.requireNonNull(value, "id");
        if (this.id.equals(newValue)) {
            return this;
        }
        return ImmutableCheck.validate(new ImmutableCheck(newValue, this.name, this.notes, this.output, this.args, this.interval, this.ttl, this.http, this.tcp, this.grpc, this.grpcUseTls, this.serviceId, this.serviceTags, this.deregisterCriticalServiceAfter));
    }

    public final ImmutableCheck withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return ImmutableCheck.validate(new ImmutableCheck(this.id, newValue, this.notes, this.output, this.args, this.interval, this.ttl, this.http, this.tcp, this.grpc, this.grpcUseTls, this.serviceId, this.serviceTags, this.deregisterCriticalServiceAfter));
    }

    public final ImmutableCheck withNotes(String value) {
        String newValue = Objects.requireNonNull(value, "notes");
        if (Objects.equals(this.notes, newValue)) {
            return this;
        }
        return ImmutableCheck.validate(new ImmutableCheck(this.id, this.name, newValue, this.output, this.args, this.interval, this.ttl, this.http, this.tcp, this.grpc, this.grpcUseTls, this.serviceId, this.serviceTags, this.deregisterCriticalServiceAfter));
    }

    public final ImmutableCheck withNotes(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.notes, value)) {
            return this;
        }
        return ImmutableCheck.validate(new ImmutableCheck(this.id, this.name, value, this.output, this.args, this.interval, this.ttl, this.http, this.tcp, this.grpc, this.grpcUseTls, this.serviceId, this.serviceTags, this.deregisterCriticalServiceAfter));
    }

    public final ImmutableCheck withOutput(String value) {
        String newValue = Objects.requireNonNull(value, "output");
        if (Objects.equals(this.output, newValue)) {
            return this;
        }
        return ImmutableCheck.validate(new ImmutableCheck(this.id, this.name, this.notes, newValue, this.args, this.interval, this.ttl, this.http, this.tcp, this.grpc, this.grpcUseTls, this.serviceId, this.serviceTags, this.deregisterCriticalServiceAfter));
    }

    public final ImmutableCheck withOutput(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.output, value)) {
            return this;
        }
        return ImmutableCheck.validate(new ImmutableCheck(this.id, this.name, this.notes, value, this.args, this.interval, this.ttl, this.http, this.tcp, this.grpc, this.grpcUseTls, this.serviceId, this.serviceTags, this.deregisterCriticalServiceAfter));
    }

    public final ImmutableCheck withArgs(List<String> value) {
        List<String> newValue = Objects.requireNonNull(value, "args");
        if (this.args == newValue) {
            return this;
        }
        return ImmutableCheck.validate(new ImmutableCheck(this.id, this.name, this.notes, this.output, newValue, this.interval, this.ttl, this.http, this.tcp, this.grpc, this.grpcUseTls, this.serviceId, this.serviceTags, this.deregisterCriticalServiceAfter));
    }

    public final ImmutableCheck withArgs(Optional<? extends List<String>> optional) {
        List value = optional.orElse(null);
        if (this.args == value) {
            return this;
        }
        return ImmutableCheck.validate(new ImmutableCheck(this.id, this.name, this.notes, this.output, value, this.interval, this.ttl, this.http, this.tcp, this.grpc, this.grpcUseTls, this.serviceId, this.serviceTags, this.deregisterCriticalServiceAfter));
    }

    public final ImmutableCheck withInterval(String value) {
        String newValue = Objects.requireNonNull(value, "interval");
        if (Objects.equals(this.interval, newValue)) {
            return this;
        }
        return ImmutableCheck.validate(new ImmutableCheck(this.id, this.name, this.notes, this.output, this.args, newValue, this.ttl, this.http, this.tcp, this.grpc, this.grpcUseTls, this.serviceId, this.serviceTags, this.deregisterCriticalServiceAfter));
    }

    public final ImmutableCheck withInterval(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.interval, value)) {
            return this;
        }
        return ImmutableCheck.validate(new ImmutableCheck(this.id, this.name, this.notes, this.output, this.args, value, this.ttl, this.http, this.tcp, this.grpc, this.grpcUseTls, this.serviceId, this.serviceTags, this.deregisterCriticalServiceAfter));
    }

    public final ImmutableCheck withTtl(String value) {
        String newValue = Objects.requireNonNull(value, "ttl");
        if (Objects.equals(this.ttl, newValue)) {
            return this;
        }
        return ImmutableCheck.validate(new ImmutableCheck(this.id, this.name, this.notes, this.output, this.args, this.interval, newValue, this.http, this.tcp, this.grpc, this.grpcUseTls, this.serviceId, this.serviceTags, this.deregisterCriticalServiceAfter));
    }

    public final ImmutableCheck withTtl(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.ttl, value)) {
            return this;
        }
        return ImmutableCheck.validate(new ImmutableCheck(this.id, this.name, this.notes, this.output, this.args, this.interval, value, this.http, this.tcp, this.grpc, this.grpcUseTls, this.serviceId, this.serviceTags, this.deregisterCriticalServiceAfter));
    }

    public final ImmutableCheck withHttp(String value) {
        String newValue = Objects.requireNonNull(value, "http");
        if (Objects.equals(this.http, newValue)) {
            return this;
        }
        return ImmutableCheck.validate(new ImmutableCheck(this.id, this.name, this.notes, this.output, this.args, this.interval, this.ttl, newValue, this.tcp, this.grpc, this.grpcUseTls, this.serviceId, this.serviceTags, this.deregisterCriticalServiceAfter));
    }

    public final ImmutableCheck withHttp(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.http, value)) {
            return this;
        }
        return ImmutableCheck.validate(new ImmutableCheck(this.id, this.name, this.notes, this.output, this.args, this.interval, this.ttl, value, this.tcp, this.grpc, this.grpcUseTls, this.serviceId, this.serviceTags, this.deregisterCriticalServiceAfter));
    }

    public final ImmutableCheck withTcp(String value) {
        String newValue = Objects.requireNonNull(value, "tcp");
        if (Objects.equals(this.tcp, newValue)) {
            return this;
        }
        return ImmutableCheck.validate(new ImmutableCheck(this.id, this.name, this.notes, this.output, this.args, this.interval, this.ttl, this.http, newValue, this.grpc, this.grpcUseTls, this.serviceId, this.serviceTags, this.deregisterCriticalServiceAfter));
    }

    public final ImmutableCheck withTcp(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.tcp, value)) {
            return this;
        }
        return ImmutableCheck.validate(new ImmutableCheck(this.id, this.name, this.notes, this.output, this.args, this.interval, this.ttl, this.http, value, this.grpc, this.grpcUseTls, this.serviceId, this.serviceTags, this.deregisterCriticalServiceAfter));
    }

    public final ImmutableCheck withGrpc(String value) {
        String newValue = Objects.requireNonNull(value, "grpc");
        if (Objects.equals(this.grpc, newValue)) {
            return this;
        }
        return ImmutableCheck.validate(new ImmutableCheck(this.id, this.name, this.notes, this.output, this.args, this.interval, this.ttl, this.http, this.tcp, newValue, this.grpcUseTls, this.serviceId, this.serviceTags, this.deregisterCriticalServiceAfter));
    }

    public final ImmutableCheck withGrpc(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.grpc, value)) {
            return this;
        }
        return ImmutableCheck.validate(new ImmutableCheck(this.id, this.name, this.notes, this.output, this.args, this.interval, this.ttl, this.http, this.tcp, value, this.grpcUseTls, this.serviceId, this.serviceTags, this.deregisterCriticalServiceAfter));
    }

    public final ImmutableCheck withGrpcUseTls(boolean value) {
        Boolean newValue = value;
        if (Objects.equals(this.grpcUseTls, newValue)) {
            return this;
        }
        return ImmutableCheck.validate(new ImmutableCheck(this.id, this.name, this.notes, this.output, this.args, this.interval, this.ttl, this.http, this.tcp, this.grpc, newValue, this.serviceId, this.serviceTags, this.deregisterCriticalServiceAfter));
    }

    public final ImmutableCheck withGrpcUseTls(Optional<Boolean> optional) {
        Boolean value = optional.orElse(null);
        if (Objects.equals(this.grpcUseTls, value)) {
            return this;
        }
        return ImmutableCheck.validate(new ImmutableCheck(this.id, this.name, this.notes, this.output, this.args, this.interval, this.ttl, this.http, this.tcp, this.grpc, value, this.serviceId, this.serviceTags, this.deregisterCriticalServiceAfter));
    }

    public final ImmutableCheck withServiceId(String value) {
        String newValue = Objects.requireNonNull(value, "serviceId");
        if (Objects.equals(this.serviceId, newValue)) {
            return this;
        }
        return ImmutableCheck.validate(new ImmutableCheck(this.id, this.name, this.notes, this.output, this.args, this.interval, this.ttl, this.http, this.tcp, this.grpc, this.grpcUseTls, newValue, this.serviceTags, this.deregisterCriticalServiceAfter));
    }

    public final ImmutableCheck withServiceId(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.serviceId, value)) {
            return this;
        }
        return ImmutableCheck.validate(new ImmutableCheck(this.id, this.name, this.notes, this.output, this.args, this.interval, this.ttl, this.http, this.tcp, this.grpc, this.grpcUseTls, value, this.serviceTags, this.deregisterCriticalServiceAfter));
    }

    public final ImmutableCheck withServiceTags(String ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return ImmutableCheck.validate(new ImmutableCheck(this.id, this.name, this.notes, this.output, this.args, this.interval, this.ttl, this.http, this.tcp, this.grpc, this.grpcUseTls, this.serviceId, (ImmutableList<String>)newValue, this.deregisterCriticalServiceAfter));
    }

    public final ImmutableCheck withServiceTags(Iterable<String> elements) {
        if (this.serviceTags == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return ImmutableCheck.validate(new ImmutableCheck(this.id, this.name, this.notes, this.output, this.args, this.interval, this.ttl, this.http, this.tcp, this.grpc, this.grpcUseTls, this.serviceId, (ImmutableList<String>)newValue, this.deregisterCriticalServiceAfter));
    }

    public final ImmutableCheck withDeregisterCriticalServiceAfter(String value) {
        String newValue = Objects.requireNonNull(value, "deregisterCriticalServiceAfter");
        if (Objects.equals(this.deregisterCriticalServiceAfter, newValue)) {
            return this;
        }
        return ImmutableCheck.validate(new ImmutableCheck(this.id, this.name, this.notes, this.output, this.args, this.interval, this.ttl, this.http, this.tcp, this.grpc, this.grpcUseTls, this.serviceId, this.serviceTags, newValue));
    }

    public final ImmutableCheck withDeregisterCriticalServiceAfter(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.deregisterCriticalServiceAfter, value)) {
            return this;
        }
        return ImmutableCheck.validate(new ImmutableCheck(this.id, this.name, this.notes, this.output, this.args, this.interval, this.ttl, this.http, this.tcp, this.grpc, this.grpcUseTls, this.serviceId, this.serviceTags, value));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableCheck && this.equalsByValue((ImmutableCheck)another);
    }

    private boolean equalsByValue(ImmutableCheck another) {
        return this.id.equals(another.id) && this.name.equals(another.name) && Objects.equals(this.notes, another.notes) && Objects.equals(this.output, another.output) && Objects.equals(this.args, another.args) && Objects.equals(this.interval, another.interval) && Objects.equals(this.ttl, another.ttl) && Objects.equals(this.http, another.http) && Objects.equals(this.tcp, another.tcp) && Objects.equals(this.grpc, another.grpc) && Objects.equals(this.grpcUseTls, another.grpcUseTls) && Objects.equals(this.serviceId, another.serviceId) && this.serviceTags.equals(another.serviceTags) && Objects.equals(this.deregisterCriticalServiceAfter, another.deregisterCriticalServiceAfter);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.id.hashCode();
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + Objects.hashCode(this.notes);
        h += (h << 5) + Objects.hashCode(this.output);
        h += (h << 5) + Objects.hashCode(this.args);
        h += (h << 5) + Objects.hashCode(this.interval);
        h += (h << 5) + Objects.hashCode(this.ttl);
        h += (h << 5) + Objects.hashCode(this.http);
        h += (h << 5) + Objects.hashCode(this.tcp);
        h += (h << 5) + Objects.hashCode(this.grpc);
        h += (h << 5) + Objects.hashCode(this.grpcUseTls);
        h += (h << 5) + Objects.hashCode(this.serviceId);
        h += (h << 5) + this.serviceTags.hashCode();
        h += (h << 5) + Objects.hashCode(this.deregisterCriticalServiceAfter);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Check").omitNullValues().add("id", (Object)this.id).add("name", (Object)this.name).add("notes", (Object)this.notes).add("output", (Object)this.output).add("args", this.args).add("interval", (Object)this.interval).add("ttl", (Object)this.ttl).add("http", (Object)this.http).add("tcp", (Object)this.tcp).add("grpc", (Object)this.grpc).add("grpcUseTls", (Object)this.grpcUseTls).add("serviceId", (Object)this.serviceId).add("serviceTags", this.serviceTags).add("deregisterCriticalServiceAfter", (Object)this.deregisterCriticalServiceAfter).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableCheck fromJson(Json json) {
        Builder builder = ImmutableCheck.builder();
        if (json._id != null) {
            builder.id(json._id);
        }
        if (json._name != null) {
            builder.name(json._name);
        }
        if (json._notes != null) {
            builder.notes(json._notes);
        }
        if (json._output != null) {
            builder.output(json._output);
        }
        if (json._args != null) {
            builder.args(json._args);
        }
        if (json._interval != null) {
            builder.interval(json._interval);
        }
        if (json._ttl != null) {
            builder.ttl(json._ttl);
        }
        if (json._http != null) {
            builder.http(json._http);
        }
        if (json._tcp != null) {
            builder.tcp(json._tcp);
        }
        if (json._grpc != null) {
            builder.grpc(json._grpc);
        }
        if (json._grpcUseTls != null) {
            builder.grpcUseTls(json._grpcUseTls);
        }
        if (json._serviceId != null) {
            builder.serviceId(json._serviceId);
        }
        if (json._serviceTags != null) {
            builder.addAllServiceTags(json._serviceTags);
        }
        if (json._deregisterCriticalServiceAfter != null) {
            builder.deregisterCriticalServiceAfter(json._deregisterCriticalServiceAfter);
        }
        return builder.build();
    }

    private static ImmutableCheck validate(ImmutableCheck instance) {
        instance.validate();
        return instance;
    }

    public static ImmutableCheck copyOf(Check instance) {
        if (instance instanceof ImmutableCheck) {
            return (ImmutableCheck)instance;
        }
        return ImmutableCheck.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="Check", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long INIT_BIT_NAME = 2L;
        private long initBits = 3L;
        @Nullable
        private String id;
        @Nullable
        private String name;
        @Nullable
        private String notes;
        @Nullable
        private String output;
        @Nullable
        private List<String> args;
        @Nullable
        private String interval;
        @Nullable
        private String ttl;
        @Nullable
        private String http;
        @Nullable
        private String tcp;
        @Nullable
        private String grpc;
        @Nullable
        private Boolean grpcUseTls;
        @Nullable
        private String serviceId;
        private ImmutableList.Builder<String> serviceTags = ImmutableList.builder();
        @Nullable
        private String deregisterCriticalServiceAfter;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(Check instance) {
            Optional<String> serviceIdOptional;
            Optional<Boolean> grpcUseTlsOptional;
            Optional<String> grpcOptional;
            Optional<String> tcpOptional;
            Optional<String> httpOptional;
            Optional<String> ttlOptional;
            Optional<String> intervalOptional;
            Optional<List<String>> argsOptional;
            Optional<String> outputOptional;
            Objects.requireNonNull(instance, "instance");
            this.id(instance.getId());
            this.name(instance.getName());
            Optional<String> notesOptional = instance.getNotes();
            if (notesOptional.isPresent()) {
                this.notes(notesOptional);
            }
            if ((outputOptional = instance.getOutput()).isPresent()) {
                this.output(outputOptional);
            }
            if ((argsOptional = instance.getArgs()).isPresent()) {
                this.args(argsOptional);
            }
            if ((intervalOptional = instance.getInterval()).isPresent()) {
                this.interval(intervalOptional);
            }
            if ((ttlOptional = instance.getTtl()).isPresent()) {
                this.ttl(ttlOptional);
            }
            if ((httpOptional = instance.getHttp()).isPresent()) {
                this.http(httpOptional);
            }
            if ((tcpOptional = instance.getTcp()).isPresent()) {
                this.tcp(tcpOptional);
            }
            if ((grpcOptional = instance.getGrpc()).isPresent()) {
                this.grpc(grpcOptional);
            }
            if ((grpcUseTlsOptional = instance.getGrpcUseTls()).isPresent()) {
                this.grpcUseTls(grpcUseTlsOptional);
            }
            if ((serviceIdOptional = instance.getServiceId()).isPresent()) {
                this.serviceId(serviceIdOptional);
            }
            this.addAllServiceTags(instance.getServiceTags());
            Optional<String> deregisterCriticalServiceAfterOptional = instance.getDeregisterCriticalServiceAfter();
            if (deregisterCriticalServiceAfterOptional.isPresent()) {
                this.deregisterCriticalServiceAfter(deregisterCriticalServiceAfterOptional);
            }
            return this;
        }

        @JsonProperty(value="ID")
        @CanIgnoreReturnValue
        public final Builder id(String id) {
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="Name")
        @CanIgnoreReturnValue
        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder notes(String notes) {
            this.notes = Objects.requireNonNull(notes, "notes");
            return this;
        }

        @JsonProperty(value="Notes")
        @CanIgnoreReturnValue
        public final Builder notes(Optional<String> notes) {
            this.notes = notes.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder output(String output) {
            this.output = Objects.requireNonNull(output, "output");
            return this;
        }

        @JsonProperty(value="Output")
        @CanIgnoreReturnValue
        public final Builder output(Optional<String> output) {
            this.output = output.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder args(List<String> args) {
            this.args = Objects.requireNonNull(args, "args");
            return this;
        }

        @JsonProperty(value="Args")
        @CanIgnoreReturnValue
        public final Builder args(Optional<? extends List<String>> args) {
            this.args = args.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder interval(String interval) {
            this.interval = Objects.requireNonNull(interval, "interval");
            return this;
        }

        @JsonProperty(value="Interval")
        @CanIgnoreReturnValue
        public final Builder interval(Optional<String> interval) {
            this.interval = interval.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder ttl(String ttl) {
            this.ttl = Objects.requireNonNull(ttl, "ttl");
            return this;
        }

        @JsonProperty(value="TTL")
        @CanIgnoreReturnValue
        public final Builder ttl(Optional<String> ttl) {
            this.ttl = ttl.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder http(String http) {
            this.http = Objects.requireNonNull(http, "http");
            return this;
        }

        @JsonProperty(value="HTTP")
        @CanIgnoreReturnValue
        public final Builder http(Optional<String> http) {
            this.http = http.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder tcp(String tcp) {
            this.tcp = Objects.requireNonNull(tcp, "tcp");
            return this;
        }

        @JsonProperty(value="TCP")
        @CanIgnoreReturnValue
        public final Builder tcp(Optional<String> tcp) {
            this.tcp = tcp.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder grpc(String grpc) {
            this.grpc = Objects.requireNonNull(grpc, "grpc");
            return this;
        }

        @JsonProperty(value="GRPC")
        @CanIgnoreReturnValue
        public final Builder grpc(Optional<String> grpc) {
            this.grpc = grpc.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder grpcUseTls(boolean grpcUseTls) {
            this.grpcUseTls = grpcUseTls;
            return this;
        }

        @JsonProperty(value="GRPCUseTLS")
        @CanIgnoreReturnValue
        public final Builder grpcUseTls(Optional<Boolean> grpcUseTls) {
            this.grpcUseTls = grpcUseTls.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder serviceId(String serviceId) {
            this.serviceId = Objects.requireNonNull(serviceId, "serviceId");
            return this;
        }

        @JsonProperty(value="ServiceID")
        @CanIgnoreReturnValue
        public final Builder serviceId(Optional<String> serviceId) {
            this.serviceId = serviceId.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addServiceTags(String element) {
            this.serviceTags.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addServiceTags(String ... elements) {
            this.serviceTags.add((Object[])elements);
            return this;
        }

        @JsonProperty(value="ServiceTags")
        @JsonDeserialize(as=ImmutableList.class, contentAs=String.class)
        @CanIgnoreReturnValue
        public final Builder serviceTags(Iterable<String> elements) {
            this.serviceTags = ImmutableList.builder();
            return this.addAllServiceTags(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllServiceTags(Iterable<String> elements) {
            this.serviceTags.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder deregisterCriticalServiceAfter(String deregisterCriticalServiceAfter) {
            this.deregisterCriticalServiceAfter = Objects.requireNonNull(deregisterCriticalServiceAfter, "deregisterCriticalServiceAfter");
            return this;
        }

        @JsonProperty(value="DeregisterCriticalServiceAfter")
        @CanIgnoreReturnValue
        public final Builder deregisterCriticalServiceAfter(Optional<String> deregisterCriticalServiceAfter) {
            this.deregisterCriticalServiceAfter = deregisterCriticalServiceAfter.orElse(null);
            return this;
        }

        public ImmutableCheck build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return ImmutableCheck.validate(new ImmutableCheck(this.id, this.name, this.notes, this.output, this.args, this.interval, this.ttl, this.http, this.tcp, this.grpc, this.grpcUseTls, this.serviceId, (ImmutableList<String>)this.serviceTags.build(), this.deregisterCriticalServiceAfter));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("name");
            }
            return "Cannot build Check, some of required attributes are not set " + String.valueOf(attributes);
        }
    }

    @Deprecated
    @JsonDeserialize
    @Generated(from="Check", generator="Immutables")
    static final class Json
    extends Check {
        @JsonIgnore
        @Nullable
        String _id;
        @JsonIgnore
        @Nullable
        String _name;
        @JsonIgnore
        @Nullable
        Optional<String> _notes = Optional.empty();
        @JsonIgnore
        @Nullable
        Optional<String> _output = Optional.empty();
        @JsonIgnore
        @Nullable
        Optional<List<String>> _args = Optional.empty();
        @JsonIgnore
        @Nullable
        Optional<String> _interval = Optional.empty();
        @JsonIgnore
        @Nullable
        Optional<String> _ttl = Optional.empty();
        @JsonIgnore
        @Nullable
        Optional<String> _http = Optional.empty();
        @JsonIgnore
        @Nullable
        Optional<String> _tcp = Optional.empty();
        @JsonIgnore
        @Nullable
        Optional<String> _grpc = Optional.empty();
        @JsonIgnore
        @Nullable
        Optional<Boolean> _grpcUseTls = Optional.empty();
        @JsonIgnore
        @Nullable
        Optional<String> _serviceId = Optional.empty();
        @JsonIgnore
        @Nullable
        List<String> _serviceTags = ImmutableList.of();
        @JsonIgnore
        @Nullable
        Optional<String> _deregisterCriticalServiceAfter = Optional.empty();

        Json() {
        }

        @JsonProperty(value="ID")
        public void setId(String id) {
            this._id = id;
        }

        @JsonProperty(value="Name")
        public void setName(String name) {
            this._name = name;
        }

        @JsonProperty(value="Notes")
        public void setNotes(Optional<String> notes) {
            this._notes = notes;
        }

        @JsonProperty(value="Output")
        public void setOutput(Optional<String> output) {
            this._output = output;
        }

        @JsonProperty(value="Args")
        public void setArgs(Optional<List<String>> args) {
            this._args = args;
        }

        @JsonProperty(value="Interval")
        public void setInterval(Optional<String> interval) {
            this._interval = interval;
        }

        @JsonProperty(value="TTL")
        public void setTtl(Optional<String> ttl) {
            this._ttl = ttl;
        }

        @JsonProperty(value="HTTP")
        public void setHttp(Optional<String> http) {
            this._http = http;
        }

        @JsonProperty(value="TCP")
        public void setTcp(Optional<String> tcp) {
            this._tcp = tcp;
        }

        @JsonProperty(value="GRPC")
        public void setGrpc(Optional<String> grpc) {
            this._grpc = grpc;
        }

        @JsonProperty(value="GRPCUseTLS")
        public void setGrpcUseTls(Optional<Boolean> grpcUseTls) {
            this._grpcUseTls = grpcUseTls;
        }

        @JsonProperty(value="ServiceID")
        public void setServiceId(Optional<String> serviceId) {
            this._serviceId = serviceId;
        }

        @JsonProperty(value="ServiceTags")
        @JsonDeserialize(as=ImmutableList.class, contentAs=String.class)
        public void setServiceTags(List<String> serviceTags) {
            this._serviceTags = serviceTags;
        }

        @JsonProperty(value="DeregisterCriticalServiceAfter")
        public void setDeregisterCriticalServiceAfter(Optional<String> deregisterCriticalServiceAfter) {
            this._deregisterCriticalServiceAfter = deregisterCriticalServiceAfter;
        }

        @Override
        public String getId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getNotes() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getOutput() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<List<String>> getArgs() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getInterval() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getTtl() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getHttp() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getTcp() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getGrpc() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Boolean> getGrpcUseTls() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getServiceId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> getServiceTags() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getDeregisterCriticalServiceAfter() {
            throw new UnsupportedOperationException();
        }
    }
}

