/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.consul.model.query;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.immutables.value.Generated;
import org.kiwiproject.consul.model.query.Failover;
import org.kiwiproject.consul.model.query.ServiceQuery;

@JsonIgnoreProperties(ignoreUnknown=true)
@Generated(from="ServiceQuery", generator="Immutables")
public final class ImmutableServiceQuery
extends ServiceQuery {
    private final String service;
    @Nullable
    private final Boolean onlyPassing;
    @Nullable
    private final List<String> tags;
    @Nullable
    private final Failover failover;

    private ImmutableServiceQuery(String service, @Nullable Boolean onlyPassing, @Nullable List<String> tags, @Nullable Failover failover) {
        this.service = service;
        this.onlyPassing = onlyPassing;
        this.tags = tags;
        this.failover = failover;
    }

    @Override
    @JsonProperty(value="Service")
    public String getService() {
        return this.service;
    }

    @Override
    @JsonProperty(value="OnlyPassing")
    public Optional<Boolean> getOnlyPassing() {
        return Optional.ofNullable(this.onlyPassing);
    }

    @Override
    @JsonProperty(value="Tags")
    public Optional<List<String>> getTags() {
        return Optional.ofNullable(this.tags);
    }

    @Override
    @JsonProperty(value="Failover")
    public Optional<Failover> getFailover() {
        return Optional.ofNullable(this.failover);
    }

    public final ImmutableServiceQuery withService(String value) {
        String newValue = Objects.requireNonNull(value, "service");
        if (this.service.equals(newValue)) {
            return this;
        }
        return new ImmutableServiceQuery(newValue, this.onlyPassing, this.tags, this.failover);
    }

    public final ImmutableServiceQuery withOnlyPassing(boolean value) {
        Boolean newValue = value;
        if (Objects.equals(this.onlyPassing, newValue)) {
            return this;
        }
        return new ImmutableServiceQuery(this.service, newValue, this.tags, this.failover);
    }

    public final ImmutableServiceQuery withOnlyPassing(Optional<Boolean> optional) {
        Boolean value = optional.orElse(null);
        if (Objects.equals(this.onlyPassing, value)) {
            return this;
        }
        return new ImmutableServiceQuery(this.service, value, this.tags, this.failover);
    }

    public final ImmutableServiceQuery withTags(List<String> value) {
        List<String> newValue = Objects.requireNonNull(value, "tags");
        if (this.tags == newValue) {
            return this;
        }
        return new ImmutableServiceQuery(this.service, this.onlyPassing, newValue, this.failover);
    }

    public final ImmutableServiceQuery withTags(Optional<? extends List<String>> optional) {
        List value = optional.orElse(null);
        if (this.tags == value) {
            return this;
        }
        return new ImmutableServiceQuery(this.service, this.onlyPassing, value, this.failover);
    }

    public final ImmutableServiceQuery withFailover(Failover value) {
        Failover newValue = Objects.requireNonNull(value, "failover");
        if (this.failover == newValue) {
            return this;
        }
        return new ImmutableServiceQuery(this.service, this.onlyPassing, this.tags, newValue);
    }

    public final ImmutableServiceQuery withFailover(Optional<? extends Failover> optional) {
        Failover value = optional.orElse(null);
        if (this.failover == value) {
            return this;
        }
        return new ImmutableServiceQuery(this.service, this.onlyPassing, this.tags, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableServiceQuery && this.equalsByValue((ImmutableServiceQuery)another);
    }

    private boolean equalsByValue(ImmutableServiceQuery another) {
        return this.service.equals(another.service) && Objects.equals(this.onlyPassing, another.onlyPassing) && Objects.equals(this.tags, another.tags) && Objects.equals(this.failover, another.failover);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.service.hashCode();
        h += (h << 5) + Objects.hashCode(this.onlyPassing);
        h += (h << 5) + Objects.hashCode(this.tags);
        h += (h << 5) + Objects.hashCode(this.failover);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"ServiceQuery").omitNullValues().add("service", (Object)this.service).add("onlyPassing", (Object)this.onlyPassing).add("tags", this.tags).add("failover", (Object)this.failover).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableServiceQuery fromJson(Json json) {
        Builder builder = ImmutableServiceQuery.builder();
        if (json._service != null) {
            builder.service(json._service);
        }
        if (json._onlyPassing != null) {
            builder.onlyPassing(json._onlyPassing);
        }
        if (json._tags != null) {
            builder.tags(json._tags);
        }
        if (json._failover != null) {
            builder.failover(json._failover);
        }
        return builder.build();
    }

    public static ImmutableServiceQuery copyOf(ServiceQuery instance) {
        if (instance instanceof ImmutableServiceQuery) {
            return (ImmutableServiceQuery)instance;
        }
        return ImmutableServiceQuery.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ServiceQuery", generator="Immutables")
    public static final class Builder {
        private static final long INIT_BIT_SERVICE = 1L;
        private long initBits = 1L;
        @Nullable
        private String service;
        @Nullable
        private Boolean onlyPassing;
        @Nullable
        private List<String> tags;
        @Nullable
        private Failover failover;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(ServiceQuery instance) {
            Optional<Failover> failoverOptional;
            Optional<List<String>> tagsOptional;
            Objects.requireNonNull(instance, "instance");
            this.service(instance.getService());
            Optional<Boolean> onlyPassingOptional = instance.getOnlyPassing();
            if (onlyPassingOptional.isPresent()) {
                this.onlyPassing(onlyPassingOptional);
            }
            if ((tagsOptional = instance.getTags()).isPresent()) {
                this.tags(tagsOptional);
            }
            if ((failoverOptional = instance.getFailover()).isPresent()) {
                this.failover(failoverOptional);
            }
            return this;
        }

        @JsonProperty(value="Service")
        @CanIgnoreReturnValue
        public final Builder service(String service) {
            this.service = Objects.requireNonNull(service, "service");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder onlyPassing(boolean onlyPassing) {
            this.onlyPassing = onlyPassing;
            return this;
        }

        @JsonProperty(value="OnlyPassing")
        @CanIgnoreReturnValue
        public final Builder onlyPassing(Optional<Boolean> onlyPassing) {
            this.onlyPassing = onlyPassing.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder tags(List<String> tags) {
            this.tags = Objects.requireNonNull(tags, "tags");
            return this;
        }

        @JsonProperty(value="Tags")
        @CanIgnoreReturnValue
        public final Builder tags(Optional<? extends List<String>> tags) {
            this.tags = tags.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder failover(Failover failover) {
            this.failover = Objects.requireNonNull(failover, "failover");
            return this;
        }

        @JsonProperty(value="Failover")
        @CanIgnoreReturnValue
        public final Builder failover(Optional<? extends Failover> failover) {
            this.failover = failover.orElse(null);
            return this;
        }

        public ImmutableServiceQuery build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableServiceQuery(this.service, this.onlyPassing, this.tags, this.failover);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("service");
            }
            return "Cannot build ServiceQuery, some of required attributes are not set " + String.valueOf(attributes);
        }
    }

    @Deprecated
    @JsonDeserialize
    @Generated(from="ServiceQuery", generator="Immutables")
    static final class Json
    extends ServiceQuery {
        @JsonIgnore
        @Nullable
        String _service;
        @JsonIgnore
        @Nullable
        Optional<Boolean> _onlyPassing = Optional.empty();
        @JsonIgnore
        @Nullable
        Optional<List<String>> _tags = Optional.empty();
        @JsonIgnore
        @Nullable
        Optional<Failover> _failover = Optional.empty();

        Json() {
        }

        @JsonProperty(value="Service")
        public void setService(String service) {
            this._service = service;
        }

        @JsonProperty(value="OnlyPassing")
        public void setOnlyPassing(Optional<Boolean> onlyPassing) {
            this._onlyPassing = onlyPassing;
        }

        @JsonProperty(value="Tags")
        public void setTags(Optional<List<String>> tags) {
            this._tags = tags;
        }

        @JsonProperty(value="Failover")
        public void setFailover(Optional<Failover> failover) {
            this._failover = failover;
        }

        @Override
        public String getService() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Boolean> getOnlyPassing() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<List<String>> getTags() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Failover> getFailover() {
            throw new UnsupportedOperationException();
        }
    }
}

