/*
 * Decompiled with CFR 0.152.
 */
package org.kiwiproject.consul.option;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import jakarta.annotation.Nullable;
import java.util.Objects;
import java.util.Optional;
import org.immutables.value.Generated;
import org.kiwiproject.consul.option.ConsistencyMode;
import org.kiwiproject.consul.option.ParamAdder;
import org.kiwiproject.consul.option.TransactionOptions;

@Generated(from="TransactionOptions", generator="Immutables")
public final class ImmutableTransactionOptions
extends TransactionOptions {
    private final ImmutableList<String> toQueryParameters;
    @Nullable
    private final String datacenter;
    private final ConsistencyMode consistencyMode;

    private ImmutableTransactionOptions(Builder builder) {
        this.toQueryParameters = builder.toQueryParameters.build();
        this.datacenter = builder.datacenter;
        this.consistencyMode = builder.consistencyMode != null ? builder.consistencyMode : Objects.requireNonNull(super.getConsistencyMode(), "consistencyMode");
    }

    private ImmutableTransactionOptions(ImmutableList<String> toQueryParameters, @Nullable String datacenter, ConsistencyMode consistencyMode) {
        this.toQueryParameters = toQueryParameters;
        this.datacenter = datacenter;
        this.consistencyMode = consistencyMode;
    }

    public ImmutableList<String> toQueryParameters() {
        return this.toQueryParameters;
    }

    @Override
    public Optional<String> getDatacenter() {
        return Optional.ofNullable(this.datacenter);
    }

    @Override
    public ConsistencyMode getConsistencyMode() {
        return this.consistencyMode;
    }

    public final ImmutableTransactionOptions withToQueryParameters(String ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableTransactionOptions((ImmutableList<String>)newValue, this.datacenter, this.consistencyMode);
    }

    public final ImmutableTransactionOptions withToQueryParameters(Iterable<String> elements) {
        if (this.toQueryParameters == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableTransactionOptions((ImmutableList<String>)newValue, this.datacenter, this.consistencyMode);
    }

    public final ImmutableTransactionOptions withDatacenter(String value) {
        String newValue = Objects.requireNonNull(value, "datacenter");
        if (Objects.equals(this.datacenter, newValue)) {
            return this;
        }
        return new ImmutableTransactionOptions(this.toQueryParameters, newValue, this.consistencyMode);
    }

    public final ImmutableTransactionOptions withDatacenter(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.datacenter, value)) {
            return this;
        }
        return new ImmutableTransactionOptions(this.toQueryParameters, value, this.consistencyMode);
    }

    public final ImmutableTransactionOptions withConsistencyMode(ConsistencyMode value) {
        if (this.consistencyMode == value) {
            return this;
        }
        ConsistencyMode newValue = Objects.requireNonNull(value, "consistencyMode");
        return new ImmutableTransactionOptions(this.toQueryParameters, this.datacenter, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableTransactionOptions && this.equalsByValue((ImmutableTransactionOptions)another);
    }

    private boolean equalsByValue(ImmutableTransactionOptions another) {
        return this.toQueryParameters.equals(another.toQueryParameters) && Objects.equals(this.datacenter, another.datacenter) && this.consistencyMode.equals(another.consistencyMode);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.toQueryParameters.hashCode();
        h += (h << 5) + Objects.hashCode(this.datacenter);
        h += (h << 5) + this.consistencyMode.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"TransactionOptions").omitNullValues().add("toQueryParameters", this.toQueryParameters).add("datacenter", (Object)this.datacenter).add("consistencyMode", (Object)this.consistencyMode).toString();
    }

    public static ImmutableTransactionOptions copyOf(TransactionOptions instance) {
        if (instance instanceof ImmutableTransactionOptions) {
            return (ImmutableTransactionOptions)instance;
        }
        return ImmutableTransactionOptions.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="TransactionOptions", generator="Immutables")
    public static final class Builder {
        private ImmutableList.Builder<String> toQueryParameters = ImmutableList.builder();
        @Nullable
        private String datacenter;
        @Nullable
        private ConsistencyMode consistencyMode;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(ParamAdder instance) {
            Objects.requireNonNull(instance, "instance");
            this.mergeInternal(instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(TransactionOptions instance) {
            Objects.requireNonNull(instance, "instance");
            this.mergeInternal(instance);
            return this;
        }

        private void mergeInternal(Object object) {
            ParamAdder instance;
            long bits = 0L;
            if (object instanceof ParamAdder) {
                instance = (ParamAdder)object;
                this.addAllToQueryParameters(instance.toQueryParameters());
            }
            if (object instanceof TransactionOptions) {
                instance = (TransactionOptions)object;
                Optional<String> datacenterOptional = ((TransactionOptions)instance).getDatacenter();
                if (datacenterOptional.isPresent()) {
                    this.datacenter(datacenterOptional);
                }
                this.consistencyMode(((TransactionOptions)instance).getConsistencyMode());
            }
        }

        @CanIgnoreReturnValue
        public final Builder addToQueryParameters(String element) {
            this.toQueryParameters.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addToQueryParameters(String ... elements) {
            this.toQueryParameters.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder toQueryParameters(Iterable<String> elements) {
            this.toQueryParameters = ImmutableList.builder();
            return this.addAllToQueryParameters(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllToQueryParameters(Iterable<String> elements) {
            this.toQueryParameters.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder datacenter(String datacenter) {
            this.datacenter = Objects.requireNonNull(datacenter, "datacenter");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder datacenter(Optional<String> datacenter) {
            this.datacenter = datacenter.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder consistencyMode(ConsistencyMode consistencyMode) {
            this.consistencyMode = Objects.requireNonNull(consistencyMode, "consistencyMode");
            return this;
        }

        public ImmutableTransactionOptions build() {
            return new ImmutableTransactionOptions(this);
        }
    }
}

