/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.binance;

import java.io.IOException;
import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.knowm.xchange.binance.dto.BinanceException;
import org.knowm.xchange.binance.dto.marketdata.BinanceAggTrades;
import org.knowm.xchange.binance.dto.marketdata.BinanceOrderbook;
import org.knowm.xchange.binance.dto.marketdata.BinancePrice;
import org.knowm.xchange.binance.dto.marketdata.BinancePriceQuantity;
import org.knowm.xchange.binance.dto.marketdata.BinanceTicker24h;
import org.knowm.xchange.binance.dto.meta.BinanceTime;
import org.knowm.xchange.binance.dto.meta.exchangeinfo.BinanceExchangeInfo;

@Path(value="")
@Produces(value={"application/json"})
public interface Binance {
    @GET
    @Path(value="api/v1/ping")
    public Object ping() throws IOException;

    @GET
    @Path(value="api/v1/time")
    public BinanceTime time() throws IOException;

    @GET
    @Path(value="api/v1/exchangeInfo")
    public BinanceExchangeInfo exchangeInfo() throws IOException;

    @GET
    @Path(value="api/v1/depth")
    public BinanceOrderbook depth(@QueryParam(value="symbol") String var1, @QueryParam(value="limit") Integer var2) throws IOException, BinanceException;

    @GET
    @Path(value="api/v1/aggTrades")
    public List<BinanceAggTrades> aggTrades(@QueryParam(value="symbol") String var1, @QueryParam(value="fromId") Long var2, @QueryParam(value="startTime") Long var3, @QueryParam(value="endTime") Long var4, @QueryParam(value="limit") Integer var5) throws IOException, BinanceException;

    @GET
    @Path(value="api/v1/klines")
    public List<Object[]> klines(@QueryParam(value="symbol") String var1, @QueryParam(value="interval") String var2, @QueryParam(value="limit") Integer var3, @QueryParam(value="startTime") Long var4, @QueryParam(value="endTime") Long var5) throws IOException, BinanceException;

    @GET
    @Path(value="api/v1/ticker/24hr")
    public List<BinanceTicker24h> ticker24h() throws IOException, BinanceException;

    @GET
    @Path(value="api/v1/ticker/24hr")
    public BinanceTicker24h ticker24h(@QueryParam(value="symbol") String var1) throws IOException, BinanceException;

    @GET
    @Path(value="api/v1/ticker/allPrices")
    public List<BinancePrice> tickerAllPrices() throws IOException, BinanceException;

    @GET
    @Path(value="api/v1/ticker/allBookTickers")
    public List<BinancePriceQuantity> tickerAllBookTickers() throws IOException, BinanceException;
}

