/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.binance;

import org.apache.commons.lang3.StringUtils;
import org.knowm.xchange.binance.dto.BinanceException;
import org.knowm.xchange.exceptions.CurrencyPairNotValidException;
import org.knowm.xchange.exceptions.ExchangeException;

public final class BinanceErrorAdapter {
    private BinanceErrorAdapter() {
    }

    public static ExchangeException adapt(BinanceException e) {
        String message = e.getMessage();
        if (StringUtils.isEmpty((CharSequence)message)) {
            message = "Operation failed without any error message";
        }
        switch (e.getCode()) {
            case -1121: {
                return new CurrencyPairNotValidException(message, (Throwable)e);
            }
        }
        return new ExchangeException(message, (Throwable)e);
    }
}

