/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.binance.service;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.binance.BinanceErrorAdapter;
import org.knowm.xchange.binance.dto.BinanceException;
import org.knowm.xchange.binance.dto.account.BinanceAccountInformation;
import org.knowm.xchange.binance.service.BinanceAccountServiceRaw;
import org.knowm.xchange.binance.service.BinanceFundingHistoryParams;
import org.knowm.xchange.currency.Currency;
import org.knowm.xchange.dto.account.AccountInfo;
import org.knowm.xchange.dto.account.Balance;
import org.knowm.xchange.dto.account.FundingRecord;
import org.knowm.xchange.dto.account.Wallet;
import org.knowm.xchange.service.account.AccountService;
import org.knowm.xchange.service.trade.params.DefaultWithdrawFundsParams;
import org.knowm.xchange.service.trade.params.HistoryParamsFundingType;
import org.knowm.xchange.service.trade.params.RippleWithdrawFundsParams;
import org.knowm.xchange.service.trade.params.TradeHistoryParamCurrency;
import org.knowm.xchange.service.trade.params.TradeHistoryParams;
import org.knowm.xchange.service.trade.params.TradeHistoryParamsTimeSpan;
import org.knowm.xchange.service.trade.params.WithdrawFundsParams;

public class BinanceAccountService
extends BinanceAccountServiceRaw
implements AccountService {
    public BinanceAccountService(Exchange exchange) {
        super(exchange);
    }

    private static FundingRecord.Status withdrawStatus(int status) {
        switch (status) {
            case 0: 
            case 2: 
            case 4: {
                return FundingRecord.Status.PROCESSING;
            }
            case 1: {
                return FundingRecord.Status.CANCELLED;
            }
            case 3: 
            case 5: {
                return FundingRecord.Status.FAILED;
            }
            case 6: {
                return FundingRecord.Status.COMPLETE;
            }
        }
        throw new RuntimeException("Unknown binance withdraw status: " + status);
    }

    private static FundingRecord.Status depositStatus(int status) {
        switch (status) {
            case 0: {
                return FundingRecord.Status.PROCESSING;
            }
            case 1: {
                return FundingRecord.Status.COMPLETE;
            }
        }
        throw new RuntimeException("Unknown binance deposit status: " + status);
    }

    public AccountInfo getAccountInfo() throws IOException {
        try {
            Long recvWindow = (Long)this.exchange.getExchangeSpecification().getExchangeSpecificParametersItem("recvWindow");
            BinanceAccountInformation acc = super.account(recvWindow, this.getTimestamp());
            List balances = acc.balances.stream().map(b -> new Balance(b.getCurrency(), b.getTotal(), b.getAvailable())).collect(Collectors.toList());
            return new AccountInfo(new Wallet[]{new Wallet(balances)});
        }
        catch (BinanceException e) {
            throw BinanceErrorAdapter.adapt(e);
        }
    }

    public String withdrawFunds(Currency currency, BigDecimal amount, String address) throws IOException {
        try {
            return super.withdraw(currency.getCurrencyCode(), address, amount);
        }
        catch (BinanceException e) {
            throw BinanceErrorAdapter.adapt(e);
        }
    }

    public String withdrawFunds(WithdrawFundsParams params) throws IOException {
        try {
            if (!(params instanceof DefaultWithdrawFundsParams)) {
                throw new IllegalArgumentException("DefaultWithdrawFundsParams must be provided.");
            }
            String id = null;
            if (params instanceof RippleWithdrawFundsParams) {
                RippleWithdrawFundsParams rippleParams = null;
                rippleParams = (RippleWithdrawFundsParams)params;
                id = super.withdraw(rippleParams.getCurrency().getCurrencyCode(), rippleParams.getAddress(), rippleParams.getTag(), rippleParams.getAmount());
            } else {
                DefaultWithdrawFundsParams p = (DefaultWithdrawFundsParams)params;
                id = super.withdraw(p.getCurrency().getCurrencyCode(), p.getAddress(), p.getAmount());
            }
            return id;
        }
        catch (BinanceException e) {
            throw BinanceErrorAdapter.adapt(e);
        }
    }

    public String requestDepositAddress(Currency currency, String ... args) throws IOException {
        try {
            return super.requestDepositAddress((Currency)currency).address;
        }
        catch (BinanceException e) {
            throw BinanceErrorAdapter.adapt(e);
        }
    }

    public TradeHistoryParams createFundingHistoryParams() {
        return new BinanceFundingHistoryParams();
    }

    public List<FundingRecord> getFundingHistory(TradeHistoryParams params) throws IOException {
        try {
            HistoryParamsFundingType f;
            TradeHistoryParamCurrency cp;
            String asset = null;
            if (params instanceof TradeHistoryParamCurrency && (cp = (TradeHistoryParamCurrency)params).getCurrency() != null) {
                asset = cp.getCurrency().getCurrencyCode();
            }
            Long recvWindow = (Long)this.exchange.getExchangeSpecification().getExchangeSpecificParametersItem("recvWindow");
            boolean withdrawals = true;
            boolean deposits = true;
            Long startTime = null;
            Long endTime = null;
            if (params instanceof TradeHistoryParamsTimeSpan) {
                TradeHistoryParamsTimeSpan tp = (TradeHistoryParamsTimeSpan)params;
                if (tp.getStartTime() != null) {
                    startTime = tp.getStartTime().getTime();
                }
                if (tp.getEndTime() != null) {
                    endTime = tp.getEndTime().getTime();
                }
            }
            if (params instanceof HistoryParamsFundingType && (f = (HistoryParamsFundingType)params).getType() != null) {
                withdrawals = f.getType() == FundingRecord.Type.WITHDRAWAL;
                deposits = f.getType() == FundingRecord.Type.DEPOSIT;
            }
            ArrayList<FundingRecord> result = new ArrayList<FundingRecord>();
            if (withdrawals) {
                super.withdrawHistory(asset, startTime, endTime, recvWindow, this.getTimestamp()).forEach(w -> result.add(new FundingRecord(w.address, new Date(w.applyTime), Currency.getInstance((String)w.asset), w.amount, w.id, w.txId, FundingRecord.Type.WITHDRAWAL, BinanceAccountService.withdrawStatus(w.status), null, null, null)));
            }
            if (deposits) {
                super.depositHistory(asset, startTime, endTime, recvWindow, this.getTimestamp()).forEach(d -> result.add(new FundingRecord(d.address, new Date(d.insertTime), Currency.getInstance((String)d.asset), d.amount, null, d.txId, FundingRecord.Type.DEPOSIT, BinanceAccountService.depositStatus(d.status), null, null, null)));
            }
            return result;
        }
        catch (BinanceException e) {
            throw BinanceErrorAdapter.adapt(e);
        }
    }
}

