/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.binance.service;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.List;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.binance.BinanceAdapters;
import org.knowm.xchange.binance.dto.BinanceException;
import org.knowm.xchange.binance.dto.account.BinanceAccountInformation;
import org.knowm.xchange.binance.dto.account.DepositAddress;
import org.knowm.xchange.binance.dto.account.DepositList;
import org.knowm.xchange.binance.dto.account.WapiResponse;
import org.knowm.xchange.binance.dto.account.WithdrawList;
import org.knowm.xchange.binance.dto.account.WithdrawRequest;
import org.knowm.xchange.binance.service.BinanceBaseService;
import org.knowm.xchange.currency.Currency;

public class BinanceAccountServiceRaw
extends BinanceBaseService {
    public BinanceAccountServiceRaw(Exchange exchange) {
        super(exchange);
    }

    public BinanceAccountInformation account(Long recvWindow, long timestamp) throws BinanceException, IOException {
        return this.binance.account(recvWindow, timestamp, this.apiKey, this.signatureCreator);
    }

    public String withdraw(String asset, String address, BigDecimal amount) throws IOException, BinanceException {
        String name = address.length() <= 10 ? address : address.substring(0, 10);
        return this.withdraw(asset, address, amount, name, null, this.getTimestamp());
    }

    public String withdraw(String asset, String address, String addressTag, BigDecimal amount) throws IOException, BinanceException {
        String name = address.length() <= 10 ? address : address.substring(0, 10);
        Long recvWindow = (Long)this.exchange.getExchangeSpecification().getExchangeSpecificParametersItem("recvWindow");
        return this.withdraw(asset, address, addressTag, amount, name, recvWindow, this.getTimestamp());
    }

    private String withdraw(String asset, String address, BigDecimal amount, String name, Long recvWindow, long timestamp) throws IOException, BinanceException {
        WithdrawRequest result = this.binance.withdraw(asset, address, null, amount, name, recvWindow, timestamp, this.apiKey, this.signatureCreator);
        this.checkWapiResponse(result);
        return result.getData();
    }

    private String withdraw(String asset, String address, String addressTag, BigDecimal amount, String name, Long recvWindow, long timestamp) throws IOException, BinanceException {
        WithdrawRequest result = this.binance.withdraw(asset, address, addressTag, amount, name, recvWindow, timestamp, this.apiKey, this.signatureCreator);
        this.checkWapiResponse(result);
        return result.getData();
    }

    public DepositAddress requestDepositAddress(Currency currency) throws IOException {
        Long recvWindow = (Long)this.exchange.getExchangeSpecification().getExchangeSpecificParametersItem("recvWindow");
        return this.binance.depositAddress(BinanceAdapters.toSymbol(currency), recvWindow, this.getTimestamp(), this.apiKey, this.signatureCreator);
    }

    public List<DepositList.BinanceDeposit> depositHistory(String asset, Long startTime, Long endTime, Long recvWindow, long timestamp) throws BinanceException, IOException {
        DepositList result = this.binance.depositHistory(asset, startTime, endTime, recvWindow, timestamp, this.apiKey, this.signatureCreator);
        return this.checkWapiResponse(result);
    }

    public List<WithdrawList.BinanceWithdraw> withdrawHistory(String asset, Long startTime, Long endTime, Long recvWindow, long timestamp) throws BinanceException, IOException {
        WithdrawList result = this.binance.withdrawHistory(asset, startTime, endTime, recvWindow, timestamp, this.apiKey, this.signatureCreator);
        return this.checkWapiResponse(result);
    }

    private <T> T checkWapiResponse(WapiResponse<T> result) {
        if (!result.success) {
            BinanceException exception;
            try {
                exception = (BinanceException)new ObjectMapper().readValue(result.msg, BinanceException.class);
            }
            catch (Throwable e) {
                exception = new BinanceException(-1, result.msg);
            }
            throw exception;
        }
        return result.getData();
    }
}

