/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.binance.service;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.binance.BinanceAuthenticated;
import org.knowm.xchange.binance.BinanceExchange;
import org.knowm.xchange.binance.dto.meta.exchangeinfo.BinanceExchangeInfo;
import org.knowm.xchange.binance.service.BinanceHmacDigest;
import org.knowm.xchange.service.BaseExchangeService;
import org.knowm.xchange.service.BaseService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import si.mazi.rescu.ClientConfig;
import si.mazi.rescu.Interceptor;
import si.mazi.rescu.ParamsDigest;
import si.mazi.rescu.RestProxyFactory;

public class BinanceBaseService
extends BaseExchangeService
implements BaseService {
    protected final Logger LOG = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    protected final String apiKey;
    protected final BinanceAuthenticated binance;
    protected final ParamsDigest signatureCreator;

    protected BinanceBaseService(Exchange exchange) {
        super(exchange);
        this.binance = (BinanceAuthenticated)RestProxyFactory.createProxy(BinanceAuthenticated.class, (String)exchange.getExchangeSpecification().getSslUri(), (ClientConfig)this.getClientConfig(), (Interceptor[])new Interceptor[0]);
        this.apiKey = exchange.getExchangeSpecification().getApiKey();
        this.signatureCreator = BinanceHmacDigest.createInstance(exchange.getExchangeSpecification().getSecretKey());
    }

    public long getTimestamp() throws IOException {
        long deltaServerTime = ((BinanceExchange)this.exchange).deltaServerTime();
        Date systemTime = new Date(System.currentTimeMillis());
        Date serverTime = new Date(systemTime.getTime() + deltaServerTime);
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss:SSS");
        this.LOG.trace("getTimestamp: {} + {} => {}", new Object[]{df.format(systemTime), deltaServerTime, df.format(serverTime)});
        return serverTime.getTime();
    }

    public void refreshTimestamp() {
        ((BinanceExchange)this.exchange).clearDeltaServerTime();
    }

    public BinanceExchangeInfo getExchangeInfo() throws IOException {
        return this.binance.exchangeInfo();
    }
}

