/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.binance;

import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.knowm.xchange.ExchangeSpecification;
import org.knowm.xchange.binance.Binance;
import org.knowm.xchange.binance.dto.meta.BinanceTime;
import org.knowm.xchange.client.ResilienceRegistries;
import org.knowm.xchange.client.ResilienceUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import si.mazi.rescu.SynchronizedValueFactory;

public class BinanceTimestampFactory
implements SynchronizedValueFactory<Long> {
    private static final Logger LOG = LoggerFactory.getLogger(BinanceTimestampFactory.class);
    private final Binance binance;
    private final ExchangeSpecification.ResilienceSpecification resilienceSpecification;
    private final ResilienceRegistries resilienceRegistries;
    private Long deltaServerTimeExpire;
    private Long deltaServerTime;

    public BinanceTimestampFactory(Binance binance, ExchangeSpecification.ResilienceSpecification resilienceSpecification, ResilienceRegistries resilienceRegistries) {
        this.binance = binance;
        this.resilienceSpecification = resilienceSpecification;
        this.resilienceRegistries = resilienceRegistries;
    }

    public Long createValue() {
        return System.currentTimeMillis();
    }

    public void clearDeltaServerTime() {
        this.deltaServerTime = null;
    }

    public long deltaServerTime() throws IOException {
        if (this.deltaServerTime == null || this.deltaServerTimeExpire <= System.currentTimeMillis()) {
            Date serverTime = new Date(this.binanceTime().getServerTime().getTime());
            Date systemTime = new Date(System.currentTimeMillis());
            this.deltaServerTimeExpire = systemTime.getTime() + TimeUnit.MINUTES.toMillis(10L);
            this.deltaServerTime = serverTime.getTime() - systemTime.getTime();
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss:SSS");
            LOG.trace("deltaServerTime: {} - {} => {}", new Object[]{df.format(serverTime), df.format(systemTime), this.deltaServerTime});
        }
        return this.deltaServerTime;
    }

    private BinanceTime binanceTime() throws IOException {
        return (BinanceTime)ResilienceUtils.decorateApiCall((ExchangeSpecification.ResilienceSpecification)this.resilienceSpecification, () -> this.binance.time()).withRetry(this.resilienceRegistries.retries().retry("time")).withRateLimiter(this.resilienceRegistries.rateLimiters().rateLimiter("requestWeight")).call();
    }
}

