/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.binance.dto.marketdata;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.math.BigDecimal;
import org.knowm.xchange.binance.BinanceAdapters;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.marketdata.Ticker;

public final class BinanceBookTicker {
    public long updateId;
    private CurrencyPair pair;
    private final BigDecimal bidPrice;
    private final BigDecimal bidQty;
    private final BigDecimal askPrice;
    private final BigDecimal askQty;
    private final String symbol;
    private Ticker ticker;

    public BinanceBookTicker(@JsonProperty(value="bidPrice") BigDecimal bidPrice, @JsonProperty(value="bidQty") BigDecimal bidQty, @JsonProperty(value="askPrice") BigDecimal askPrice, @JsonProperty(value="askQty") BigDecimal askQty, @JsonProperty(value="symbol") String symbol) {
        this.bidPrice = bidPrice;
        this.bidQty = bidQty;
        this.askPrice = askPrice;
        this.askQty = askQty;
        this.symbol = symbol;
    }

    public long getUpdateId() {
        return this.updateId;
    }

    public void setUpdateId(long updateId) {
        this.updateId = updateId;
    }

    public CurrencyPair getCurrencyPair() {
        return this.pair;
    }

    public void setCurrencyPair(CurrencyPair pair) {
        this.pair = pair;
    }

    public BigDecimal getBidPrice() {
        return this.bidPrice;
    }

    public BigDecimal getBidQty() {
        return this.bidQty;
    }

    public BigDecimal getAskPrice() {
        return this.askPrice;
    }

    public BigDecimal getAskQty() {
        return this.askQty;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public synchronized Ticker toTicker() {
        CurrencyPair currencyPair = this.pair;
        if (currencyPair == null) {
            currencyPair = BinanceAdapters.adaptSymbol(this.symbol);
        }
        if (this.ticker == null) {
            this.ticker = new Ticker.Builder().currencyPair(currencyPair).ask(this.askPrice).bid(this.bidPrice).askSize(this.askQty).bidSize(this.bidQty).build();
        }
        return this.ticker;
    }
}

