/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.binance.dto.account;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import org.knowm.xchange.binance.dto.account.WapiResponse;

public final class TransferHistoryResponse
extends WapiResponse<List<TransferHistory>> {
    private final TransferHistory[] transferHistories;

    public TransferHistoryResponse(@JsonProperty(value="transfers") TransferHistory[] transferHistories, @JsonProperty(value="success") boolean success, @JsonProperty(value="msg") String msg) {
        super(success, msg);
        this.transferHistories = transferHistories;
    }

    @Override
    public List<TransferHistory> getData() {
        return Arrays.asList(this.transferHistories);
    }

    public String toString() {
        return "transferHistories [rows=" + Arrays.toString(this.transferHistories) + "]";
    }

    public static final class TransferHistory {
        private String from;
        private String to;
        private String asset;
        private BigDecimal qty;
        private long time;

        public String getFrom() {
            return this.from;
        }

        public String getTo() {
            return this.to;
        }

        public String getAsset() {
            return this.asset;
        }

        public BigDecimal getQty() {
            return this.qty;
        }

        public long getTime() {
            return this.time;
        }

        public void setFrom(String from) {
            this.from = from;
        }

        public void setTo(String to) {
            this.to = to;
        }

        public void setAsset(String asset) {
            this.asset = asset;
        }

        public void setQty(BigDecimal qty) {
            this.qty = qty;
        }

        public void setTime(long time) {
            this.time = time;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TransferHistory)) {
                return false;
            }
            TransferHistory other = (TransferHistory)o;
            if (this.getTime() != other.getTime()) {
                return false;
            }
            String this$from = this.getFrom();
            String other$from = other.getFrom();
            if (this$from == null ? other$from != null : !this$from.equals(other$from)) {
                return false;
            }
            String this$to = this.getTo();
            String other$to = other.getTo();
            if (this$to == null ? other$to != null : !this$to.equals(other$to)) {
                return false;
            }
            String this$asset = this.getAsset();
            String other$asset = other.getAsset();
            if (this$asset == null ? other$asset != null : !this$asset.equals(other$asset)) {
                return false;
            }
            BigDecimal this$qty = this.getQty();
            BigDecimal other$qty = other.getQty();
            return !(this$qty == null ? other$qty != null : !((Object)this$qty).equals(other$qty));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $time = this.getTime();
            result = result * 59 + (int)($time >>> 32 ^ $time);
            String $from = this.getFrom();
            result = result * 59 + ($from == null ? 43 : $from.hashCode());
            String $to = this.getTo();
            result = result * 59 + ($to == null ? 43 : $to.hashCode());
            String $asset = this.getAsset();
            result = result * 59 + ($asset == null ? 43 : $asset.hashCode());
            BigDecimal $qty = this.getQty();
            result = result * 59 + ($qty == null ? 43 : ((Object)$qty).hashCode());
            return result;
        }

        public String toString() {
            return "TransferHistoryResponse.TransferHistory(from=" + this.getFrom() + ", to=" + this.getTo() + ", asset=" + this.getAsset() + ", qty=" + this.getQty() + ", time=" + this.getTime() + ")";
        }
    }
}

