/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.binance;

import java.util.Map;
import org.knowm.xchange.BaseExchange;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.ExchangeSpecification;
import org.knowm.xchange.binance.BinanceAdapters;
import org.knowm.xchange.binance.BinanceResilience;
import org.knowm.xchange.binance.BinanceTimestampFactory;
import org.knowm.xchange.binance.dto.account.AssetDetail;
import org.knowm.xchange.binance.service.BinanceAccountService;
import org.knowm.xchange.binance.service.BinanceMarketDataService;
import org.knowm.xchange.binance.service.BinanceTradeService;
import org.knowm.xchange.client.ResilienceRegistries;
import org.knowm.xchange.exceptions.ExchangeException;
import org.knowm.xchange.utils.AuthUtils;
import si.mazi.rescu.SynchronizedValueFactory;

public class BinanceExchange
extends BaseExchange
implements Exchange {
    public static final String SPECIFIC_PARAM_USE_SANDBOX = "Use_Sandbox";
    public static final String SPECIFIC_PARAM_USE_FUTURES_SANDBOX = "Use_Sandbox_Futures";
    private static final String SPOT_URL = "https://api.binance.com";
    public static final String FUTURES_URL = "https://fapi.binance.com";
    public static final String SANDBOX_FUTURES_URL = "https://testnet.binancefuture.com";
    protected static ResilienceRegistries RESILIENCE_REGISTRIES;
    protected SynchronizedValueFactory<Long> timestampFactory;

    protected void initServices() {
        this.timestampFactory = new BinanceTimestampFactory(this.getExchangeSpecification().getResilience(), this.getResilienceRegistries());
        this.marketDataService = new BinanceMarketDataService(this, this.getResilienceRegistries());
        this.tradeService = new BinanceTradeService(this, this.getResilienceRegistries());
        this.accountService = new BinanceAccountService(this, this.getResilienceRegistries());
    }

    public SynchronizedValueFactory<Long> getTimestampFactory() {
        return this.timestampFactory;
    }

    public SynchronizedValueFactory<Long> getNonceFactory() {
        throw new UnsupportedOperationException("Binance uses timestamp/recvwindow rather than a nonce");
    }

    public static void resetResilienceRegistries() {
        RESILIENCE_REGISTRIES = null;
    }

    public ResilienceRegistries getResilienceRegistries() {
        if (RESILIENCE_REGISTRIES == null) {
            RESILIENCE_REGISTRIES = BinanceResilience.createRegistries();
        }
        return RESILIENCE_REGISTRIES;
    }

    public ExchangeSpecification getDefaultExchangeSpecification() {
        ExchangeSpecification spec = new ExchangeSpecification(((Object)((Object)this)).getClass());
        spec.setSslUri(SPOT_URL);
        spec.setHost("www.binance.com");
        spec.setPort(80);
        spec.setExchangeName("Binance");
        spec.setExchangeDescription("Binance Exchange.");
        AuthUtils.setApiAndSecretKey((ExchangeSpecification)spec, (String)"binance");
        return spec;
    }

    public void applySpecification(ExchangeSpecification exchangeSpecification) {
        BinanceExchange.concludeHostParams(exchangeSpecification);
        super.applySpecification(exchangeSpecification);
    }

    public boolean isFuturesSandbox() {
        return Boolean.TRUE.equals(this.exchangeSpecification.getExchangeSpecificParametersItem(SPECIFIC_PARAM_USE_FUTURES_SANDBOX));
    }

    public boolean usingSandbox() {
        return BinanceExchange.enabledSandbox(this.exchangeSpecification);
    }

    public void remoteInit() {
        try {
            BinanceMarketDataService marketDataService = (BinanceMarketDataService)this.marketDataService;
            BinanceAccountService accountService = (BinanceAccountService)this.getAccountService();
            Map<String, AssetDetail> assetDetailMap = null;
            if (!this.usingSandbox() && this.isAuthenticated()) {
                assetDetailMap = accountService.getAssetDetails();
            }
            if (this.usingSandbox()) {
                if (this.isFuturesSandbox()) {
                    BinanceAdapters.adaptFutureExchangeMetaData(this.exchangeMetaData, marketDataService.getFutureExchangeInfo());
                } else {
                    this.exchangeMetaData = BinanceAdapters.adaptExchangeMetaData(marketDataService.getExchangeInfo(), assetDetailMap);
                }
            } else {
                this.exchangeMetaData = BinanceAdapters.adaptExchangeMetaData(marketDataService.getExchangeInfo(), assetDetailMap);
                BinanceAdapters.adaptFutureExchangeMetaData(this.exchangeMetaData, marketDataService.getFutureExchangeInfo());
            }
        }
        catch (Exception e) {
            throw new ExchangeException("Failed to initialize: " + e.getMessage(), (Throwable)e);
        }
    }

    protected boolean isAuthenticated() {
        return this.exchangeSpecification != null && this.exchangeSpecification.getApiKey() != null && this.exchangeSpecification.getSecretKey() != null;
    }

    private static void concludeHostParams(ExchangeSpecification exchangeSpecification) {
        if (exchangeSpecification.getExchangeSpecificParameters() != null && BinanceExchange.enabledSandbox(exchangeSpecification)) {
            exchangeSpecification.setSslUri("https://testnet.binance.vision");
            exchangeSpecification.setHost("testnet.binance.vision");
        }
    }

    private static boolean enabledSandbox(ExchangeSpecification exchangeSpecification) {
        return Boolean.TRUE.equals(exchangeSpecification.getExchangeSpecificParametersItem(SPECIFIC_PARAM_USE_SANDBOX)) || Boolean.TRUE.equals(exchangeSpecification.getExchangeSpecificParametersItem(SPECIFIC_PARAM_USE_FUTURES_SANDBOX));
    }
}

