/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.binance.service;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.knowm.xchange.binance.BinanceAdapters;
import org.knowm.xchange.binance.BinanceErrorAdapter;
import org.knowm.xchange.binance.BinanceExchange;
import org.knowm.xchange.binance.dto.BinanceException;
import org.knowm.xchange.binance.dto.account.AssetDetail;
import org.knowm.xchange.binance.dto.account.BinanceAccountInformation;
import org.knowm.xchange.binance.dto.account.BinanceFundingHistoryParams;
import org.knowm.xchange.binance.dto.account.BinanceMasterAccountTransferHistoryParams;
import org.knowm.xchange.binance.dto.account.BinanceSubAccountTransferHistoryParams;
import org.knowm.xchange.binance.dto.account.DepositAddress;
import org.knowm.xchange.binance.dto.account.WithdrawResponse;
import org.knowm.xchange.binance.dto.account.futures.BinanceFutureAccountInformation;
import org.knowm.xchange.binance.service.BinanceAccountServiceRaw;
import org.knowm.xchange.client.ResilienceRegistries;
import org.knowm.xchange.currency.Currency;
import org.knowm.xchange.dto.account.AccountInfo;
import org.knowm.xchange.dto.account.AddressWithTag;
import org.knowm.xchange.dto.account.Fee;
import org.knowm.xchange.dto.account.FundingRecord;
import org.knowm.xchange.dto.account.OpenPosition;
import org.knowm.xchange.dto.account.Wallet;
import org.knowm.xchange.instrument.Instrument;
import org.knowm.xchange.service.account.AccountService;
import org.knowm.xchange.service.trade.params.DefaultWithdrawFundsParams;
import org.knowm.xchange.service.trade.params.HistoryParamsFundingType;
import org.knowm.xchange.service.trade.params.RippleWithdrawFundsParams;
import org.knowm.xchange.service.trade.params.TradeHistoryParamCurrency;
import org.knowm.xchange.service.trade.params.TradeHistoryParamLimit;
import org.knowm.xchange.service.trade.params.TradeHistoryParamPaging;
import org.knowm.xchange.service.trade.params.TradeHistoryParams;
import org.knowm.xchange.service.trade.params.TradeHistoryParamsTimeSpan;
import org.knowm.xchange.service.trade.params.WithdrawFundsParams;

public class BinanceAccountService
extends BinanceAccountServiceRaw
implements AccountService {
    public BinanceAccountService(BinanceExchange exchange, ResilienceRegistries resilienceRegistries) {
        super(exchange, resilienceRegistries);
    }

    private static FundingRecord.Status transferHistoryStatus(String historyStatus) {
        FundingRecord.Status status;
        switch (historyStatus) {
            case "SUCCESS": {
                status = FundingRecord.Status.COMPLETE;
                break;
            }
            default: {
                status = FundingRecord.Status.resolveStatus((String)historyStatus);
                if (status != null) break;
                status = FundingRecord.Status.FAILED;
            }
        }
        return status;
    }

    private static FundingRecord.Status withdrawStatus(int status) {
        switch (status) {
            case 0: 
            case 2: 
            case 4: {
                return FundingRecord.Status.PROCESSING;
            }
            case 1: {
                return FundingRecord.Status.CANCELLED;
            }
            case 3: 
            case 5: {
                return FundingRecord.Status.FAILED;
            }
            case 6: {
                return FundingRecord.Status.COMPLETE;
            }
        }
        throw new RuntimeException("Unknown binance withdraw status: " + status);
    }

    private static FundingRecord.Status depositStatus(int status) {
        switch (status) {
            case 0: 
            case 6: {
                return FundingRecord.Status.PROCESSING;
            }
            case 1: {
                return FundingRecord.Status.COMPLETE;
            }
        }
        throw new RuntimeException("Unknown binance deposit status: " + status);
    }

    public AccountInfo getAccountInfo() throws IOException {
        try {
            ArrayList<Wallet> wallets = new ArrayList<Wallet>();
            ArrayList<OpenPosition> openPositions = new ArrayList<OpenPosition>();
            if (((BinanceExchange)this.exchange).usingSandbox()) {
                if (((BinanceExchange)this.exchange).isFuturesSandbox()) {
                    BinanceFutureAccountInformation futureAccountInformation = this.futuresAccount();
                    wallets.add(BinanceAdapters.adaptBinanceFutureWallet(futureAccountInformation));
                    openPositions.addAll(BinanceAdapters.adaptOpenPositions(futureAccountInformation.getPositions()));
                } else {
                    wallets.add(BinanceAdapters.adaptBinanceSpotWallet(this.account()));
                }
            } else {
                BinanceFutureAccountInformation futureAccountInformation = this.futuresAccount();
                wallets.add(BinanceAdapters.adaptBinanceSpotWallet(this.account()));
                wallets.add(BinanceAdapters.adaptBinanceFutureWallet(futureAccountInformation));
                openPositions.addAll(BinanceAdapters.adaptOpenPositions(futureAccountInformation.getPositions()));
            }
            return new AccountInfo(((BinanceExchange)this.exchange).getExchangeSpecification().getUserName(), null, wallets, openPositions, Date.from(Instant.now()));
        }
        catch (BinanceException e) {
            throw BinanceErrorAdapter.adapt(e);
        }
    }

    public Map<Instrument, Fee> getDynamicTradingFeesByInstrument() throws IOException {
        try {
            BinanceAccountInformation acc = this.account();
            BigDecimal makerFee = acc.makerCommission.divide(new BigDecimal("10000"), 4, RoundingMode.UNNECESSARY);
            BigDecimal takerFee = acc.takerCommission.divide(new BigDecimal("10000"), 4, RoundingMode.UNNECESSARY);
            HashMap<Instrument, Fee> tradingFees = new HashMap<Instrument, Fee>();
            List pairs = ((BinanceExchange)this.exchange).getExchangeInstruments();
            pairs.forEach(pair -> tradingFees.put((Instrument)pair, new Fee(makerFee, takerFee)));
            return tradingFees;
        }
        catch (BinanceException e) {
            throw BinanceErrorAdapter.adapt(e);
        }
    }

    public String withdrawFunds(Currency currency, BigDecimal amount, String address) throws IOException {
        try {
            return super.withdraw(currency.getCurrencyCode(), address, amount).getId();
        }
        catch (BinanceException e) {
            throw BinanceErrorAdapter.adapt(e);
        }
    }

    public String withdrawFunds(Currency currency, BigDecimal amount, AddressWithTag address) throws IOException {
        return this.withdrawFunds((WithdrawFundsParams)new DefaultWithdrawFundsParams(address, currency, amount));
    }

    public String withdrawFunds(WithdrawFundsParams params) throws IOException {
        try {
            WithdrawResponse withdraw;
            if (!(params instanceof DefaultWithdrawFundsParams)) {
                throw new IllegalArgumentException("DefaultWithdrawFundsParams must be provided.");
            }
            if (params instanceof RippleWithdrawFundsParams) {
                RippleWithdrawFundsParams rippleParams = (RippleWithdrawFundsParams)params;
                withdraw = super.withdraw(rippleParams.getCurrency().getCurrencyCode(), rippleParams.getAddress(), rippleParams.getTag(), rippleParams.getAmount());
            } else {
                DefaultWithdrawFundsParams p = (DefaultWithdrawFundsParams)params;
                withdraw = super.withdraw(p.getCurrency().getCurrencyCode(), p.getAddress(), p.getAddressTag(), p.getAmount());
            }
            return withdraw.getId();
        }
        catch (BinanceException e) {
            throw BinanceErrorAdapter.adapt(e);
        }
    }

    public String requestDepositAddress(Currency currency, String ... args) throws IOException {
        try {
            return super.requestDepositAddress((Currency)currency).address;
        }
        catch (BinanceException e) {
            throw BinanceErrorAdapter.adapt(e);
        }
    }

    public AddressWithTag requestDepositAddressData(Currency currency, String ... args) throws IOException {
        DepositAddress depositAddress = super.requestDepositAddress(currency);
        String destinationTag = depositAddress.addressTag == null || depositAddress.addressTag.isEmpty() ? null : depositAddress.addressTag;
        return new AddressWithTag(depositAddress.address, destinationTag);
    }

    public Map<String, AssetDetail> getAssetDetails() throws IOException {
        try {
            return super.requestAssetDetail();
        }
        catch (BinanceException e) {
            throw BinanceErrorAdapter.adapt(e);
        }
    }

    public TradeHistoryParams createFundingHistoryParams() {
        return new BinanceFundingHistoryParams();
    }

    public List<FundingRecord> getFundingHistory(TradeHistoryParams params) throws IOException {
        try {
            HistoryParamsFundingType f;
            TradeHistoryParamCurrency cp;
            String asset = null;
            if (params instanceof TradeHistoryParamCurrency && (cp = (TradeHistoryParamCurrency)params).getCurrency() != null) {
                asset = cp.getCurrency().getCurrencyCode();
            }
            Integer limit = null;
            Integer page = null;
            if (params instanceof TradeHistoryParamLimit) {
                limit = ((TradeHistoryParamLimit)params).getLimit();
            }
            if (params instanceof TradeHistoryParamPaging) {
                page = ((TradeHistoryParamPaging)params).getPageNumber();
            }
            boolean withdrawals = true;
            boolean deposits = true;
            boolean otherInflow = true;
            Long startTime = null;
            Long endTime = null;
            if (params instanceof TradeHistoryParamsTimeSpan) {
                TradeHistoryParamsTimeSpan tp = (TradeHistoryParamsTimeSpan)params;
                if (tp.getStartTime() != null) {
                    startTime = tp.getStartTime().getTime();
                }
                if (tp.getEndTime() != null) {
                    endTime = tp.getEndTime().getTime();
                }
            }
            if (params instanceof HistoryParamsFundingType && (f = (HistoryParamsFundingType)params).getType() != null) {
                withdrawals = f.getType() == FundingRecord.Type.WITHDRAWAL;
                deposits = f.getType() == FundingRecord.Type.DEPOSIT;
                otherInflow = f.getType() == FundingRecord.Type.OTHER_INFLOW;
            }
            String email = null;
            boolean subAccount = false;
            if (params instanceof BinanceMasterAccountTransferHistoryParams) {
                email = ((BinanceMasterAccountTransferHistoryParams)params).getEmail();
            }
            if (params instanceof BinanceSubAccountTransferHistoryParams) {
                subAccount = true;
            }
            ArrayList<FundingRecord> result = new ArrayList<FundingRecord>();
            if (withdrawals) {
                super.withdrawHistory(asset, startTime, endTime).forEach(w -> result.add(new FundingRecord(w.getAddress(), w.getAddressTag(), BinanceAdapters.toDate(w.getApplyTime()), Currency.getInstance((String)w.getCoin()), w.getAmount(), w.getId(), w.getTxId(), FundingRecord.Type.WITHDRAWAL, BinanceAccountService.withdrawStatus(w.getStatus()), null, w.getTransactionFee(), null)));
            }
            if (deposits) {
                super.depositHistory(asset, startTime, endTime).forEach(d -> result.add(new FundingRecord(d.getAddress(), d.getAddressTag(), new Date(d.getInsertTime()), Currency.getInstance((String)d.getCoin()), d.getAmount(), null, d.getTxId(), FundingRecord.Type.DEPOSIT, BinanceAccountService.depositStatus(d.getStatus()), null, null, null)));
            }
            if (otherInflow) {
                super.getAssetDividend(asset, startTime, endTime).forEach(a -> result.add(new FundingRecord(null, null, new Date(a.getDivTime()), Currency.getInstance((String)a.getAsset()), a.getAmount(), null, String.valueOf(a.getTranId()), FundingRecord.Type.OTHER_INFLOW, FundingRecord.Status.COMPLETE, null, null, a.getEnInfo())));
            }
            String finalEmail = email;
            if (email != null) {
                super.getTransferHistory(email, startTime, endTime, page, limit).forEach(a -> result.add(new FundingRecord.Builder().setAddress(finalEmail).setDate(new Date(a.getTime())).setCurrency(Currency.getInstance((String)a.getAsset())).setAmount(a.getQty()).setType(FundingRecord.Type.INTERNAL_WITHDRAWAL).setStatus(BinanceAccountService.transferHistoryStatus(a.getStatus())).build()));
            }
            if (subAccount) {
                Integer type = deposits && withdrawals ? null : Integer.valueOf(deposits ? 1 : 0);
                super.getSubUserHistory(asset, type, startTime, endTime, limit).forEach(a -> result.add(new FundingRecord.Builder().setAddress(a.getEmail()).setDate(new Date(a.getTime())).setCurrency(Currency.getInstance((String)a.getAsset())).setAmount(a.getQty()).setType(a.getType().equals(1) ? FundingRecord.Type.INTERNAL_DEPOSIT : FundingRecord.Type.INTERNAL_WITHDRAWAL).setStatus(FundingRecord.Status.COMPLETE).build()));
            }
            return result;
        }
        catch (BinanceException e) {
            throw BinanceErrorAdapter.adapt(e);
        }
    }
}

