/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.binance.service;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.List;
import java.util.Optional;
import org.knowm.xchange.binance.BinanceAdapters;
import org.knowm.xchange.binance.BinanceExchange;
import org.knowm.xchange.binance.dto.BinanceException;
import org.knowm.xchange.binance.dto.account.futures.BinanceFutureAccountInformation;
import org.knowm.xchange.binance.dto.account.futures.BinancePosition;
import org.knowm.xchange.binance.dto.trade.BinanceCancelledOrder;
import org.knowm.xchange.binance.dto.trade.BinanceDustLog;
import org.knowm.xchange.binance.dto.trade.BinanceListenKey;
import org.knowm.xchange.binance.dto.trade.BinanceNewOrder;
import org.knowm.xchange.binance.dto.trade.BinanceOrder;
import org.knowm.xchange.binance.dto.trade.BinanceTrade;
import org.knowm.xchange.binance.dto.trade.OrderSide;
import org.knowm.xchange.binance.dto.trade.OrderType;
import org.knowm.xchange.binance.dto.trade.TimeInForce;
import org.knowm.xchange.binance.dto.trade.futures.BinanceFutureNewOrder;
import org.knowm.xchange.binance.service.BinanceBaseService;
import org.knowm.xchange.client.ResilienceRegistries;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.derivative.FuturesContract;
import org.knowm.xchange.exceptions.ExchangeException;
import org.knowm.xchange.instrument.Instrument;

public class BinanceTradeServiceRaw
extends BinanceBaseService {
    protected BinanceTradeServiceRaw(BinanceExchange exchange, ResilienceRegistries resilienceRegistries) {
        super(exchange, resilienceRegistries);
    }

    public List<BinanceOrder> openOrdersAllProducts() throws BinanceException, IOException {
        return this.openOrdersAllProducts(null);
    }

    public List<BinanceOrder> openOrdersAllProducts(Instrument pair) throws BinanceException, IOException {
        return (List)this.decorateApiCall(() -> pair instanceof FuturesContract ? this.binanceFutures.futureOpenOrders(Optional.of(pair).map(BinanceAdapters::toSymbol).orElse(null), this.getRecvWindow(), this.getTimestampFactory(), this.apiKey, this.signatureCreator) : this.binance.openOrders(Optional.ofNullable(pair).map(BinanceAdapters::toSymbol).orElse(null), this.getRecvWindow(), this.getTimestampFactory(), this.apiKey, this.signatureCreator)).withRetry(this.retry("openOrders")).withRateLimiter(this.rateLimiter("requestWeight"), this.openOrdersPermits(pair)).call();
    }

    public BinanceNewOrder newOrder(Instrument pair, OrderSide side, OrderType type, TimeInForce timeInForce, BigDecimal quantity, BigDecimal quoteOrderQty, BigDecimal price, String newClientOrderId, BigDecimal stopPrice, Long trailingDelta, BigDecimal icebergQty, BinanceNewOrder.NewOrderResponseType newOrderRespType) throws IOException, BinanceException {
        return (BinanceNewOrder)this.decorateApiCall(() -> this.binance.newOrder(BinanceAdapters.toSymbol(pair), side, type, timeInForce, quantity, quoteOrderQty, price, newClientOrderId, stopPrice, trailingDelta, icebergQty, newOrderRespType, this.getRecvWindow(), this.getTimestampFactory(), this.apiKey, this.signatureCreator)).withRetry(this.retry("newOrder", "nonIdempotentCallsBase")).withRateLimiter(this.rateLimiter("ordersPerSecond")).withRateLimiter(this.rateLimiter("ordersPerDay")).withRateLimiter(this.rateLimiter("requestWeight")).call();
    }

    public BinanceFutureNewOrder newFutureOrder(Instrument pair, OrderSide side, OrderType type, TimeInForce timeInForce, BigDecimal quantity, boolean reduceOnly, BigDecimal price, String newClientOrderId, BigDecimal stopPrice, boolean closePosition, BigDecimal activationPrice, BigDecimal callbackRate, BinanceNewOrder.NewOrderResponseType newOrderRespType) throws IOException, BinanceException {
        return (BinanceFutureNewOrder)this.decorateApiCall(() -> this.binanceFutures.newOrder(BinanceAdapters.toSymbol(pair), side, type, timeInForce, quantity, reduceOnly, price, newClientOrderId, stopPrice, closePosition, activationPrice, callbackRate, newOrderRespType, this.getRecvWindow(), this.getTimestampFactory(), this.apiKey, this.signatureCreator)).withRetry(this.retry("newFutureOrder", "nonIdempotentCallsBase")).withRateLimiter(this.rateLimiter("ordersPerSecond")).withRateLimiter(this.rateLimiter("ordersPerDay")).withRateLimiter(this.rateLimiter("requestWeight")).call();
    }

    public void testNewOrder(Instrument pair, OrderSide side, OrderType type, TimeInForce timeInForce, BigDecimal quantity, BigDecimal quoteOrderQty, BigDecimal price, String newClientOrderId, BigDecimal stopPrice, Long trailingDelta, BigDecimal icebergQty) throws IOException, BinanceException {
        this.decorateApiCall(() -> this.binance.testNewOrder(BinanceAdapters.toSymbol(pair), side, type, timeInForce, quantity, quoteOrderQty, price, newClientOrderId, stopPrice, trailingDelta, icebergQty, this.getRecvWindow(), this.getTimestampFactory(), this.apiKey, this.signatureCreator)).withRetry(this.retry("testNewOrder")).withRateLimiter(this.rateLimiter("requestWeight")).call();
    }

    public BinanceOrder orderStatusAllProducts(Instrument pair, Long orderId, String origClientOrderId) throws IOException, BinanceException {
        return (BinanceOrder)this.decorateApiCall(() -> pair instanceof FuturesContract ? this.binanceFutures.futureOrderStatus(BinanceAdapters.toSymbol(pair), orderId, origClientOrderId, this.getRecvWindow(), this.getTimestampFactory(), this.apiKey, this.signatureCreator) : this.binance.orderStatus(BinanceAdapters.toSymbol(pair), orderId, origClientOrderId, this.getRecvWindow(), this.getTimestampFactory(), this.apiKey, this.signatureCreator)).withRetry(this.retry("orderStatus")).withRateLimiter(this.rateLimiter("requestWeight")).call();
    }

    public BinanceCancelledOrder cancelOrderAllProducts(Instrument pair, Long orderId, String origClientOrderId, String newClientOrderId) throws IOException, BinanceException {
        return (BinanceCancelledOrder)this.decorateApiCall(() -> pair instanceof FuturesContract ? this.binanceFutures.cancelFutureOrder(BinanceAdapters.toSymbol(pair), orderId, origClientOrderId, this.getRecvWindow(), this.getTimestampFactory(), this.apiKey, this.signatureCreator) : this.binance.cancelOrder(BinanceAdapters.toSymbol(pair), orderId, origClientOrderId, newClientOrderId, this.getRecvWindow(), this.getTimestampFactory(), this.apiKey, this.signatureCreator)).withRetry(this.retry("cancelOrder")).withRateLimiter(this.rateLimiter("requestWeight")).call();
    }

    public List<BinanceCancelledOrder> cancelAllOpenOrdersAllProducts(Instrument pair) throws IOException, BinanceException {
        return (List)this.decorateApiCall(() -> pair instanceof FuturesContract ? this.binanceFutures.cancelAllFutureOpenOrders(BinanceAdapters.toSymbol(pair), this.getRecvWindow(), this.getTimestampFactory(), this.apiKey, this.signatureCreator) : this.binance.cancelAllOpenOrders(BinanceAdapters.toSymbol(pair), this.getRecvWindow(), this.getTimestampFactory(), this.apiKey, this.signatureCreator)).withRetry(this.retry("cancelAllOpenOrders")).withRateLimiter(this.rateLimiter("requestWeight")).call();
    }

    public List<BinanceOrder> allOrders(CurrencyPair pair, Long orderId, Integer limit) throws BinanceException, IOException {
        return (List)this.decorateApiCall(() -> this.binance.allOrders(BinanceAdapters.toSymbol((Instrument)pair), orderId, limit, this.getRecvWindow(), this.getTimestampFactory(), this.apiKey, this.signatureCreator)).withRetry(this.retry("allOrders")).withRateLimiter(this.rateLimiter("requestWeight")).call();
    }

    public List<BinanceTrade> myTradesAllProducts(Instrument pair, Long orderId, Long startTime, Long endTime, Long fromId, Integer limit) throws BinanceException, IOException {
        return (List)this.decorateApiCall(() -> pair instanceof FuturesContract ? this.binanceFutures.myFutureTrades(BinanceAdapters.toSymbol(pair), orderId, startTime, endTime, fromId, limit, this.getRecvWindow(), this.getTimestampFactory(), this.apiKey, this.signatureCreator) : this.binance.myTrades(BinanceAdapters.toSymbol(pair), orderId, startTime, endTime, fromId, limit, this.getRecvWindow(), this.getTimestampFactory(), this.apiKey, this.signatureCreator)).withRetry(this.retry("myTrades")).withRateLimiter(this.rateLimiter("requestWeight"), this.myTradesPermits(limit)).call();
    }

    public List<BinancePosition> openPositions() throws BinanceException, IOException {
        return ((BinanceFutureAccountInformation)this.decorateApiCall(() -> this.binanceFutures.futuresAccount(this.getRecvWindow(), this.getTimestampFactory(), this.apiKey, this.signatureCreator)).withRetry(this.retry("futures-account")).withRateLimiter(this.rateLimiter("requestWeight"), 5).call()).getPositions();
    }

    public BinanceDustLog getDustLog(Long startTime, Long endTime) throws IOException {
        if (startTime != null && endTime == null || startTime == null && endTime != null) {
            throw new ExchangeException("You need to specify both, the start and the end date, or none of them");
        }
        return (BinanceDustLog)this.decorateApiCall(() -> this.binance.getDustLog(startTime, endTime, this.getRecvWindow(), this.getTimestampFactory(), this.apiKey, this.signatureCreator)).withRetry(this.retry("myDustLog")).withRateLimiter(this.rateLimiter("requestWeight")).call();
    }

    public BinanceListenKey startUserDataStream() throws IOException {
        return (BinanceListenKey)this.decorateApiCall(() -> this.binance.startUserDataStream(this.apiKey)).withRateLimiter(this.rateLimiter("requestWeight")).call();
    }

    public void keepAliveDataStream(String listenKey) throws IOException {
        this.decorateApiCall(() -> this.binance.keepAliveUserDataStream(this.apiKey, listenKey)).withRateLimiter(this.rateLimiter("requestWeight")).call();
    }

    public void closeDataStream(String listenKey) throws IOException {
        this.decorateApiCall(() -> this.binance.closeUserDataStream(this.apiKey, listenKey)).withRateLimiter(this.rateLimiter("requestWeight")).call();
    }

    protected int openOrdersPermits(Instrument pair) {
        return pair != null ? 1 : 40;
    }

    protected int myTradesPermits(Integer limit) {
        if (limit != null && limit > 500) {
            return 10;
        }
        return 5;
    }
}

