/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.binance.service;

import jakarta.ws.rs.QueryParam;
import java.nio.charset.StandardCharsets;
import javax.crypto.Mac;
import org.knowm.xchange.service.BaseParamsDigest;
import org.knowm.xchange.utils.DigestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import si.mazi.rescu.Params;
import si.mazi.rescu.RestInvocation;

public class BinanceHmacDigest
extends BaseParamsDigest {
    private static final Logger LOG = LoggerFactory.getLogger(BinanceHmacDigest.class);

    private BinanceHmacDigest(String secretKeyBase64) {
        super(secretKeyBase64, "HmacSHA256");
    }

    public static BinanceHmacDigest createInstance(String secretKeyBase64) {
        return secretKeyBase64 == null ? null : new BinanceHmacDigest(secretKeyBase64);
    }

    private static String getQuery(RestInvocation restInvocation) {
        Params p = Params.of();
        ((Params)restInvocation.getParamsMap().get(QueryParam.class)).asHttpHeaders().entrySet().stream().filter(e -> !"signature".equals(e.getKey())).forEach(e -> p.add((String)e.getKey(), e.getValue()));
        return p.asQueryString();
    }

    public String digestParams(RestInvocation restInvocation) {
        String input;
        if (restInvocation.getPath().startsWith("wapi/")) {
            input = BinanceHmacDigest.getQuery(restInvocation);
        } else {
            switch (restInvocation.getHttpMethod()) {
                case "GET": 
                case "DELETE": {
                    input = BinanceHmacDigest.getQuery(restInvocation);
                    break;
                }
                case "POST": {
                    input = restInvocation.getRequestBody();
                    break;
                }
                default: {
                    throw new RuntimeException("Not support http method: " + restInvocation.getHttpMethod());
                }
            }
        }
        Mac mac = this.getMac();
        mac.update(input.getBytes(StandardCharsets.UTF_8));
        String printBase64Binary = DigestUtils.bytesToHex((byte[])mac.doFinal());
        return printBase64Binary;
    }
}

