/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.binance.dto.marketdata;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.math.BigDecimal;
import lombok.Generated;
import org.knowm.xchange.binance.BinanceAdapters;
import org.knowm.xchange.dto.marketdata.Ticker;

public final class BinanceBookTicker {
    public long updateId;
    private final BigDecimal bidPrice;
    private final BigDecimal bidQty;
    private final BigDecimal askPrice;
    private final BigDecimal askQty;
    private final String symbol;
    private Ticker ticker;

    public BinanceBookTicker(@JsonProperty(value="bidPrice") BigDecimal bidPrice, @JsonProperty(value="bidQty") BigDecimal bidQty, @JsonProperty(value="askPrice") BigDecimal askPrice, @JsonProperty(value="askQty") BigDecimal askQty, @JsonProperty(value="symbol") String symbol) {
        this.bidPrice = bidPrice;
        this.bidQty = bidQty;
        this.askPrice = askPrice;
        this.askQty = askQty;
        this.symbol = symbol;
    }

    public void setUpdateId(long updateId) {
        this.updateId = updateId;
    }

    public synchronized Ticker toTicker(boolean isFuture) {
        if (this.ticker == null) {
            this.ticker = new Ticker.Builder().instrument(BinanceAdapters.adaptSymbol(this.symbol, isFuture)).ask(this.askPrice).bid(this.bidPrice).askSize(this.askQty).bidSize(this.bidQty).build();
        }
        return this.ticker;
    }

    @Generated
    public long getUpdateId() {
        return this.updateId;
    }

    @Generated
    public BigDecimal getBidPrice() {
        return this.bidPrice;
    }

    @Generated
    public BigDecimal getBidQty() {
        return this.bidQty;
    }

    @Generated
    public BigDecimal getAskPrice() {
        return this.askPrice;
    }

    @Generated
    public BigDecimal getAskQty() {
        return this.askQty;
    }

    @Generated
    public String getSymbol() {
        return this.symbol;
    }

    @Generated
    public Ticker getTicker() {
        return this.ticker;
    }
}

