/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.binance;

import java.util.Map;
import org.apache.commons.lang3.ObjectUtils;
import org.knowm.xchange.BaseExchange;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.ExchangeSpecification;
import org.knowm.xchange.binance.BinanceAdapters;
import org.knowm.xchange.binance.BinanceResilience;
import org.knowm.xchange.binance.BinanceTimestampFactory;
import org.knowm.xchange.binance.dto.ExchangeType;
import org.knowm.xchange.binance.dto.account.AssetDetail;
import org.knowm.xchange.binance.dto.meta.exchangeinfo.BinanceExchangeInfo;
import org.knowm.xchange.binance.service.BinanceAccountService;
import org.knowm.xchange.binance.service.BinanceMarketDataService;
import org.knowm.xchange.binance.service.BinanceMarketDataServiceRaw;
import org.knowm.xchange.binance.service.BinanceTradeService;
import org.knowm.xchange.client.ResilienceRegistries;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.exceptions.ExchangeException;
import org.knowm.xchange.utils.AuthUtils;
import si.mazi.rescu.SynchronizedValueFactory;

public class BinanceExchange
extends BaseExchange
implements Exchange {
    public static String EXCHANGE_TYPE = "Exchange_Type";
    private static final String SPOT_URL = "https://api.binance.com";
    public static final String FUTURES_URL = "https://fapi.binance.com";
    public static final String INVERSE_FUTURES_URL = "https://dapi.binance.com";
    public static final String PORTFOLIO_MARGIN_URL = "https://papi.binance.com";
    public static final String SANDBOX_SPOT_URL = "https://testnet.binance.vision";
    public static final String SANDBOX_FUTURES_URL = "https://testnet.binancefuture.com";
    public static final String SANDBOX_INVERSE_FUTURES_URL = "https://testnet.binancefuture.com";
    protected ResilienceRegistries RESILIENCE_REGISTRIES;
    protected SynchronizedValueFactory<Long> timestampFactory;

    protected void initServices() {
        this.timestampFactory = new BinanceTimestampFactory(this.getExchangeSpecification().getResilience(), this.getResilienceRegistries());
        this.marketDataService = new BinanceMarketDataService(this, this.getResilienceRegistries());
        this.tradeService = new BinanceTradeService(this, this.getResilienceRegistries());
        this.accountService = new BinanceAccountService(this, this.getResilienceRegistries());
    }

    public SynchronizedValueFactory<Long> getTimestampFactory() {
        return this.timestampFactory;
    }

    public SynchronizedValueFactory<Long> getNonceFactory() {
        throw new UnsupportedOperationException("Binance uses timestamp/recvwindow rather than a nonce");
    }

    public void resetResilienceRegistries() {
        this.RESILIENCE_REGISTRIES = null;
    }

    public ResilienceRegistries getResilienceRegistries() {
        if (this.RESILIENCE_REGISTRIES == null) {
            this.RESILIENCE_REGISTRIES = this.isFuturesEnabled() ? BinanceResilience.createRegistriesFuture() : BinanceResilience.createRegistries();
        }
        return this.RESILIENCE_REGISTRIES;
    }

    public ExchangeSpecification getDefaultExchangeSpecification() {
        ExchangeSpecification spec = new ExchangeSpecification(((Object)((Object)this)).getClass());
        spec.setSslUri(SPOT_URL);
        spec.setHost("www.binance.com");
        spec.setPort(80);
        spec.setExchangeName("Binance");
        spec.setExchangeDescription("Binance Exchange.");
        spec.setExchangeSpecificParametersItem(EXCHANGE_TYPE, (Object)ExchangeType.SPOT);
        spec.setExchangeSpecificParametersItem("Use_Sandbox", (Object)false);
        AuthUtils.setApiAndSecretKey((ExchangeSpecification)spec, (String)"binance");
        return spec;
    }

    public void applySpecification(ExchangeSpecification exchangeSpecification) {
        this.concludeHostParams(exchangeSpecification);
        super.applySpecification(exchangeSpecification);
    }

    public boolean isFuturesEnabled() {
        return ExchangeType.FUTURES.equals(this.exchangeSpecification.getExchangeSpecificParametersItem(EXCHANGE_TYPE));
    }

    public boolean isSpotEnabled() {
        return ExchangeType.SPOT.equals(this.exchangeSpecification.getExchangeSpecificParametersItem(EXCHANGE_TYPE));
    }

    public boolean isPortfolioMarginEnabled() {
        return ExchangeType.PORTFOLIO_MARGIN.equals(this.exchangeSpecification.getExchangeSpecificParametersItem(EXCHANGE_TYPE));
    }

    public boolean usingSandbox() {
        return BinanceExchange.enabledSandbox(this.exchangeSpecification);
    }

    public void remoteInit() {
        try {
            BinanceExchangeInfo exchangeInfo;
            BinanceMarketDataServiceRaw marketDataServiceRaw = (BinanceMarketDataServiceRaw)this.marketDataService;
            BinanceAccountService accountService = (BinanceAccountService)this.getAccountService();
            ExchangeType exchangeType = (ExchangeType)((Object)ObjectUtils.defaultIfNull((Object)this.exchangeSpecification.getExchangeSpecificParametersItem(EXCHANGE_TYPE), (Object)((Object)ExchangeType.SPOT)));
            switch (exchangeType) {
                case FUTURES: {
                    exchangeInfo = marketDataServiceRaw.getFutureExchangeInfo();
                    BinanceAdapters.adaptFutureExchangeMetaData(this.exchangeMetaData, exchangeInfo);
                    break;
                }
                default: {
                    Map<String, AssetDetail> assetDetailMap = null;
                    if (!this.usingSandbox() && this.isAuthenticated()) {
                        assetDetailMap = accountService.getAssetDetails();
                    }
                    exchangeInfo = marketDataServiceRaw.getExchangeInfo();
                    this.exchangeMetaData = BinanceAdapters.adaptExchangeMetaData(exchangeInfo, assetDetailMap);
                }
            }
            exchangeInfo.getSymbols().stream().filter(symbol -> ObjectUtils.allNotNull((Object[])new Object[]{symbol.getBaseAsset(), symbol.getQuoteAsset(), symbol.getSymbol()})).forEach(symbol -> BinanceAdapters.putSymbolMapping(symbol.getSymbol(), new CurrencyPair(symbol.getBaseAsset(), symbol.getQuoteAsset())));
        }
        catch (Exception e) {
            throw new ExchangeException("Failed to initialize: " + e.getMessage(), (Throwable)e);
        }
    }

    protected boolean isAuthenticated() {
        return this.exchangeSpecification != null && this.exchangeSpecification.getApiKey() != null && this.exchangeSpecification.getSecretKey() != null;
    }

    protected void concludeHostParams(ExchangeSpecification exchangeSpecification) {
        if (exchangeSpecification.getExchangeSpecificParametersItem(EXCHANGE_TYPE) != null) {
            switch ((ExchangeType)((Object)exchangeSpecification.getExchangeSpecificParametersItem(EXCHANGE_TYPE))) {
                case SPOT: {
                    if (!BinanceExchange.enabledSandbox(exchangeSpecification)) break;
                    exchangeSpecification.setSslUri(SANDBOX_SPOT_URL);
                    break;
                }
                case FUTURES: {
                    if (!BinanceExchange.enabledSandbox(exchangeSpecification)) {
                        exchangeSpecification.setSslUri(FUTURES_URL);
                        break;
                    }
                    exchangeSpecification.setSslUri("https://testnet.binancefuture.com");
                    break;
                }
                case INVERSE: {
                    if (!BinanceExchange.enabledSandbox(exchangeSpecification)) {
                        exchangeSpecification.setSslUri(INVERSE_FUTURES_URL);
                        break;
                    }
                    exchangeSpecification.setSslUri("https://testnet.binancefuture.com");
                    break;
                }
                case PORTFOLIO_MARGIN: {
                    exchangeSpecification.setSslUri(PORTFOLIO_MARGIN_URL);
                }
            }
        }
    }

    private static boolean enabledSandbox(ExchangeSpecification exchangeSpecification) {
        return Boolean.TRUE.equals(exchangeSpecification.getExchangeSpecificParametersItem("Use_Sandbox"));
    }
}

