/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.binance.dto.marketdata;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.math.BigDecimal;
import java.util.Date;
import lombok.Generated;
import org.knowm.xchange.binance.BinanceAdapters;
import org.knowm.xchange.instrument.Instrument;

public class BinanceFundingRate {
    private final Instrument instrument;
    private final BigDecimal markPrice;
    private final BigDecimal indexPrice;
    private final BigDecimal estimatedSettlePrice;
    private final BigDecimal lastFundingRate;
    private final Date nextFundingTime;
    private final BigDecimal interestRate;
    private final Date time;

    public BinanceFundingRate(@JsonProperty(value="symbol") String symbol, @JsonProperty(value="markPrice") BigDecimal markPrice, @JsonProperty(value="indexPrice") BigDecimal indexPrice, @JsonProperty(value="estimatedSettlePrice") BigDecimal estimatedSettlePrice, @JsonProperty(value="lastFundingRate") BigDecimal lastFundingRate, @JsonProperty(value="nextFundingTime") Date nextFundingTime, @JsonProperty(value="interestRate") BigDecimal interestRate, @JsonProperty(value="time") Date time) {
        this.instrument = BinanceAdapters.adaptSymbol(symbol, true);
        this.markPrice = markPrice;
        this.indexPrice = indexPrice;
        this.estimatedSettlePrice = estimatedSettlePrice;
        this.lastFundingRate = lastFundingRate;
        this.nextFundingTime = nextFundingTime;
        this.interestRate = interestRate;
        this.time = time;
    }

    @Generated
    public Instrument getInstrument() {
        return this.instrument;
    }

    @Generated
    public BigDecimal getMarkPrice() {
        return this.markPrice;
    }

    @Generated
    public BigDecimal getIndexPrice() {
        return this.indexPrice;
    }

    @Generated
    public BigDecimal getEstimatedSettlePrice() {
        return this.estimatedSettlePrice;
    }

    @Generated
    public BigDecimal getLastFundingRate() {
        return this.lastFundingRate;
    }

    @Generated
    public Date getNextFundingTime() {
        return this.nextFundingTime;
    }

    @Generated
    public BigDecimal getInterestRate() {
        return this.interestRate;
    }

    @Generated
    public Date getTime() {
        return this.time;
    }

    @Generated
    public String toString() {
        return "BinanceFundingRate(instrument=" + String.valueOf(this.getInstrument()) + ", markPrice=" + String.valueOf(this.getMarkPrice()) + ", indexPrice=" + String.valueOf(this.getIndexPrice()) + ", estimatedSettlePrice=" + String.valueOf(this.getEstimatedSettlePrice()) + ", lastFundingRate=" + String.valueOf(this.getLastFundingRate()) + ", nextFundingTime=" + String.valueOf(this.getNextFundingTime()) + ", interestRate=" + String.valueOf(this.getInterestRate()) + ", time=" + String.valueOf(this.getTime()) + ")";
    }
}

