/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.binance.dto.marketdata;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.math.BigDecimal;
import lombok.Generated;
import org.knowm.xchange.binance.BinanceAdapters;
import org.knowm.xchange.instrument.Instrument;

public class BinanceFundingRateInfo {
    private final Instrument instrument;
    private final BigDecimal adjustedFundingRateCap;
    private final BigDecimal adjustedFundingRateFloor;
    private final int fundingIntervalHours;

    public BinanceFundingRateInfo(@JsonProperty(value="symbol") String symbol, @JsonProperty(value="adjustedFundingRateCap") BigDecimal adjustedFundingRateCap, @JsonProperty(value="adjustedFundingRateFloor") BigDecimal adjustedFundingRateFloor, @JsonProperty(value="fundingIntervalHours") int fundingIntervalHours) {
        this.instrument = BinanceAdapters.adaptSymbol(symbol, true);
        this.adjustedFundingRateCap = adjustedFundingRateCap;
        this.adjustedFundingRateFloor = adjustedFundingRateFloor;
        this.fundingIntervalHours = fundingIntervalHours;
    }

    @Generated
    public Instrument getInstrument() {
        return this.instrument;
    }

    @Generated
    public BigDecimal getAdjustedFundingRateCap() {
        return this.adjustedFundingRateCap;
    }

    @Generated
    public BigDecimal getAdjustedFundingRateFloor() {
        return this.adjustedFundingRateFloor;
    }

    @Generated
    public int getFundingIntervalHours() {
        return this.fundingIntervalHours;
    }

    @Generated
    public String toString() {
        return "BinanceFundingRateInfo(instrument=" + String.valueOf(this.getInstrument()) + ", adjustedFundingRateCap=" + String.valueOf(this.getAdjustedFundingRateCap()) + ", adjustedFundingRateFloor=" + String.valueOf(this.getAdjustedFundingRateFloor()) + ", fundingIntervalHours=" + this.getFundingIntervalHours() + ")";
    }
}

