/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.kucoin;

import java.io.IOException;
import java.util.List;
import org.knowm.xchange.kucoin.KucoinBaseService;
import org.knowm.xchange.kucoin.KucoinExceptionClassifier;
import org.knowm.xchange.kucoin.KucoinExchange;
import org.knowm.xchange.kucoin.dto.request.ApplyWithdrawApiRequest;
import org.knowm.xchange.kucoin.dto.request.CreateAccountRequest;
import org.knowm.xchange.kucoin.dto.request.InnerTransferRequest;
import org.knowm.xchange.kucoin.dto.response.AccountBalancesResponse;
import org.knowm.xchange.kucoin.dto.response.AccountLedgersResponse;
import org.knowm.xchange.kucoin.dto.response.ApplyWithdrawResponse;
import org.knowm.xchange.kucoin.dto.response.DepositResponse;
import org.knowm.xchange.kucoin.dto.response.InternalTransferResponse;
import org.knowm.xchange.kucoin.dto.response.Pagination;
import org.knowm.xchange.kucoin.dto.response.WithdrawalResponse;
import si.mazi.rescu.ParamsDigest;
import si.mazi.rescu.SynchronizedValueFactory;

public class KucoinAccountServiceRaw
extends KucoinBaseService {
    protected KucoinAccountServiceRaw(KucoinExchange exchange) {
        super(exchange);
    }

    public List<AccountBalancesResponse> getKucoinAccounts() throws IOException {
        this.checkAuthenticated();
        return (List)KucoinExceptionClassifier.classifyingExceptions(() -> this.accountApi.getAccountList(this.apiKey, (ParamsDigest)this.digest, (SynchronizedValueFactory<Long>)this.nonceFactory, this.passphrase, null, null));
    }

    public Void createKucoinAccount(String currency, String type) throws IOException {
        this.checkAuthenticated();
        return (Void)KucoinExceptionClassifier.classifyingExceptions(() -> this.accountApi.createAccount(this.apiKey, (ParamsDigest)this.digest, (SynchronizedValueFactory<Long>)this.nonceFactory, this.passphrase, CreateAccountRequest.builder().currency(currency).type(type).build()));
    }

    public ApplyWithdrawResponse applyWithdraw(ApplyWithdrawApiRequest req) throws IOException {
        this.checkAuthenticated();
        return (ApplyWithdrawResponse)KucoinExceptionClassifier.classifyingExceptions(() -> this.withdrawalAPI.applyWithdraw(this.apiKey, (ParamsDigest)this.digest, (SynchronizedValueFactory<Long>)this.nonceFactory, this.passphrase, req));
    }

    public InternalTransferResponse innerTransfer(InnerTransferRequest req) throws IOException {
        this.checkAuthenticated();
        return (InternalTransferResponse)KucoinExceptionClassifier.classifyingExceptions(() -> this.accountApi.innerTransfer(this.apiKey, (ParamsDigest)this.digest, (SynchronizedValueFactory<Long>)this.nonceFactory, this.passphrase, req));
    }

    public Pagination<AccountLedgersResponse> getAccountLedgers(String accountId, Long startAt, Long endAt, Integer pageSize, Integer currentPage) throws IOException {
        this.checkAuthenticated();
        return (Pagination)KucoinExceptionClassifier.classifyingExceptions(() -> this.accountApi.getAccountLedgers(this.apiKey, (ParamsDigest)this.digest, (SynchronizedValueFactory<Long>)this.nonceFactory, this.passphrase, accountId, startAt, endAt, pageSize, currentPage));
    }

    public Pagination<WithdrawalResponse> getWithdrawalsList(String currency, String status, Long startAt, Long endAt, Integer pageSize, Integer currentPage) throws IOException {
        this.checkAuthenticated();
        return (Pagination)KucoinExceptionClassifier.classifyingExceptions(() -> this.withdrawalAPI.getWithdrawalsList(this.apiKey, (ParamsDigest)this.digest, (SynchronizedValueFactory<Long>)this.nonceFactory, this.passphrase, currency, status, startAt, endAt, pageSize, currentPage));
    }

    public Pagination<DepositResponse> getDepositList(String currency, String status, Long startAt, Long endAt, Integer pageSize, Integer currentPage) throws IOException {
        this.checkAuthenticated();
        return (Pagination)KucoinExceptionClassifier.classifyingExceptions(() -> this.depositAPI.getDepositList(this.apiKey, (ParamsDigest)this.digest, (SynchronizedValueFactory<Long>)this.nonceFactory, this.passphrase, currency, status, startAt, endAt, pageSize, currentPage));
    }
}

