/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.kucoin;

import com.google.common.base.MoreObjects;
import com.google.common.collect.Ordering;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.knowm.xchange.currency.Currency;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.Order;
import org.knowm.xchange.dto.account.Balance;
import org.knowm.xchange.dto.account.FundingRecord;
import org.knowm.xchange.dto.marketdata.OrderBook;
import org.knowm.xchange.dto.marketdata.Ticker;
import org.knowm.xchange.dto.marketdata.Trade;
import org.knowm.xchange.dto.marketdata.Trades;
import org.knowm.xchange.dto.meta.CurrencyPairMetaData;
import org.knowm.xchange.dto.meta.ExchangeMetaData;
import org.knowm.xchange.dto.trade.LimitOrder;
import org.knowm.xchange.dto.trade.MarketOrder;
import org.knowm.xchange.dto.trade.StopOrder;
import org.knowm.xchange.dto.trade.UserTrade;
import org.knowm.xchange.exceptions.ExchangeException;
import org.knowm.xchange.instrument.Instrument;
import org.knowm.xchange.kucoin.KucoinTradeService;
import org.knowm.xchange.kucoin.TimeInForce;
import org.knowm.xchange.kucoin.dto.KucoinOrderFlags;
import org.knowm.xchange.kucoin.dto.request.OrderCreateApiRequest;
import org.knowm.xchange.kucoin.dto.response.AccountBalancesResponse;
import org.knowm.xchange.kucoin.dto.response.AllTickersResponse;
import org.knowm.xchange.kucoin.dto.response.DepositResponse;
import org.knowm.xchange.kucoin.dto.response.HistOrdersResponse;
import org.knowm.xchange.kucoin.dto.response.OrderBookResponse;
import org.knowm.xchange.kucoin.dto.response.OrderResponse;
import org.knowm.xchange.kucoin.dto.response.SymbolResponse;
import org.knowm.xchange.kucoin.dto.response.SymbolTickResponse;
import org.knowm.xchange.kucoin.dto.response.TradeHistoryResponse;
import org.knowm.xchange.kucoin.dto.response.TradeResponse;
import org.knowm.xchange.kucoin.dto.response.WithdrawalResponse;

public class KucoinAdapters {
    public static String adaptCurrencyPair(CurrencyPair pair) {
        return pair == null ? null : pair.base.getCurrencyCode() + "-" + pair.counter.getCurrencyCode();
    }

    public static CurrencyPair adaptCurrencyPair(String symbol) {
        String[] split = symbol.split("-");
        if (split.length != 2) {
            throw new ExchangeException("Invalid kucoin symbol: " + symbol);
        }
        return new CurrencyPair(split[0], split[1]);
    }

    public static Ticker.Builder adaptTickerFull(CurrencyPair pair, SymbolTickResponse stats) {
        return new Ticker.Builder().currencyPair(pair).bid(stats.getBuy()).ask(stats.getSell()).last(stats.getLast()).high(stats.getHigh()).low(stats.getLow()).volume(stats.getVol()).quoteVolume(stats.getVolValue()).open(stats.getOpen()).timestamp(new Date(stats.getTime()));
    }

    public static List<Ticker> adaptAllTickers(AllTickersResponse allTickersResponse) {
        return Arrays.stream(allTickersResponse.getTicker()).map(ticker -> new Ticker.Builder().currencyPair(KucoinAdapters.adaptCurrencyPair(ticker.getSymbol())).bid(ticker.getBuy()).ask(ticker.getSell()).last(ticker.getLast()).high(ticker.getHigh()).low(ticker.getLow()).volume(ticker.getVol()).quoteVolume(ticker.getVolValue()).percentageChange(ticker.getChangeRate().multiply(new BigDecimal("100"), new MathContext(8))).build()).collect(Collectors.toList());
    }

    public static ExchangeMetaData adaptMetadata(ExchangeMetaData exchangeMetaData, List<SymbolResponse> kucoinSymbols) {
        Map currencyPairs = exchangeMetaData.getCurrencyPairs();
        Map currencies = exchangeMetaData.getCurrencies();
        for (SymbolResponse symbol : kucoinSymbols) {
            CurrencyPair pair = KucoinAdapters.adaptCurrencyPair(symbol.getSymbol());
            CurrencyPairMetaData staticMetaData = (CurrencyPairMetaData)exchangeMetaData.getCurrencyPairs().get(pair);
            BigDecimal minSize = symbol.getBaseMinSize();
            BigDecimal maxSize = symbol.getBaseMaxSize();
            int priceScale = symbol.getQuoteIncrement().stripTrailingZeros().scale();
            CurrencyPairMetaData cpmd = new CurrencyPairMetaData(null, minSize, maxSize, Integer.valueOf(priceScale), staticMetaData != null ? staticMetaData.getFeeTiers() : null);
            currencyPairs.put(pair, cpmd);
            if (!currencies.containsKey(pair.base)) {
                currencies.put(pair.base, null);
            }
            if (currencies.containsKey(pair.counter)) continue;
            currencies.put(pair.counter, null);
        }
        return new ExchangeMetaData(currencyPairs, currencies, exchangeMetaData.getPublicRateLimits(), exchangeMetaData.getPrivateRateLimits(), Boolean.valueOf(true));
    }

    public static OrderBook adaptOrderBook(CurrencyPair currencyPair, OrderBookResponse kc) {
        Date timestamp = new Date(kc.getTime());
        List asks = kc.getAsks().stream().map(PriceAndSize::new).sorted((Comparator<PriceAndSize>)Ordering.natural().onResultOf(s -> s.price)).map(s -> KucoinAdapters.adaptLimitOrder(currencyPair, Order.OrderType.ASK, s, timestamp)).collect(Collectors.toCollection(LinkedList::new));
        List bids = kc.getBids().stream().map(PriceAndSize::new).sorted(Ordering.natural().onResultOf(s -> s.price).reversed()).map(s -> KucoinAdapters.adaptLimitOrder(currencyPair, Order.OrderType.BID, s, timestamp)).collect(Collectors.toCollection(LinkedList::new));
        return new OrderBook(timestamp, asks, bids);
    }

    private static LimitOrder adaptLimitOrder(CurrencyPair currencyPair, Order.OrderType orderType, PriceAndSize priceAndSize, Date timestamp) {
        return new LimitOrder.Builder(orderType, (Instrument)currencyPair).limitPrice(priceAndSize.price).originalAmount(priceAndSize.size).orderStatus(Order.OrderStatus.NEW).build();
    }

    public static Trades adaptTrades(CurrencyPair currencyPair, List<TradeHistoryResponse> kucoinTrades) {
        return new Trades(kucoinTrades.stream().map(o -> KucoinAdapters.adaptTrade(currencyPair, o)).collect(Collectors.toList()), Trades.TradeSortType.SortByTimestamp);
    }

    public static Balance adaptBalance(AccountBalancesResponse a) {
        return new Balance(Currency.getInstance((String)a.getCurrency()), a.getBalance(), a.getAvailable());
    }

    private static Trade adaptTrade(CurrencyPair currencyPair, TradeHistoryResponse trade) {
        return new Trade.Builder().currencyPair(currencyPair).originalAmount(trade.getSize()).price(trade.getPrice()).timestamp(new Date(Long.parseLong(trade.getSequence()))).type(KucoinAdapters.adaptSide(trade.getSide())).build();
    }

    private static Order.OrderType adaptSide(String side) {
        return "sell".equals(side) ? Order.OrderType.ASK : Order.OrderType.BID;
    }

    private static String adaptSide(Order.OrderType type) {
        return type.equals((Object)Order.OrderType.ASK) ? "sell" : "buy";
    }

    public static Order adaptOrder(OrderResponse order) {
        LimitOrder.Builder builder;
        Order.OrderType orderType = KucoinAdapters.adaptSide(order.getSide());
        CurrencyPair currencyPair = KucoinAdapters.adaptCurrencyPair(order.getSymbol());
        Order.OrderStatus status = order.isCancelExist() ? Order.OrderStatus.CANCELED : (order.isActive() ? (order.getDealSize().signum() == 0 ? Order.OrderStatus.NEW : Order.OrderStatus.PARTIALLY_FILLED) : Order.OrderStatus.UNKNOWN);
        if (StringUtils.isNotEmpty((CharSequence)order.getStop())) {
            BigDecimal limitPrice = order.getPrice();
            if (limitPrice != null && limitPrice.compareTo(BigDecimal.ZERO) == 0) {
                limitPrice = null;
            }
            builder = new StopOrder.Builder(orderType, (Instrument)currencyPair).limitPrice(limitPrice).stopPrice(order.getStopPrice());
        } else {
            builder = new LimitOrder.Builder(orderType, (Instrument)currencyPair).limitPrice(order.getPrice());
        }
        builder = builder.averagePrice(order.getDealSize().compareTo(BigDecimal.ZERO) == 0 ? (BigDecimal)MoreObjects.firstNonNull((Object)order.getPrice(), (Object)order.getStopPrice()) : order.getDealFunds().divide(order.getDealSize(), RoundingMode.HALF_UP)).cumulativeAmount(order.getDealSize()).fee(order.getFee()).id(order.getId()).orderStatus(status).originalAmount(order.getSize()).remainingAmount(order.getSize().subtract(order.getDealSize())).timestamp(order.getCreatedAt());
        if (StringUtils.isNotEmpty((CharSequence)order.getTimeInForce())) {
            builder.flag((Order.IOrderFlags)TimeInForce.getTimeInForce(order.getTimeInForce()));
        }
        return StopOrder.Builder.class.isInstance(builder) ? ((StopOrder.Builder)builder).build() : builder.build();
    }

    public static UserTrade adaptUserTrade(TradeResponse trade) {
        return new UserTrade.Builder().currencyPair(KucoinAdapters.adaptCurrencyPair(trade.getSymbol())).feeAmount(trade.getFee()).feeCurrency(Currency.getInstance((String)trade.getFeeCurrency())).id(trade.getTradeId()).orderId(trade.getOrderId()).originalAmount(trade.getSize()).price(trade.getPrice()).timestamp(trade.getTradeCreatedAt()).type(KucoinAdapters.adaptSide(trade.getSide())).build();
    }

    public static UserTrade adaptHistOrder(HistOrdersResponse histOrder) {
        CurrencyPair currencyPair = KucoinAdapters.adaptCurrencyPair(histOrder.getSymbol());
        return new UserTrade.Builder().currencyPair(currencyPair).feeAmount(histOrder.getFee()).feeCurrency(currencyPair.base).id(histOrder.getId()).originalAmount(histOrder.getAmount()).price(histOrder.getPrice()).timestamp(histOrder.getTradeCreatedAt()).type(KucoinAdapters.adaptSide(histOrder.getSide())).build();
    }

    public static OrderCreateApiRequest adaptLimitOrder(LimitOrder limitOrder) {
        return ((OrderCreateApiRequest.OrderCreateApiRequestBuilder)KucoinAdapters.adaptOrder((Order)limitOrder)).type("limit").price(limitOrder.getLimitPrice()).postOnly(limitOrder.hasFlag((Order.IOrderFlags)KucoinOrderFlags.POST_ONLY)).hidden(limitOrder.hasFlag((Order.IOrderFlags)KucoinOrderFlags.HIDDEN)).iceberg(limitOrder.hasFlag((Order.IOrderFlags)KucoinOrderFlags.ICEBERG)).build();
    }

    public static OrderCreateApiRequest adaptStopOrder(StopOrder stopOrder) {
        return ((OrderCreateApiRequest.OrderCreateApiRequestBuilder)KucoinAdapters.adaptOrder((Order)stopOrder)).type(stopOrder.getLimitPrice() == null ? "market" : "limit").price(stopOrder.getLimitPrice()).stop(stopOrder.getType().equals((Object)Order.OrderType.ASK) ? "loss" : "entry").stopPrice(stopOrder.getStopPrice()).build();
    }

    public static OrderCreateApiRequest adaptMarketOrder(MarketOrder marketOrder) {
        return ((OrderCreateApiRequest.OrderCreateApiRequestBuilder)KucoinAdapters.adaptOrder((Order)marketOrder)).type("market").build();
    }

    private static Object adaptOrder(Order order) {
        OrderCreateApiRequest.OrderCreateApiRequestBuilder request = OrderCreateApiRequest.builder();
        boolean hasClientId = false;
        for (Order.IOrderFlags flag : order.getOrderFlags()) {
            if (flag instanceof KucoinTradeService.KucoinOrderFlags) {
                request.clientOid(((KucoinTradeService.KucoinOrderFlags)flag).getClientId());
                hasClientId = true;
                continue;
            }
            if (!(flag instanceof TimeInForce)) continue;
            request.timeInForce(((TimeInForce)flag).name());
        }
        if (!hasClientId) {
            request.clientOid(UUID.randomUUID().toString());
        }
        return request.symbol(KucoinAdapters.adaptCurrencyPair(order.getCurrencyPair())).size(order.getOriginalAmount()).side(KucoinAdapters.adaptSide(order.getType()));
    }

    public static FundingRecord adaptFundingRecord(WithdrawalResponse wr) {
        FundingRecord.Builder b = new FundingRecord.Builder();
        return b.setAddress(wr.getAddress()).setAmount(wr.getAmount()).setCurrency(Currency.getInstance((String)wr.getCurrency())).setFee(wr.getFee()).setType(FundingRecord.Type.WITHDRAWAL).setStatus(KucoinAdapters.convertStatus(wr.getStatus())).setInternalId(wr.getId()).setBlockchainTransactionHash(wr.getWalletTxId()).setDescription(wr.getMemo()).setDate(wr.getCreatedAt()).build();
    }

    private static FundingRecord.Status convertStatus(String status) {
        if (status == null) {
            return null;
        }
        switch (status) {
            case "WALLET_PROCESSING": 
            case "PROCESSING": {
                return FundingRecord.Status.PROCESSING;
            }
            case "SUCCESS": {
                return FundingRecord.Status.COMPLETE;
            }
            case "FAILURE": {
                return FundingRecord.Status.FAILED;
            }
        }
        throw new ExchangeException("Not supported status: " + status);
    }

    public static FundingRecord adaptFundingRecord(DepositResponse dr) {
        FundingRecord.Builder b = new FundingRecord.Builder();
        return b.setAddress(dr.getAddress()).setAmount(dr.getAmount()).setCurrency(Currency.getInstance((String)dr.getCurrency())).setFee(dr.getFee()).setType(FundingRecord.Type.DEPOSIT).setStatus(KucoinAdapters.convertStatus(dr.getStatus())).setBlockchainTransactionHash(dr.getWalletTxId()).setDescription(dr.getMemo()).setDate(dr.getCreatedAt()).build();
    }

    private static final class PriceAndSize {
        final BigDecimal price;
        final BigDecimal size;

        PriceAndSize(List<String> data) {
            this.price = new BigDecimal(data.get(0));
            this.size = new BigDecimal(data.get(1));
        }
    }
}

