/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.kucoin;

import java.io.IOException;
import org.knowm.xchange.BaseExchange;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.ExchangeSpecification;
import org.knowm.xchange.exceptions.ExchangeException;
import org.knowm.xchange.kucoin.KucoinAccountService;
import org.knowm.xchange.kucoin.KucoinAdapters;
import org.knowm.xchange.kucoin.KucoinExceptionClassifier;
import org.knowm.xchange.kucoin.KucoinMarketDataService;
import org.knowm.xchange.kucoin.KucoinTradeService;
import org.knowm.xchange.kucoin.dto.response.WebsocketResponse;
import si.mazi.rescu.ParamsDigest;
import si.mazi.rescu.SynchronizedValueFactory;

public class KucoinExchange
extends BaseExchange
implements Exchange {
    public static final String PARAM_SANDBOX = "Use_Sandbox";
    static final String SANDBOX_HOST = "openapi-sandbox.kucoin.com";
    static final String SANDBOX_URI = "https://openapi-sandbox.kucoin.com";
    static final String LIVE_HOST = "openapi-v2.kucoin.com";
    static final String LIVE_URI = "https://openapi-v2.kucoin.com";

    private void concludeHostParams(ExchangeSpecification exchangeSpecification) {
        if (exchangeSpecification.getExchangeSpecificParameters() != null) {
            if (Boolean.TRUE.equals(exchangeSpecification.getExchangeSpecificParametersItem(PARAM_SANDBOX))) {
                this.logger.debug("Connecting to sandbox");
                exchangeSpecification.setSslUri(SANDBOX_URI);
                exchangeSpecification.setHost(SANDBOX_HOST);
            } else {
                this.logger.debug("Connecting to live");
            }
        }
    }

    public void applySpecification(ExchangeSpecification exchangeSpecification) {
        super.applySpecification(exchangeSpecification);
        this.concludeHostParams(exchangeSpecification);
    }

    protected void initServices() {
        this.concludeHostParams(this.exchangeSpecification);
        this.marketDataService = new KucoinMarketDataService(this);
        this.accountService = new KucoinAccountService(this);
        this.tradeService = new KucoinTradeService(this);
    }

    public ExchangeSpecification getDefaultExchangeSpecification() {
        ExchangeSpecification exchangeSpecification = new ExchangeSpecification(((Object)((Object)this)).getClass());
        exchangeSpecification.setSslUri(LIVE_URI);
        exchangeSpecification.setHost(LIVE_HOST);
        exchangeSpecification.setPort(80);
        exchangeSpecification.setExchangeName("Kucoin");
        exchangeSpecification.setExchangeDescription("Kucoin is a bitcoin and altcoin exchange.");
        return exchangeSpecification;
    }

    public void remoteInit() throws IOException, ExchangeException {
        this.exchangeMetaData = KucoinAdapters.adaptMetadata(this.exchangeMetaData, this.getMarketDataService().getKucoinSymbols());
    }

    public KucoinMarketDataService getMarketDataService() {
        return (KucoinMarketDataService)super.getMarketDataService();
    }

    public KucoinTradeService getTradeService() {
        return (KucoinTradeService)super.getTradeService();
    }

    public KucoinAccountService getAccountService() {
        return (KucoinAccountService)super.getAccountService();
    }

    public WebsocketResponse getPublicWebsocketConnectionDetails() throws IOException {
        return (WebsocketResponse)KucoinExceptionClassifier.classifyingExceptions(this.getAccountService().websocketAPI::getPublicWebsocketDetails);
    }

    public WebsocketResponse getPrivateWebsocketConnectionDetails() throws IOException {
        this.getAccountService().checkAuthenticated();
        return (WebsocketResponse)KucoinExceptionClassifier.classifyingExceptions(() -> this.getAccountService().websocketAPI.getPrivateWebsocketDetails(this.getAccountService().apiKey, (ParamsDigest)this.getAccountService().digest, (SynchronizedValueFactory<Long>)this.getAccountService().nonceFactory, this.getAccountService().passphrase));
    }
}

