/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import org.kohsuke.github.GHEvent;
import org.kohsuke.github.GHQueryBuilder;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.GHUser;
import org.kohsuke.github.GHWorkflowRun;
import org.kohsuke.github.GHWorkflowRunsIterable;
import org.kohsuke.github.GitHubRequest;
import org.kohsuke.github.PagedIterable;

public class GHWorkflowRunQueryBuilder
extends GHQueryBuilder<GHWorkflowRun> {
    private final GHRepository repo;

    GHWorkflowRunQueryBuilder(GHRepository repo) {
        super(repo.root());
        this.repo = repo;
    }

    public GHWorkflowRunQueryBuilder actor(String actor) {
        this.req.with("actor", actor);
        return this;
    }

    public GHWorkflowRunQueryBuilder actor(GHUser actor) {
        this.req.with("actor", actor.getLogin());
        return this;
    }

    public GHWorkflowRunQueryBuilder branch(String branch) {
        this.req.with("branch", branch);
        return this;
    }

    public GHWorkflowRunQueryBuilder event(GHEvent event) {
        this.req.with("event", event.symbol());
        return this;
    }

    public GHWorkflowRunQueryBuilder event(String event) {
        this.req.with("event", event);
        return this;
    }

    public GHWorkflowRunQueryBuilder status(GHWorkflowRun.Status status) {
        this.req.with("status", status.toString());
        return this;
    }

    public GHWorkflowRunQueryBuilder conclusion(GHWorkflowRun.Conclusion conclusion) {
        this.req.with("status", conclusion.toString());
        return this;
    }

    @Override
    public PagedIterable<GHWorkflowRun> list() {
        return new GHWorkflowRunsIterable(this.repo, (GitHubRequest.Builder<?>)this.req.withUrlPath(this.repo.getApiTailUrl("actions/runs"), new String[0]));
    }
}

