/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import java.io.IOException;
import javax.annotation.Nonnull;
import org.kohsuke.github.GitHubConnectorResponseErrorHandler;
import org.kohsuke.github.connector.GitHubConnectorResponse;

public abstract class GitHubAbuseLimitHandler
extends GitHubConnectorResponseErrorHandler {
    @Override
    boolean isError(@Nonnull GitHubConnectorResponse connectorResponse) {
        return this.isForbidden(connectorResponse) && this.hasRetryOrLimitHeader(connectorResponse);
    }

    private boolean isForbidden(GitHubConnectorResponse connectorResponse) {
        return connectorResponse.statusCode() == 403;
    }

    private boolean hasRetryOrLimitHeader(GitHubConnectorResponse connectorResponse) {
        return this.hasHeader(connectorResponse, "Retry-After") || this.hasHeader(connectorResponse, "gh-limited-by");
    }

    private boolean hasHeader(GitHubConnectorResponse connectorResponse, String headerName) {
        return connectorResponse.header(headerName) != null;
    }

    @Override
    public abstract void onError(@Nonnull GitHubConnectorResponse var1) throws IOException;
}

