/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import org.kohsuke.github.GHObject;
import org.kohsuke.github.GitHubClient;

public class GHAuthorization
extends GHObject {
    public static final String ADMIN_KEY = "admin:public_key";
    public static final String ADMIN_ORG = "admin:org";
    public static final String AMIN_HOOK = "admin:repo_hook";
    public static final String DELETE_REPO = "delete_repo";
    public static final String GIST = "gist";
    public static final String NOTIFICATIONS = "notifications";
    public static final String PUBLIC_REPO = "public_repo";
    public static final String READ_HOOK = "read:repo_hook";
    public static final String READ_KEY = "read:public_key";
    public static final String READ_ORG = "read:org";
    public static final String REPO = "repo";
    public static final String REPO_STATUS = "repo:status";
    public static final String USER = "user";
    public static final String USER_EMAIL = "user:email";
    public static final String USER_FOLLOW = "user:follow";
    public static final String WRITE_HOOK = "write:repo_hook";
    public static final String WRITE_KEY = "write:public_key";
    public static final String WRITE_ORG = "write:org";
    private App app;
    private String fingerprint;
    private String hashedToken;
    private String note;
    private String noteUrl;
    private List<String> scopes;
    private String token;
    private String tokenLastEight;

    public String getAppName() {
        return this.app.name;
    }

    public URL getAppUrl() {
        return GitHubClient.parseURL(this.app.url);
    }

    public String getFingerprint() {
        return this.fingerprint;
    }

    public String getHashedToken() {
        return this.hashedToken;
    }

    public String getNote() {
        return this.note;
    }

    public URL getNoteUrl() {
        return GitHubClient.parseURL(this.noteUrl);
    }

    public List<String> getScopes() {
        return Collections.unmodifiableList(this.scopes);
    }

    public String getToken() {
        return this.token;
    }

    public String getTokenLastEight() {
        return this.tokenLastEight;
    }

    @SuppressFBWarnings(value={"UWF_UNWRITTEN_PUBLIC_OR_PROTECTED_FIELD", "UWF_UNWRITTEN_FIELD"}, justification="JSON API")
    private static class App {
        private String name;
        private String url;

        private App() {
        }
    }
}

