/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.Locale;
import org.kohsuke.github.GHObject;
import org.kohsuke.github.GHOrganization;
import org.kohsuke.github.GHPermissionType;
import org.kohsuke.github.GHProjectColumn;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.GHUser;
import org.kohsuke.github.GitHubClient;
import org.kohsuke.github.PagedIterable;
import org.kohsuke.github.Requester;

public class GHProject
extends GHObject {
    private String body;
    private GHUser creator;
    private String htmlUrl;
    private String name;
    private int number;
    private String ownerUrl;
    private String state;
    protected GHObject owner;

    public GHProjectColumn createColumn(String name) throws IOException {
        return ((Requester)((Requester)((Requester)this.root().createRequest().method("POST")).with("name", name)).withUrlPath(String.format("/projects/%d/columns", this.getId()), new String[0])).fetch(GHProjectColumn.class).lateBind(this);
    }

    public void delete() throws IOException {
        ((Requester)((Requester)this.root().createRequest().method("DELETE")).withUrlPath(this.getApiRoute(), new String[0])).send();
    }

    public String getBody() {
        return this.body;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="Expected behavior")
    public GHUser getCreator() {
        return this.creator;
    }

    public URL getHtmlUrl() {
        return GitHubClient.parseURL(this.htmlUrl);
    }

    public String getName() {
        return this.name;
    }

    public int getNumber() {
        return this.number;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="Expected behavior")
    public GHObject getOwner() throws IOException {
        if (this.owner == null) {
            try {
                if (this.ownerUrl.contains("/orgs/")) {
                    this.owner = ((Requester)this.root().createRequest().withUrlPath(this.getOwnerUrl().getPath(), new String[0])).fetch(GHOrganization.class);
                } else if (this.ownerUrl.contains("/users/")) {
                    this.owner = ((Requester)this.root().createRequest().withUrlPath(this.getOwnerUrl().getPath(), new String[0])).fetch(GHUser.class);
                } else if (this.ownerUrl.contains("/repos/")) {
                    String[] pathElements = this.getOwnerUrl().getPath().split("/");
                    this.owner = GHRepository.read(this.root(), pathElements[1], pathElements[2]);
                }
            }
            catch (FileNotFoundException e) {
                return null;
            }
        }
        return this.owner;
    }

    public URL getOwnerUrl() {
        return GitHubClient.parseURL(this.ownerUrl);
    }

    public ProjectState getState() {
        return Enum.valueOf(ProjectState.class, this.state.toUpperCase(Locale.ENGLISH));
    }

    public PagedIterable<GHProjectColumn> listColumns() {
        GHProject project = this;
        return ((Requester)this.root().createRequest().withUrlPath(String.format("/projects/%d/columns", this.getId()), new String[0])).toIterable(GHProjectColumn[].class, item -> item.lateBind(project));
    }

    public void setBody(String body) throws IOException {
        this.edit("body", body);
    }

    public void setName(String name) throws IOException {
        this.edit("name", name);
    }

    public void setOrganizationPermission(GHPermissionType permission) throws IOException {
        this.edit("organization_permission", permission.toString().toLowerCase());
    }

    public void setPublic(boolean isPublic) throws IOException {
        this.edit("public", isPublic);
    }

    public void setState(ProjectState state) throws IOException {
        this.edit("state", state.toString().toLowerCase());
    }

    private void edit(String key, Object value) throws IOException {
        ((Requester)((Requester)((Requester)this.root().createRequest().method("PATCH")).with(key, value)).withUrlPath(this.getApiRoute(), new String[0])).send();
    }

    protected String getApiRoute() {
        return "/projects/" + this.getId();
    }

    GHProject lateBind(GHRepository repo) {
        this.owner = repo;
        return this;
    }

    public static enum ProjectState {
        CLOSED,
        OPEN;

    }

    public static enum ProjectStateFilter {
        ALL,
        CLOSED,
        OPEN;

    }
}

