/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import com.infradna.tool.bridge_method_injector.WithBridgeMethods;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.net.URL;
import java.time.Instant;
import java.util.Date;
import javax.annotation.CheckForNull;
import org.kohsuke.github.GHObject;
import org.kohsuke.github.GHPullRequest;
import org.kohsuke.github.GHPullRequestReviewComment;
import org.kohsuke.github.GHPullRequestReviewEvent;
import org.kohsuke.github.GHPullRequestReviewState;
import org.kohsuke.github.GHUser;
import org.kohsuke.github.GitHubClient;
import org.kohsuke.github.PagedIterable;
import org.kohsuke.github.Requester;

@SuppressFBWarnings(value={"UWF_UNWRITTEN_FIELD"}, justification="JSON API")
public class GHPullRequestReview
extends GHObject {
    private String body;
    private String commitId;
    private String htmlUrl;
    private GHPullRequestReviewState state;
    private String submittedAt;
    private GHUser user;
    GHPullRequest owner;

    public void delete() throws IOException {
        ((Requester)((Requester)this.owner.root().createRequest().method("DELETE")).withUrlPath(this.getApiRoute(), new String[0])).send();
    }

    public void dismiss(String message) throws IOException {
        ((Requester)((Requester)((Requester)this.owner.root().createRequest().method("PUT")).with("message", message)).withUrlPath(this.getApiRoute() + "/dismissals", new String[0])).send();
        this.state = GHPullRequestReviewState.DISMISSED;
    }

    public String getBody() {
        return this.body;
    }

    public String getCommitId() {
        return this.commitId;
    }

    @Override
    @WithBridgeMethods(value={Date.class}, adapterMethod="instantToDate")
    public Instant getCreatedAt() throws IOException {
        return this.getSubmittedAt();
    }

    public URL getHtmlUrl() {
        return GitHubClient.parseURL(this.htmlUrl);
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="Expected behavior")
    public GHPullRequest getParent() {
        return this.owner;
    }

    @CheckForNull
    public GHPullRequestReviewState getState() {
        return this.state;
    }

    @WithBridgeMethods(value={Date.class}, adapterMethod="instantToDate")
    public Instant getSubmittedAt() {
        return GitHubClient.parseInstant(this.submittedAt);
    }

    public GHUser getUser() throws IOException {
        if (this.user != null) {
            return this.owner.root().getUser(this.user.getLogin());
        }
        return null;
    }

    public PagedIterable<GHPullRequestReviewComment> listReviewComments() {
        return ((Requester)this.owner.root().createRequest().withUrlPath(this.getApiRoute() + "/comments", new String[0])).toIterable(GHPullRequestReviewComment[].class, item -> item.wrapUp(this.owner));
    }

    public void submit(String body, GHPullRequestReviewEvent event) throws IOException {
        ((Requester)((Requester)((Requester)((Requester)this.owner.root().createRequest().method("POST")).with("body", body)).with("event", event.action())).withUrlPath(this.getApiRoute() + "/events", new String[0])).fetchInto(this);
        this.body = body;
        this.state = event.toState();
    }

    protected String getApiRoute() {
        return this.owner.getApiRoute() + "/reviews/" + this.getId();
    }

    GHPullRequestReview wrapUp(GHPullRequest owner) {
        this.owner = owner;
        return this;
    }
}

