/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import java.io.IOException;
import org.kohsuke.github.GHPullRequest;
import org.kohsuke.github.GHPullRequestReviewComment;
import org.kohsuke.github.Requester;

public class GHPullRequestReviewCommentBuilder {
    private final Requester builder;
    private final GHPullRequest pr;

    GHPullRequestReviewCommentBuilder(GHPullRequest pr) {
        this.pr = pr;
        this.builder = pr.root().createRequest();
    }

    public GHPullRequestReviewCommentBuilder body(String body) {
        this.builder.with("body", body);
        return this;
    }

    public GHPullRequestReviewCommentBuilder commitId(String commitId) {
        this.builder.with("commit_id", commitId);
        return this;
    }

    public GHPullRequestReviewComment create() throws IOException {
        return ((Requester)((Requester)this.builder.method("POST")).withUrlPath(this.pr.getApiRoute() + "/comments", new String[0])).fetch(GHPullRequestReviewComment.class).wrapUp(this.pr);
    }

    public GHPullRequestReviewCommentBuilder line(int line) {
        this.builder.with("line", line);
        this.builder.remove("start_line");
        return this;
    }

    public GHPullRequestReviewCommentBuilder lines(int startLine, int endLine) {
        this.builder.with("start_line", startLine);
        this.builder.with("line", endLine);
        return this;
    }

    public GHPullRequestReviewCommentBuilder path(String path) {
        this.builder.with("path", path);
        return this;
    }

    public GHPullRequestReviewCommentBuilder side(GHPullRequestReviewComment.Side side) {
        this.builder.with("side", side);
        this.builder.remove("start_side");
        return this;
    }

    public GHPullRequestReviewCommentBuilder sides(GHPullRequestReviewComment.Side startSide, GHPullRequestReviewComment.Side endSide) {
        this.builder.with("start_side", startSide);
        this.builder.with("side", endSide);
        return this;
    }

    GHPullRequestReviewCommentBuilder position(int position) {
        this.builder.with("position", position);
        return this;
    }
}

