/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLEncoder;
import java.time.Instant;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.kohsuke.github.GHAsset;
import org.kohsuke.github.GHObject;
import org.kohsuke.github.GHReleaseUpdater;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.GitHubClient;
import org.kohsuke.github.PagedIterable;
import org.kohsuke.github.Requester;

public class GHRelease
extends GHObject {
    private List<GHAsset> assets;
    private String assetsUrl;
    private String body;
    private String discussionUrl;
    private boolean draft;
    private String htmlUrl;
    private String name;
    private boolean prerelease;
    private String publishedAt;
    private String tagName;
    private String tarballUrl;
    private String targetCommitish;
    private String uploadUrl;
    private String zipballUrl;
    GHRepository owner;

    static GHRelease[] wrap(GHRelease[] releases, GHRepository owner) {
        for (GHRelease release : releases) {
            release.wrap(owner);
        }
        return releases;
    }

    public void delete() throws IOException {
        ((Requester)((Requester)this.root().createRequest().method("DELETE")).withUrlPath(this.owner.getApiTailUrl("releases/" + this.getId()), new String[0])).send();
    }

    public List<GHAsset> getAssets() {
        return Collections.unmodifiableList(this.assets);
    }

    public String getAssetsUrl() {
        return this.assetsUrl;
    }

    public String getBody() {
        return this.body;
    }

    public String getDiscussionUrl() {
        return this.discussionUrl;
    }

    public URL getHtmlUrl() {
        return GitHubClient.parseURL(this.htmlUrl);
    }

    public String getName() {
        return this.name;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="Expected behavior")
    public GHRepository getOwner() {
        return this.owner;
    }

    public Instant getPublishedAt() {
        return GitHubClient.parseInstant(this.publishedAt);
    }

    @Deprecated
    public Date getPublished_at() {
        return Date.from(this.getPublishedAt());
    }

    public String getTagName() {
        return this.tagName;
    }

    public String getTarballUrl() {
        return this.tarballUrl;
    }

    public String getTargetCommitish() {
        return this.targetCommitish;
    }

    public String getUploadUrl() {
        return this.uploadUrl;
    }

    public String getZipballUrl() {
        return this.zipballUrl;
    }

    public boolean isDraft() {
        return this.draft;
    }

    public boolean isPrerelease() {
        return this.prerelease;
    }

    public PagedIterable<GHAsset> listAssets() {
        Requester builder = this.owner.root().createRequest();
        return ((Requester)builder.withUrlPath(this.getApiTailUrl("assets"), new String[0])).toIterable(GHAsset[].class, item -> item.wrap(this));
    }

    public GHReleaseUpdater update() {
        return new GHReleaseUpdater(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GHAsset uploadAsset(File file, String contentType) throws IOException {
        try (FileInputStream s = new FileInputStream(file);){
            GHAsset gHAsset = this.uploadAsset(file.getName(), s, contentType);
            return gHAsset;
        }
    }

    public GHAsset uploadAsset(String filename, InputStream stream, String contentType) throws IOException {
        Requester builder = (Requester)this.owner.root().createRequest().method("POST");
        Object url = this.getUploadUrl();
        int endIndex = ((String)url).indexOf(123);
        if (endIndex != -1) {
            url = ((String)url).substring(0, endIndex);
        }
        url = (String)url + "?name=" + URLEncoder.encode(filename, "UTF-8");
        return ((Requester)((Requester)((Requester)builder.contentType(contentType)).with(stream)).withUrlPath((String)url, new String[0])).fetch(GHAsset.class).wrap(this);
    }

    private String getApiTailUrl(String end) {
        return this.owner.getApiTailUrl(String.format("releases/%s/%s", this.getId(), end));
    }

    GHRelease wrap(GHRepository owner) {
        this.owner = owner;
        return this;
    }
}

