/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.github;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import org.kohsuke.github.GHOrganization;
import org.kohsuke.github.GHTeam;
import org.kohsuke.github.GitHub;
import org.kohsuke.github.GitHubInteractiveObject;
import org.kohsuke.github.Requester;

public class GHTeamBuilder
extends GitHubInteractiveObject {
    private final String orgName;
    protected final Requester builder;

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="Expected")
    public GHTeamBuilder(GitHub root, String orgName, String name) {
        super(root);
        this.orgName = orgName;
        this.builder = root.createRequest();
        this.builder.with("name", name);
    }

    public GHTeam create() throws IOException {
        return ((Requester)((Requester)this.builder.method("POST")).withUrlPath("/orgs/" + this.orgName + "/teams", new String[0])).fetch(GHTeam.class).wrapUp(this.root());
    }

    public GHTeamBuilder description(String description) {
        this.builder.with("description", description);
        return this;
    }

    public GHTeamBuilder maintainers(String ... maintainers) {
        this.builder.with("maintainers", maintainers);
        return this;
    }

    public GHTeamBuilder parentTeamId(long parentTeamId) {
        this.builder.with("parent_team_id", parentTeamId);
        return this;
    }

    @Deprecated
    public GHTeamBuilder permission(GHOrganization.Permission permission) {
        this.builder.with("permission", permission);
        return this;
    }

    public GHTeamBuilder privacy(GHTeam.Privacy privacy) {
        this.builder.with("privacy", privacy);
        return this;
    }

    public GHTeamBuilder repositories(String ... repoNames) {
        this.builder.with("repo_names", repoNames);
        return this;
    }
}

