/*
 * Decompiled with CFR 0.152.
 */
package org.jinterop.dcom.core;

import com.iwombat.foundation.IdentifierFactory;
import com.iwombat.util.GUIDUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import org.jinterop.dcom.common.IJIUnreferenced;
import org.jinterop.dcom.common.JIException;
import org.jinterop.dcom.common.JISystem;
import org.jinterop.dcom.core.IJIComObject;
import org.jinterop.dcom.core.JIArray;
import org.jinterop.dcom.core.JICallBuilder;
import org.jinterop.dcom.core.JIInterfacePointer;
import org.jinterop.dcom.core.JISession;
import rpc.core.UUID;

final class JIComObjectImpl
implements IJIComObject {
    private static final long serialVersionUID = -1661750453596032089L;
    private boolean isDual = false;
    private boolean dualInfo = false;
    private transient JISession session = null;
    private JIInterfacePointer ptr = null;
    private Map connectionPointInfo = null;
    private int timeout = 0;
    private final boolean isLocal;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    JIComObjectImpl(JISession session, JIInterfacePointer ptr) {
        this(session, ptr, false);
    }

    JIComObjectImpl(JISession session, JIInterfacePointer ptr, boolean isLocal) {
        this.session = session;
        this.ptr = ptr;
        this.isLocal = isLocal;
    }

    void replaceMembers(IJIComObject comObject) {
        this.session = comObject.getAssociatedSession();
        this.ptr = comObject.internal_getInterfacePointer();
    }

    private void checkLocal() {
        if (this.session == null) {
            throw new IllegalStateException(JISystem.getLocalizedMessage(4176));
        }
        if (this.isLocalReference()) {
            throw new IllegalStateException(JISystem.getLocalizedMessage(-2147467263));
        }
    }

    public IJIComObject queryInterface(String iid) throws JIException {
        this.checkLocal();
        return this.session.getStub().getInterface(iid, this.ptr.getIPID());
    }

    public void addRef() throws JIException {
        this.checkLocal();
        JICallBuilder obj = new JICallBuilder(true);
        obj.setParentIpid(this.ptr.getIPID());
        obj.setOpnum(1);
        obj.addInParamAsShort((short)1, 0);
        JIArray array = new JIArray(new UUID[]{new UUID(this.ptr.getIPID())}, true);
        obj.addInParamAsArray(array, 0);
        obj.addInParamAsInt(5, 0);
        obj.addInParamAsInt(0, 0);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.Short");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        obj.addOutParamAsType(clazz, 0);
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("java.lang.Integer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        obj.addOutParamAsType(clazz2, 0);
        if (JISystem.getLogger().isLoggable(Level.INFO)) {
            JISystem.getLogger().warning("addRef: Adding 5 references for " + this.ptr.getIPID() + " session: " + this.session.getSessionIdentifier());
            JISession.debug_addIpids(this.ptr.getIPID(), 5);
        }
        this.session.getStub().addRef_ReleaseRef(obj);
        if (obj.getResultAsIntAt(1) != 0) {
            throw new JIException(obj.getResultAsIntAt(1), null);
        }
    }

    public void release() throws JIException {
        this.checkLocal();
        JICallBuilder obj = new JICallBuilder(true);
        obj.setParentIpid(this.ptr.getIPID());
        obj.setOpnum(2);
        obj.addInParamAsShort((short)1, 0);
        JIArray array = new JIArray(new UUID[]{new UUID(this.ptr.getIPID())}, true);
        obj.addInParamAsArray(array, 0);
        obj.addInParamAsInt(5, 0);
        obj.addInParamAsInt(0, 0);
        if (JISystem.getLogger().isLoggable(Level.INFO)) {
            JISystem.getLogger().warning("RELEASE called directly ! removing 5 references for " + this.ptr.getIPID() + " session: " + this.session.getSessionIdentifier());
            JISession.debug_delIpids(this.ptr.getIPID(), 5);
        }
        this.session.getStub().addRef_ReleaseRef(obj);
    }

    public Object[] call(JICallBuilder obj) throws JIException {
        this.checkLocal();
        return this.call(obj, this.timeout);
    }

    public JIInterfacePointer internal_getInterfacePointer() {
        return this.ptr == null ? this.session.getStub().getServerInterfacePointer() : this.ptr;
    }

    public String getIpid() {
        return this.ptr.getIPID();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof JIComObjectImpl)) {
            return false;
        }
        return this.ptr.getIPID().equalsIgnoreCase(((IJIComObject)obj).getIpid());
    }

    public int hashCode() {
        return this.ptr.getIPID().hashCode();
    }

    public JISession getAssociatedSession() {
        return this.session;
    }

    public String getInterfaceIdentifier() {
        return this.ptr.getIID();
    }

    public synchronized boolean isDispatchSupported() {
        this.checkLocal();
        if (!this.dualInfo) {
            try {
                IJIComObject comObject = this.queryInterface("00020400-0000-0000-c000-000000000046");
                comObject.release();
                this.setIsDual(true);
            }
            catch (JIException e) {
                this.setIsDual(false);
            }
        }
        return this.isDual;
    }

    public synchronized String internal_setConnectionInfo(IJIComObject connectionPoint, Integer cookie) {
        this.checkLocal();
        if (this.connectionPointInfo == null) {
            this.connectionPointInfo = new HashMap();
        }
        String uniqueId = GUIDUtil.guidStringFromHexString((String)IdentifierFactory.createUniqueIdentifier().toHexString());
        this.connectionPointInfo.put(uniqueId, new Object[]{connectionPoint, cookie});
        return uniqueId;
    }

    public synchronized Object[] internal_getConnectionInfo(String identifier) {
        this.checkLocal();
        return (Object[])this.connectionPointInfo.get(identifier);
    }

    public synchronized Object[] internal_removeConnectionInfo(String identifier) {
        this.checkLocal();
        return (Object[])this.connectionPointInfo.remove(identifier);
    }

    public IJIUnreferenced getUnreferencedHandler() {
        this.checkLocal();
        return this.session.getUnreferencedHandler(this.getIpid());
    }

    public void registerUnreferencedHandler(IJIUnreferenced unreferenced) {
        this.checkLocal();
        this.session.registerUnreferencedHandler(this.getIpid(), unreferenced);
    }

    public void unregisterUnreferencedHandler() {
        this.checkLocal();
        this.session.unregisterUnreferencedHandler(this.getIpid());
    }

    public Object[] call(JICallBuilder obj, int socketTimeout) throws JIException {
        this.checkLocal();
        obj.attachSession(this.session);
        obj.setParentIpid(this.ptr.getIPID());
        if (socketTimeout != 0) {
            return this.session.getStub().call(obj, this.ptr.getIID(), socketTimeout);
        }
        return this.session.getStub().call(obj, this.ptr.getIID());
    }

    public int getInstanceLevelSocketTimeout() {
        this.checkLocal();
        return this.timeout;
    }

    public void setInstanceLevelSocketTimeout(int timeout) {
        this.checkLocal();
        this.timeout = timeout;
    }

    public void internal_setDeffered(boolean deffered) {
        this.ptr.setDeffered(deffered);
    }

    public boolean isLocalReference() {
        return this.isLocal;
    }

    void setIsDual(boolean isDual) {
        this.dualInfo = true;
        this.isDual = isDual;
    }

    public String toString() {
        return "IJIComObject[" + this.internal_getInterfacePointer() + " , session: " + this.getAssociatedSession().getSessionIdentifier() + ", isLocal: " + this.isLocalReference() + "]";
    }
}

