/*
 * Decompiled with CFR 0.152.
 */
package org.kopitubruk.util.json;

import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import org.kopitubruk.util.json.JSONConfig;
import org.kopitubruk.util.json.JSONException;
import org.kopitubruk.util.json.JSONUtil;

public final class DataStructureLoopException
extends JSONException {
    private Object offender;
    private Object[] objStack = null;
    private static final long serialVersionUID = 1L;

    DataStructureLoopException(Object offender, JSONConfig cfg) {
        super(cfg);
        this.offender = offender;
        List<Object> stk = cfg.getObjStack();
        this.objStack = stk.toArray(new Object[stk.size()]);
    }

    @Override
    String internalGetMessage(Locale locale) {
        ResourceBundle bundle = JSONUtil.getBundle(locale);
        StringBuilder message = new StringBuilder();
        message.append(String.format(bundle.getString("dataStructureLoop"), this.getClassName(this.offender)));
        for (int i = 0; i < this.objStack.length; ++i) {
            Object currentObject = this.objStack[i];
            message.append("\n\t").append(i).append(' ').append(this.getClassName(currentObject));
            if (this.offender != currentObject) continue;
            message.append(" <<<");
        }
        return message.toString();
    }
}

