/*
 * Decompiled with CFR 0.152.
 */
package org.kopitubruk.util.json;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.regex.Pattern;
import org.kopitubruk.util.json.JSONConfigUtil;
import org.kopitubruk.util.json.ReflectUtil;

public class JSONReflectedClass
implements Cloneable {
    private static final Pattern COMMA = Pattern.compile(",");
    private static final Pattern EQUALS = Pattern.compile("=");
    private Class<?> objClass;
    private Set<String> fieldNames;
    private TreeMap<String, String> fieldAliases;

    public JSONReflectedClass(Object obj) {
        this(obj, null, null);
    }

    public JSONReflectedClass(Object obj, Collection<String> fieldNames) {
        this(obj, fieldNames, null);
    }

    public JSONReflectedClass(Object obj, Map<String, String> fieldAliases) {
        this(obj, null, fieldAliases);
    }

    public JSONReflectedClass(Object obj, Collection<String> fieldNames, Map<String, String> fieldAliases) {
        this.setObjClass(obj);
        this.setFieldNames(fieldNames);
        this.setFieldAliases(fieldAliases);
    }

    public JSONReflectedClass(String className) throws ClassNotFoundException {
        String[] parts = COMMA.split(className, 0);
        Class<?> clazz = ReflectUtil.getClassByName(parts[0].trim());
        ArrayList<String> fnames = null;
        LinkedHashMap<String, String> aliases = null;
        if (parts.length > 1) {
            fnames = new ArrayList<String>();
            aliases = new LinkedHashMap<String, String>();
            for (int i = 1; i < parts.length; ++i) {
                String fieldName = parts[i].trim();
                if (fieldName.indexOf(61) >= 0) {
                    String[] pair = EQUALS.split(fieldName, 0);
                    if (pair.length != 2) continue;
                    aliases.put(pair[0].trim(), pair[1].trim());
                    continue;
                }
                if (fieldName.length() <= 0) continue;
                fnames.add(fieldName);
            }
        }
        this.setObjClass(clazz);
        this.setFieldNames(fnames);
        this.setFieldAliases(aliases);
    }

    private JSONReflectedClass() {
    }

    public Class<?> getObjClass() {
        return this.objClass;
    }

    public void setObjClass(Object obj) {
        this.objClass = ReflectUtil.getClass(obj);
    }

    public Set<String> getFieldNames() {
        return this.fieldNames == null ? null : new LinkedHashSet<String>(this.fieldNames);
    }

    Set<String> getFieldNamesRaw() {
        return this.fieldNames;
    }

    public void setFieldNames(Collection<String> fieldNames) {
        if (fieldNames == null || fieldNames.size() < 1) {
            this.fieldNames = null;
        } else {
            int tableSize = JSONConfigUtil.tableSizeFor(fieldNames.size());
            LinkedHashSet<String> ids = new LinkedHashSet<String>(tableSize);
            for (String id : fieldNames) {
                String tid;
                if (id == null || !JSONReflectedClass.isValidJavaIdentifier(tid = id.trim())) continue;
                ids.add(tid);
            }
            int size = ids.size();
            this.fieldNames = size < 1 ? null : (tableSize > JSONConfigUtil.tableSizeFor(size) ? new LinkedHashSet<String>(ids) : ids);
        }
    }

    public Map<String, String> getFieldAliases() {
        return this.fieldAliases;
    }

    TreeMap<String, String> getFieldAliasesTreeMap() {
        return this.fieldAliases;
    }

    public void setFieldAliases(Map<String, String> fieldAliases) {
        if (fieldAliases == null || fieldAliases.size() < 1) {
            this.fieldAliases = null;
        } else {
            this.fieldAliases = new TreeMap();
            for (Map.Entry<String, String> entry : fieldAliases.entrySet()) {
                String value;
                String alias;
                String key = entry.getKey();
                String fieldName = key == null ? "" : key.trim();
                if (!JSONReflectedClass.isValidJavaIdentifier(fieldName) || (alias = (value = entry.getValue()) == null ? "" : value.trim()).length() <= 0) continue;
                this.fieldAliases.put(fieldName, alias);
            }
            if (this.fieldAliases.size() < 1) {
                this.fieldAliases = null;
            }
        }
    }

    String getFieldAlias(String fieldName) {
        if (this.fieldAliases == null) {
            return fieldName;
        }
        String result = this.fieldAliases.get(fieldName);
        return result != null ? result : fieldName;
    }

    static boolean isValidJavaIdentifier(String id) {
        int i;
        int codePoint;
        int len = id.length();
        for (i = 0; i < len; i += Character.charCount(codePoint)) {
            codePoint = id.codePointAt(i);
            if (i > 0 && Character.isJavaIdentifierPart(codePoint) || i == 0 && Character.isJavaIdentifierStart(codePoint)) continue;
            return false;
        }
        return i > 0;
    }

    public synchronized JSONReflectedClass clone() {
        JSONReflectedClass result = new JSONReflectedClass();
        result.objClass = this.objClass;
        result.fieldNames = this.fieldNames;
        result.fieldAliases = this.fieldAliases == null ? null : new TreeMap<String, String>((SortedMap<String, String>)this.fieldAliases);
        return result;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.objClass.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JSONReflectedClass other = (JSONReflectedClass)obj;
        return this.objClass == other.objClass;
    }
}

