/*
 * Decompiled with CFR 0.152.
 */
package org.kopitubruk.util.json;

import java.io.IOException;
import java.io.Writer;
import org.kopitubruk.util.json.AbstractPseudoMap;
import org.kopitubruk.util.json.DynamicPseudoMap;
import org.kopitubruk.util.json.FixedPseudoMap;
import org.kopitubruk.util.json.JSONAble;
import org.kopitubruk.util.json.JSONConfig;
import org.kopitubruk.util.json.JSONUtil;

public class JsonObject
implements JSONAble {
    private AbstractPseudoMap pseudoMap;
    private JSONConfig cfg;

    public JsonObject() {
        this(null);
    }

    public JsonObject(JSONConfig cfg) {
        this.pseudoMap = new DynamicPseudoMap();
        this.cfg = cfg;
    }

    public JsonObject(int size) {
        this(size, null);
    }

    public JsonObject(int size, JSONConfig cfg) {
        this.pseudoMap = new FixedPseudoMap(size);
        this.cfg = cfg;
    }

    public JsonObject add(Object name, Object value) {
        this.pseudoMap.put(name, value);
        return this;
    }

    public int size() {
        return this.pseudoMap.size();
    }

    public void clear() {
        this.pseudoMap.clear();
    }

    public void trimToSize() {
        if (this.pseudoMap instanceof DynamicPseudoMap) {
            ((DynamicPseudoMap)this.pseudoMap).trimToSize();
        }
    }

    public JSONConfig getJSONConfig() {
        return this.cfg;
    }

    public void setJSONConfig(JSONConfig cfg) {
        this.cfg = cfg;
    }

    public String toString() {
        return this.toJSON();
    }

    @Override
    public String toJSON() {
        return JSONUtil.toJSON((Object)this.pseudoMap, this.cfg);
    }

    @Override
    public String toJSON(JSONConfig jsonConfig) {
        JSONConfig jcfg = jsonConfig == null ? this.cfg : jsonConfig;
        return JSONUtil.toJSON((Object)this.pseudoMap, jcfg);
    }

    @Override
    public void toJSON(Writer json) throws IOException {
        JSONUtil.toJSON(this.pseudoMap, this.cfg, json);
    }

    @Override
    public void toJSON(JSONConfig jsonConfig, Writer json) throws IOException {
        JSONConfig jcfg = jsonConfig == null ? this.cfg : jsonConfig;
        JSONUtil.toJSON(this.pseudoMap, jcfg, json);
    }
}

