/*
 * Decompiled with CFR 0.152.
 */
package org.kopitubruk.util.json;

import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.kopitubruk.util.json.JSONConfig;
import org.kopitubruk.util.json.JSONUtil;
import org.kopitubruk.util.json.UndefinedCodePointException;
import org.kopitubruk.util.json.UnmatchedSurrogateException;

class StringProcessor {
    private static final Pattern JAVASCRIPT_ESC_PAT = Pattern.compile("(\\\\([bfnrtv\\\\/'\"]|(x\\p{XDigit}{2})|([0-3]?[0-7]{1,2})))");
    private static final Pattern CODE_UNIT_PAT = Pattern.compile("(\\\\u(\\p{XDigit}{4}))");
    private static final Pattern CODE_POINT_PAT = Pattern.compile("(\\\\u\\{(\\p{XDigit}+)\\})");
    private static final Pattern JSON5_ESCAPE_PASS_THROUGH_PAT = Pattern.compile("(\\\\u\\p{XDigit}{4}|\\\\[bfnrt\\\\/\"])");
    private static final Pattern JSON6_ESCAPE_PASS_THROUGH_PAT = Pattern.compile("(\\\\u\\p{XDigit}{4}|\\\\u\\{\\p{XDigit}+\\}|\\\\[bfnrt\\\\/\"])");
    private static final Pattern ECMA5_ESCAPE_PASS_THROUGH_PAT = CODE_UNIT_PAT;
    private static final Pattern ECMA6_ESCAPE_PASS_THROUGH_PAT = Pattern.compile("(\\\\u\\p{XDigit}{4}|\\\\u\\{\\p{XDigit}+\\})");
    private static final Map<String, Character> JAVASCRIPT_ESC_MAP;
    static final Map<Character, String> JSON_ESC_MAP;
    private static final int MAX_CODE_POINT_ESC_LENGTH = 10;
    private static final int CODE_UNIT_ESC_LENGTH = 6;
    private static final int MAX_JS_ESC_LENGTH = 4;
    static final char LINE_SEPARATOR = '\u2028';
    static final char PARAGRAPH_SEPARATOR = '\u2029';
    static final char MAX_ASCII = '\u007f';
    private static final char BACKSLASH = '\\';
    private static final String BS = "\\b";
    private static final String TAB = "\\t";
    private static final String NL = "\\n";
    private static final String FF = "\\f";
    private static final String CR = "\\r";
    private static final String DQ = "\\\"";
    private static final String SL = "\\/";
    private static final String BK = "\\\\";
    private static final int NUM_CONTROLS = 16;
    private static final String[] UNICODE_ESC;
    private static final String[] SINGLE_ESC;
    private static final String[] ECMA6_ESC;
    private static final String[] ECMA6_SINGLE_ESC;
    private static final char[] HEX_DIGITS;
    private static final char[] INITIAL_ONEBUF;
    private static final char[] INITIAL_TWOBUF;
    private static final char[] INITIAL_ECMA6_5;
    private static final char[] INITIAL_ECMA6_6;
    static final char UNICODE_REPLACEMENT_CHARACTER = '\ufffd';
    private JSONConfig cfg;
    private String strValue;
    private EscapeHandler handler;
    private EscapeChecker escChecker;
    private String[] controls;
    private char[] oneBuf = null;
    private char[] twoBuf = null;
    private char[] ecma6_5 = null;
    private char[] ecma6_6 = null;
    private int nextIndex;
    private int len;
    private int lastProcessIndex;
    private int beginIndex;
    private int endIndex;
    private int unmatchedSurrogatePolicy;
    private int undefinedCodePointPolicy;
    private int handleEscaping;
    private int processInlineEscapes;
    private int useECMA6;
    private int useSingleLetterEscapes;
    private int escapeSurrogates;
    private int isSupplementary;
    private int isUnmatchedSurrogate;
    private int isDefined;
    private int isReplaced;
    private int didDiscard;
    private int haveCodePoint;
    private boolean noProcessing;
    private boolean supportEval;
    private boolean escapeNonAscii;
    private String escape;
    private char[] chars;
    private int index;
    private int codePoint;
    private int charCount;

    StringProcessor(String strValue, JSONConfig cfg, boolean useSingleLetterEscapes, boolean processInlineEscapes) {
        this(strValue, cfg);
        this.useSingleLetterEscapes = useSingleLetterEscapes ? 1 : 0;
        this.processInlineEscapes = processInlineEscapes ? 1 : 0;
        this.supportEval = !cfg.isFullJSONIdentifierCodePoints();
        this.escapeNonAscii = cfg.isEscapeNonAscii();
        this.escapeSurrogates = cfg.isEscapeSurrogates() ? 1 : 0;
        this.lastProcessIndex = this.findLastProcessIndex();
        this.noProcessing = this.lastProcessIndex < 0;
        int n = this.handleEscaping = this.noProcessing ? 0 : 1;
        if (this.handleEscaping != 0) {
            if (this.useSingleLetterEscapes != 0) {
                String[] stringArray = this.controls = this.useECMA6 != 0 ? ECMA6_SINGLE_ESC : SINGLE_ESC;
            }
            if (this.processInlineEscapes != 0) {
                int lastBackSlash = strValue.lastIndexOf(92);
                int n2 = this.processInlineEscapes = lastBackSlash >= 0 ? 1 : 0;
                if (this.processInlineEscapes != 0) {
                    this.handler = new EscapeHandler(cfg, lastBackSlash);
                }
            }
        } else {
            this.escape = null;
        }
    }

    StringProcessor(String strValue, JSONConfig cfg, boolean processInlineEscapes) {
        this(strValue, cfg);
        this.beginIndex = -1;
        this.useSingleLetterEscapes = 1;
        this.processInlineEscapes = processInlineEscapes ? 1 : 0;
        this.supportEval = !cfg.isFullJSONIdentifierCodePoints();
        this.escapeNonAscii = cfg.isEscapeNonAscii();
        this.escapeSurrogates = this.escapeNonAscii || cfg.isEscapeSurrogates() ? 1 : 0;
        String[] stringArray = this.controls = this.useECMA6 != 0 ? ECMA6_SINGLE_ESC : SINGLE_ESC;
        if (this.processInlineEscapes != 0) {
            int lastBackSlash = strValue.lastIndexOf(92);
            int n = this.processInlineEscapes = lastBackSlash >= 0 ? 1 : 0;
            if (this.processInlineEscapes != 0) {
                this.handler = new EscapeHandler(cfg, lastBackSlash);
            }
        }
    }

    StringProcessor(String strValue, JSONConfig cfg) {
        this.strValue = strValue;
        this.cfg = cfg;
        this.chars = new char[2];
        this.len = strValue.length();
        this.index = 0;
        this.nextIndex = 0;
        this.charCount = 0;
        this.useECMA6 = cfg.isUseECMA6() ? 1 : 0;
        this.useSingleLetterEscapes = 0;
        this.unmatchedSurrogatePolicy = cfg.getUnmatchedSurrogatePolicy();
        this.undefinedCodePointPolicy = cfg.getUndefinedCodePointPolicy();
        this.controls = this.useECMA6 != 0 ? ECMA6_ESC : UNICODE_ESC;
        this.handleEscaping = 0;
    }

    int getCodePoint() {
        return this.codePoint;
    }

    int getCharCount() {
        return this.charCount;
    }

    int getIndex() {
        return this.index;
    }

    void setIndex(int i) {
        this.nextIndex = i;
        this.index = this.nextIndex - this.charCount;
    }

    String getEscape() {
        return this.escape;
    }

    boolean isNoProcessing() {
        return this.noProcessing;
    }

    void appendChars(StringBuilder buf) {
        buf.append(this.chars, 0, this.charCount);
    }

    void writeString(Writer json) throws IOException {
        this.lastProcessIndex = this.findLastProcessIndex();
        if (this.lastProcessIndex < 0) {
            json.write(this.strValue);
            return;
        }
        while (this.nextIndex < this.len) {
            this.nextCodePoint();
            if (this.haveCodePoint == 0) continue;
            if (this.processInlineEscapes != 0 && this.chars[0] == '\\') {
                String esc = this.handler.checkInlineEscape();
                if (esc != null) {
                    this.writeEscape(json, esc);
                    continue;
                }
                this.writeChars(json);
                continue;
            }
            if (this.needEscape()) {
                this.writeEscape(json, this.getEscapeString());
                continue;
            }
            if (this.isReplaced != 0) {
                this.writeChars(json);
                continue;
            }
            if (this.didDiscard != 0) {
                this.flushCurrentSubstring(json);
                if (this.nextIndex > this.lastProcessIndex) {
                    this.nextIndex = this.len;
                }
            }
            if (this.beginIndex < 0) {
                this.beginIndex = this.index;
            }
            this.endIndex = this.nextIndex;
        }
        this.flushCurrentSubstring(json);
    }

    private boolean needEscape() {
        if (this.isSupplementary == 0) {
            return this.escChecker.needEscape(this.chars[0]);
        }
        return this.escChecker.needEscape();
    }

    private void writeEscape(Writer json, String esc) throws IOException {
        this.flushCurrentSubstring(json);
        json.write(esc);
        this.checkLastProcess();
    }

    private void writeChars(Writer json) throws IOException {
        this.flushCurrentSubstring(json);
        json.write(this.chars, 0, this.charCount);
        this.checkLastProcess();
    }

    private void flushCurrentSubstring(Writer json) throws IOException {
        if (this.beginIndex >= 0) {
            json.write(this.strValue, this.beginIndex, this.endIndex - this.beginIndex);
            this.beginIndex = -1;
        }
    }

    private void checkLastProcess() {
        if (this.nextIndex > this.lastProcessIndex) {
            this.beginIndex = this.nextIndex;
            this.endIndex = this.nextIndex = this.len;
        }
    }

    boolean nextReady() {
        this.nextCodePoint();
        if (this.haveCodePoint != 0) {
            if (this.handleEscaping != 0) {
                this.escape = this.getEscapeIfNeeded();
            }
            return true;
        }
        return false;
    }

    private void nextCodePoint() {
        this.haveCodePoint = 0;
        this.didDiscard = 0;
        while (this.haveCodePoint == 0 && this.nextIndex < this.len) {
            this.index = this.nextIndex++;
            this.haveCodePoint = 1;
            this.isReplaced = 0;
            this.charCount = 1;
            this.chars[0] = this.strValue.charAt(this.index);
            this.codePoint = this.chars[0];
            this.isUnmatchedSurrogate = this.isSupplementary = StringProcessor.isSurrogate(this.chars[0]);
            if (this.isSupplementary != 0) {
                if (this.index + 1 < this.len) {
                    this.chars[1] = this.strValue.charAt(this.index + 1);
                    if (Character.isSurrogatePair(this.chars[0], this.chars[1])) {
                        this.isUnmatchedSurrogate = 0;
                        this.charCount = 2;
                        this.codePoint = Character.toCodePoint(this.chars[0], this.chars[1]);
                        this.isDefined = StringProcessor.isDefined(this.codePoint);
                    }
                }
                if (this.isUnmatchedSurrogate != 0) {
                    this.handleUnmatchedSurrogate();
                }
            } else {
                this.isDefined = StringProcessor.isDefined(this.chars[0]);
            }
            if (this.isDefined == 0) {
                this.handleUndefined();
            }
            ++this.nextIndex;
        }
    }

    private void handleUnmatchedSurrogate() {
        switch (this.unmatchedSurrogatePolicy) {
            case 0: {
                this.replaceCodePoint();
                break;
            }
            case 1: {
                this.didDiscard = 1;
                this.haveCodePoint = 0;
                break;
            }
            case 2: {
                throw new UnmatchedSurrogateException(this.cfg, this.strValue, this.index, this.chars[0]);
            }
            default: {
                this.isDefined = StringProcessor.isDefined(this.chars[0]);
                this.isSupplementary = 0;
            }
        }
    }

    private void handleUndefined() {
        switch (this.undefinedCodePointPolicy) {
            case 0: {
                this.replaceCodePoint();
                break;
            }
            case 1: {
                this.didDiscard = 1;
                this.haveCodePoint = 0;
                break;
            }
            case 2: {
                throw new UndefinedCodePointException(this.cfg, this.strValue, this.index, this.codePoint);
            }
        }
    }

    private void replaceCodePoint() {
        this.chars[0] = 65533;
        this.codePoint = 65533;
        this.isUnmatchedSurrogate = 0;
        this.isSupplementary = 0;
        this.charCount = 1;
        this.isReplaced = 1;
        this.isDefined = 1;
    }

    private String getEscapeIfNeeded() {
        if (this.index > this.lastProcessIndex) {
            this.handleEscaping = 0;
            return null;
        }
        if (this.processInlineEscapes != 0 && this.chars[0] == '\\') {
            return this.handler.checkInlineEscape();
        }
        if (this.needEscape()) {
            return this.getEscapeString();
        }
        return null;
    }

    String getEscapeString() {
        if (this.isSupplementary != 0) {
            if (this.useECMA6 != 0) {
                return this.makeECMA6Escape(this.codePoint);
            }
            return this.makeEscape(this.chars);
        }
        if (this.chars[0] < '\u0010') {
            return this.controls[this.chars[0]];
        }
        if (this.useSingleLetterEscapes != 0) {
            switch (this.chars[0]) {
                case '\"': {
                    return DQ;
                }
                case '/': {
                    return SL;
                }
                case '\\': {
                    return BK;
                }
            }
            return this.makeEscape(this.chars[0]);
        }
        return this.makeEscape(this.chars[0]);
    }

    private String makeEscape(int cp) {
        char[] esc = this.oneBuf;
        if (esc == null) {
            esc = this.oneBuf = StringProcessor.copyOf(INITIAL_ONEBUF);
        }
        esc[5] = HEX_DIGITS[cp & 0xF];
        esc[4] = HEX_DIGITS[cp >> 4 & 0xF];
        esc[3] = HEX_DIGITS[cp >> 8 & 0xF];
        esc[2] = HEX_DIGITS[cp >> 12];
        return new String(esc);
    }

    private String makeEscape(char[] ch) {
        char[] esc = this.twoBuf;
        if (esc == null) {
            esc = this.twoBuf = StringProcessor.copyOf(INITIAL_TWOBUF);
        }
        char cp = ch[1];
        esc[11] = HEX_DIGITS[cp & 0xF];
        esc[10] = HEX_DIGITS[cp >> 4 & 0xF];
        esc[9] = HEX_DIGITS[cp >> 8 & 0xF];
        esc[8] = HEX_DIGITS[cp >> 12];
        cp = ch[0];
        esc[5] = HEX_DIGITS[cp & 0xF];
        esc[4] = HEX_DIGITS[cp >> 4 & 0xF];
        esc[3] = HEX_DIGITS[cp >> 8 & 0xF];
        esc[2] = HEX_DIGITS[cp >> 12];
        return new String(esc);
    }

    private String makeECMA6Escape(int codePoint) {
        char[] esc;
        int cp = codePoint;
        if (cp >> 20 == 0) {
            esc = this.ecma6_5;
            if (esc == null) {
                esc = this.ecma6_5 = StringProcessor.copyOf(INITIAL_ECMA6_5);
            }
            esc[7] = HEX_DIGITS[cp & 0xF];
            esc[6] = HEX_DIGITS[cp >> 4 & 0xF];
            esc[5] = HEX_DIGITS[cp >> 8 & 0xF];
            esc[4] = HEX_DIGITS[cp >> 12 & 0xF];
            esc[3] = HEX_DIGITS[cp >> 16];
        } else {
            esc = this.ecma6_6;
            if (esc == null) {
                this.ecma6_6 = StringProcessor.copyOf(INITIAL_ECMA6_6);
                esc = this.ecma6_6;
            }
            esc[8] = HEX_DIGITS[cp & 0xF];
            esc[7] = HEX_DIGITS[cp >> 4 & 0xF];
            esc[6] = HEX_DIGITS[cp >> 8 & 0xF];
            esc[5] = HEX_DIGITS[cp >> 12 & 0xF];
        }
        return new String(esc);
    }

    int end(int regionLength) {
        return Math.min(this.index + regionLength, this.len);
    }

    private int findLastProcessIndex() {
        this.isUnmatchedSurrogate = 0;
        this.isDefined = 1;
        this.escChecker = this.getEscapeChecker();
        boolean needDefined = this.undefinedCodePointPolicy != 4;
        boolean needMatched = this.unmatchedSurrogatePolicy != 4;
        int i = this.len;
        while (i > 0) {
            char ch1;
            if (JSONUtil.isSurrogate(ch1 = this.strValue.charAt(--i))) {
                char ch0;
                this.isUnmatchedSurrogate = 1;
                if (--i >= 0 && Character.isSurrogatePair(ch0 = this.strValue.charAt(i), ch1)) {
                    this.isUnmatchedSurrogate = 0;
                    if (needDefined) {
                        this.isDefined = StringProcessor.isDefined(Character.toCodePoint(ch0, ch1));
                        if (this.escChecker.needEscape(ch1) || this.isDefined == 0) {
                            return i;
                        }
                    } else if (this.escChecker.needEscape(ch1)) {
                        return i;
                    }
                }
                if (this.isUnmatchedSurrogate == 0) continue;
                ++i;
                this.isDefined = StringProcessor.isDefined(ch1);
                if (this.escChecker.needEscape(ch1) || needMatched) {
                    return i;
                }
                this.isUnmatchedSurrogate = 0;
                continue;
            }
            if (needDefined) {
                this.isDefined = StringProcessor.isDefined(ch1);
                if (!this.escChecker.needEscape(ch1) && this.isDefined != 0) continue;
                return i;
            }
            if (!this.escChecker.needEscape(ch1)) continue;
            return i;
        }
        return -1;
    }

    private EscapeChecker getEscapeChecker() {
        if (this.supportEval) {
            if (this.escapeNonAscii) {
                return new AsciiEvalEscapeChecker();
            }
            if (this.escapeSurrogates != 0) {
                return new SurrogateEvalEscapeChecker();
            }
            return new EvalEscapeChecker();
        }
        if (this.escapeNonAscii) {
            return new AsciiEscapeChecker();
        }
        if (this.escapeSurrogates != 0) {
            return new SurrogateEscapeChecker();
        }
        return new BasicEscapeChecker();
    }

    private static char getEscapeChar(String esc) {
        char c = esc.charAt(1);
        char result = c == 'x' ? (char)Integer.parseInt(esc.substring(2), 16) : (Character.isDigit(c) ? (char)Integer.parseInt(esc.substring(1), 8) : JAVASCRIPT_ESC_MAP.get(esc).charValue());
        return result;
    }

    static String getEscape(char c) {
        return JSON_ESC_MAP.get(Character.valueOf(c));
    }

    static boolean haveJsonEsc(char c) {
        switch (c) {
            case '\b': 
            case '\t': 
            case '\n': 
            case '\f': 
            case '\r': 
            case '\"': 
            case '/': 
            case '\\': {
                return true;
            }
        }
        return false;
    }

    static Pattern getEscapePassThroughPattern(JSONConfig cfg, boolean useSingleLetterEscapes) {
        Pattern escapePassThroughPat = useSingleLetterEscapes || cfg.isFullJSONIdentifierCodePoints() ? (cfg.isUseECMA6() ? JSON6_ESCAPE_PASS_THROUGH_PAT : JSON5_ESCAPE_PASS_THROUGH_PAT) : (cfg.isUseECMA6() ? ECMA6_ESCAPE_PASS_THROUGH_PAT : ECMA5_ESCAPE_PASS_THROUGH_PAT);
        return escapePassThroughPat;
    }

    static int getEscapePassThroughRegionLength(JSONConfig cfg) {
        return cfg.isUseECMA6() ? 10 : 6;
    }

    static boolean gotMatch(Matcher matcher, int start, int end) {
        matcher.region(start, end);
        return matcher.find() && matcher.start() == start;
    }

    private static char[] copyOf(char[] src) {
        char[] dest = new char[src.length];
        System.arraycopy(src, 0, dest, 0, src.length);
        return dest;
    }

    private static boolean isControl(char ch) {
        return ch < ' ';
    }

    private static boolean isNotAscii(char ch) {
        return ch < ' ' || ch > '\u007f';
    }

    private static boolean isEsc(char ch) {
        switch (ch) {
            case '\"': 
            case '/': 
            case '\\': {
                return true;
            }
        }
        return false;
    }

    private static boolean isEvalEsc(char ch) {
        switch (ch) {
            case '\"': 
            case '/': 
            case '\\': 
            case '\u2028': 
            case '\u2029': {
                return true;
            }
        }
        return false;
    }

    private static int isDefined(char ch) {
        return Character.isDefined(ch) ? 1 : 0;
    }

    private static int isDefined(int cp) {
        return Character.isDefined(cp) ? 1 : 0;
    }

    private static int isSurrogate(char ch) {
        return JSONUtil.isSurrogate(ch) ? 1 : 0;
    }

    static char highSurrogate(int cp) {
        int[] cps = new int[]{cp};
        String str = new String(cps, 0, 1);
        return str.charAt(0);
    }

    static char lowSurrogate(int cp) {
        int[] cps = new int[]{cp};
        String str = new String(cps, 0, 1);
        return str.length() > 0 ? str.charAt(1) : str.charAt(0);
    }

    static String unEscape(String strValue, JSONConfig cfg) {
        int lastBackSlash = strValue.lastIndexOf(92);
        if (lastBackSlash < 0) {
            return strValue;
        }
        Matcher jsEscMatcher = JAVASCRIPT_ESC_PAT.matcher(strValue);
        Matcher codeUnitMatcher = CODE_UNIT_PAT.matcher(strValue);
        Matcher codePointMatcher = CODE_POINT_PAT.matcher(strValue);
        int jsLen = 4;
        int unLen = 6;
        int cpLen = 10;
        StringBuilder buf = new StringBuilder();
        StringProcessor cp = new StringProcessor(strValue, cfg);
        while (cp.nextReady()) {
            if (cp.codePoint == 92) {
                if (StringProcessor.gotMatch(jsEscMatcher, cp.index, cp.end(4))) {
                    String esc = jsEscMatcher.group(1);
                    buf.append(StringProcessor.getEscapeChar(esc));
                    cp.nextIndex += esc.length() - 1;
                } else if (StringProcessor.gotMatch(codeUnitMatcher, cp.index, cp.end(6))) {
                    StringProcessor.handleCodeUnitEscape(cp, codeUnitMatcher, buf);
                } else if (StringProcessor.gotMatch(codePointMatcher, cp.index, cp.end(10))) {
                    StringProcessor.handleCodePointEscape(cp, codePointMatcher, buf);
                } else {
                    cp.appendChars(buf);
                }
                if (cp.nextIndex <= lastBackSlash) continue;
                jsEscMatcher = null;
                codeUnitMatcher = null;
                codePointMatcher = null;
                continue;
            }
            cp.appendChars(buf);
        }
        return buf.toString();
    }

    private static void handleCodeUnitEscape(StringProcessor cp, Matcher codeUnitMatcher, StringBuilder buf) {
        String esc = codeUnitMatcher.group(1);
        String hexStr = codeUnitMatcher.group(2);
        char ch = (char)Integer.parseInt(hexStr, 16);
        boolean addIt = true;
        if (!Character.isDefined(ch)) {
            switch (cp.undefinedCodePointPolicy) {
                case 0: {
                    cp.replaceCodePoint();
                    ch = (char)cp.getCodePoint();
                    break;
                }
                case 1: {
                    addIt = false;
                    break;
                }
                case 2: {
                    throw new UndefinedCodePointException(cp.cfg, cp.strValue, cp.getIndex(), ch);
                }
            }
        }
        if (addIt) {
            buf.append(ch);
        }
        cp.nextIndex += esc.length() - 1;
    }

    private static void handleCodePointEscape(StringProcessor cp, Matcher codePointMatcher, StringBuilder buf) {
        String hexStr = codePointMatcher.group(2);
        int codePoint = Integer.parseInt(hexStr, 16);
        boolean addIt = true;
        if (!Character.isDefined(codePoint)) {
            switch (cp.undefinedCodePointPolicy) {
                case 0: {
                    cp.replaceCodePoint();
                    codePoint = cp.getCodePoint();
                    break;
                }
                case 1: {
                    addIt = false;
                    break;
                }
                case 2: {
                    throw new UndefinedCodePointException(cp.cfg, cp.strValue, cp.getIndex(), hexStr);
                }
                default: {
                    if (codePoint <= 0x10FFFF) break;
                    cp.replaceCodePoint();
                    codePoint = cp.getCodePoint();
                }
            }
        }
        if (addIt) {
            buf.appendCodePoint(codePoint);
        }
        cp.nextIndex += codePointMatcher.group(1).length() - 1;
    }

    static {
        UNICODE_ESC = new String[16];
        SINGLE_ESC = new String[16];
        ECMA6_ESC = new String[16];
        ECMA6_SINGLE_ESC = new String[16];
        HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        INITIAL_ONEBUF = "\\u....".toCharArray();
        INITIAL_TWOBUF = "\\u....\\u....".toCharArray();
        INITIAL_ECMA6_5 = "\\u{.....}".toCharArray();
        INITIAL_ECMA6_6 = "\\u{10....}".toCharArray();
        JSON_ESC_MAP = new HashMap<Character, String>(8);
        JSON_ESC_MAP.put(Character.valueOf('\b'), BS);
        JSON_ESC_MAP.put(Character.valueOf('\t'), TAB);
        JSON_ESC_MAP.put(Character.valueOf('\n'), NL);
        JSON_ESC_MAP.put(Character.valueOf('\f'), FF);
        JSON_ESC_MAP.put(Character.valueOf('\r'), CR);
        JSON_ESC_MAP.put(Character.valueOf('\"'), DQ);
        JSON_ESC_MAP.put(Character.valueOf('/'), SL);
        JSON_ESC_MAP.put(Character.valueOf('\\'), BK);
        JAVASCRIPT_ESC_MAP = new HashMap<String, Character>(JSON_ESC_MAP.size() + 2);
        for (Map.Entry<Character, String> entry : JSON_ESC_MAP.entrySet()) {
            JAVASCRIPT_ESC_MAP.put(entry.getValue(), entry.getKey());
        }
        JAVASCRIPT_ESC_MAP.put("\\v", Character.valueOf('\u000b'));
        JAVASCRIPT_ESC_MAP.put("\\'", Character.valueOf('\''));
        for (int ch = 0; ch < 16; ch = (int)((char)(ch + 1))) {
            String single = null;
            int i = ch;
            switch (ch) {
                case 8: {
                    single = BS;
                    break;
                }
                case 9: {
                    single = TAB;
                    break;
                }
                case 10: {
                    single = NL;
                    break;
                }
                case 12: {
                    single = FF;
                    break;
                }
                case 13: {
                    single = CR;
                }
            }
            String esc = String.format("\\u%04X", i);
            String esc6 = String.format("\\u{%X}", i);
            StringProcessor.UNICODE_ESC[i] = esc;
            StringProcessor.SINGLE_ESC[i] = single != null ? single : esc;
            StringProcessor.ECMA6_ESC[i] = esc6;
            StringProcessor.ECMA6_SINGLE_ESC[i] = single != null ? single : esc6;
        }
    }

    private class SurrogateEvalEscapeChecker
    extends AbstractEscapeChecker {
        private SurrogateEvalEscapeChecker() {
        }

        @Override
        public boolean needEscapeImpl(char ch) {
            return StringProcessor.isControl(ch) || StringProcessor.isEvalEsc(ch) || JSONUtil.isSurrogate(ch);
        }

        @Override
        public boolean needEscapeImpl() {
            return true;
        }
    }

    private class SurrogateEscapeChecker
    extends AbstractEscapeChecker {
        private SurrogateEscapeChecker() {
        }

        @Override
        public boolean needEscapeImpl(char ch) {
            return StringProcessor.isControl(ch) || StringProcessor.isEsc(ch) || JSONUtil.isSurrogate(ch);
        }

        @Override
        public boolean needEscapeImpl() {
            return true;
        }
    }

    private class AsciiEvalEscapeChecker
    extends AbstractEscapeChecker {
        private AsciiEvalEscapeChecker() {
        }

        @Override
        public boolean needEscapeImpl(char ch) {
            return StringProcessor.isNotAscii(ch) || StringProcessor.isEvalEsc(ch);
        }

        @Override
        public boolean needEscapeImpl() {
            return true;
        }
    }

    private class AsciiEscapeChecker
    extends AbstractEscapeChecker {
        private AsciiEscapeChecker() {
        }

        @Override
        public boolean needEscapeImpl(char ch) {
            return StringProcessor.isNotAscii(ch) || StringProcessor.isEsc(ch);
        }

        @Override
        public boolean needEscapeImpl() {
            return true;
        }
    }

    private class EvalEscapeChecker
    extends AbstractEscapeChecker {
        private EvalEscapeChecker() {
        }

        @Override
        public boolean needEscapeImpl(char ch) {
            return StringProcessor.isControl(ch) || StringProcessor.isEvalEsc(ch);
        }

        @Override
        public boolean needEscapeImpl() {
            return false;
        }
    }

    private class BasicEscapeChecker
    extends AbstractEscapeChecker {
        private BasicEscapeChecker() {
        }

        @Override
        public boolean needEscapeImpl(char ch) {
            return StringProcessor.isControl(ch) || StringProcessor.isEsc(ch);
        }

        @Override
        public boolean needEscapeImpl() {
            return false;
        }
    }

    private abstract class AbstractEscapeChecker
    implements EscapeChecker {
        private AbstractEscapeChecker() {
        }

        @Override
        public boolean needEscape(char ch) {
            if (StringProcessor.this.isDefined == 0) {
                return StringProcessor.this.undefinedCodePointPolicy == 3;
            }
            if (StringProcessor.this.isUnmatchedSurrogate != 0) {
                return StringProcessor.this.unmatchedSurrogatePolicy == 3;
            }
            return this.needEscapeImpl(ch);
        }

        @Override
        public boolean needEscape() {
            if (StringProcessor.this.isDefined == 0) {
                return StringProcessor.this.undefinedCodePointPolicy == 3;
            }
            return this.needEscapeImpl();
        }
    }

    private static interface EscapeChecker {
        public boolean needEscapeImpl(char var1);

        public boolean needEscapeImpl();

        public boolean needEscape(char var1);

        public boolean needEscape();
    }

    private class EscapeHandler {
        private Matcher passThroughMatcher;
        private Matcher jsEscMatcher;
        private Matcher codePointMatcher;
        private int passThroughRegionLength;
        private int lastBackSlash;
        private int useECMA5;

        private EscapeHandler(JSONConfig cfg, int lastBackSlash) {
            this.lastBackSlash = lastBackSlash;
            Pattern escapePassThroughPat = StringProcessor.getEscapePassThroughPattern(cfg, StringProcessor.this.useSingleLetterEscapes != 0);
            this.passThroughMatcher = escapePassThroughPat.matcher(StringProcessor.this.strValue);
            this.passThroughRegionLength = StringProcessor.getEscapePassThroughRegionLength(cfg);
            this.jsEscMatcher = JAVASCRIPT_ESC_PAT.matcher(StringProcessor.this.strValue);
            int n = this.useECMA5 = StringProcessor.this.useECMA6 == 0 ? 1 : 0;
            if (this.useECMA5 != 0) {
                this.codePointMatcher = CODE_POINT_PAT.matcher(StringProcessor.this.strValue);
            }
        }

        private String checkInlineEscape() {
            String esc = null;
            String hexStr = null;
            boolean newChars = false;
            if (StringProcessor.gotMatch(this.passThroughMatcher, StringProcessor.this.index, StringProcessor.this.end(this.passThroughRegionLength))) {
                esc = this.passThroughMatcher.group(1);
                StringProcessor.this.nextIndex += esc.length() - 1;
            } else if (StringProcessor.gotMatch(this.jsEscMatcher, StringProcessor.this.index, StringProcessor.this.end(4))) {
                newChars = true;
                String jsEsc = this.jsEscMatcher.group(1);
                char c = StringProcessor.getEscapeChar(jsEsc);
                ((StringProcessor)StringProcessor.this).chars[0] = c;
                StringProcessor.this.codePoint = c;
                StringProcessor.this.nextIndex += jsEsc.length() - 1;
            } else if (this.useECMA5 != 0 && StringProcessor.gotMatch(this.codePointMatcher, StringProcessor.this.index, StringProcessor.this.end(10))) {
                newChars = true;
                hexStr = this.handleCodePointEscape();
            } else {
                esc = StringProcessor.this.getEscapeString();
            }
            if (newChars) {
                if (StringProcessor.this.isDefined == 0) {
                    esc = this.handleUndefined(hexStr);
                }
                if (esc == null && StringProcessor.this.needEscape()) {
                    esc = StringProcessor.this.getEscapeString();
                }
            }
            if (StringProcessor.this.nextIndex > this.lastBackSlash) {
                StringProcessor.this.processInlineEscapes = 0;
                StringProcessor.this.handler = null;
            }
            return esc;
        }

        private String handleCodePointEscape() {
            String hexStr = this.codePointMatcher.group(2);
            StringProcessor.this.codePoint = Integer.parseInt(hexStr, 16);
            if (StringProcessor.this.codePoint < 65536) {
                ((StringProcessor)StringProcessor.this).chars[0] = (char)StringProcessor.this.codePoint;
                StringProcessor.this.isDefined = StringProcessor.isDefined(StringProcessor.this.chars[0]);
            } else if (StringProcessor.this.codePoint > 0x10FFFF) {
                StringProcessor.this.isDefined = 0;
            } else {
                StringProcessor.this.isSupplementary = 1;
                StringProcessor.this.charCount = 2;
                ((StringProcessor)StringProcessor.this).chars[0] = StringProcessor.highSurrogate(StringProcessor.this.codePoint);
                ((StringProcessor)StringProcessor.this).chars[1] = StringProcessor.lowSurrogate(StringProcessor.this.codePoint);
                StringProcessor.this.isDefined = StringProcessor.isDefined(StringProcessor.this.codePoint);
            }
            StringProcessor.this.nextIndex += this.codePointMatcher.group(1).length() - 1;
            return hexStr;
        }

        private String handleUndefined(String hexStr) {
            String esc = null;
            switch (StringProcessor.this.undefinedCodePointPolicy) {
                case 0: {
                    StringProcessor.this.replaceCodePoint();
                    break;
                }
                case 1: {
                    esc = "";
                    break;
                }
                case 2: {
                    throw new UndefinedCodePointException(StringProcessor.this.cfg, StringProcessor.this.strValue, StringProcessor.this.index, hexStr);
                }
                default: {
                    if (StringProcessor.this.codePoint <= 0x10FFFF) break;
                    StringProcessor.this.replaceCodePoint();
                }
            }
            return esc;
        }
    }
}

