/*
 * Decompiled with CFR 0.152.
 */
package org.kopitubruk.util.json;

import java.util.Locale;
import java.util.ResourceBundle;
import org.kopitubruk.util.json.JSONConfig;
import org.kopitubruk.util.json.JSONException;
import org.kopitubruk.util.json.JSONUtil;

public class UndefinedCodePointException
extends JSONException {
    private String strValue;
    private int position;
    private int codePoint;
    private static final long serialVersionUID = 1L;

    UndefinedCodePointException(JSONConfig cfg, String strValue, int position, int codePoint) {
        super(cfg);
        this.strValue = strValue;
        this.position = position;
        this.codePoint = codePoint;
    }

    UndefinedCodePointException(JSONConfig cfg, String strValue, int position, String codePointHexString) {
        super(cfg);
        this.strValue = strValue;
        this.position = position;
        this.codePoint = Integer.parseInt(codePointHexString, 16);
    }

    public String getStrValue() {
        return this.strValue;
    }

    public int getPosition() {
        return this.position;
    }

    public int getCodePoint() {
        return this.codePoint;
    }

    @Override
    String internalGetMessage(Locale locale) {
        ResourceBundle bundle = JSONUtil.getBundle(locale);
        return String.format(bundle.getString("undefinedCodePoint"), this.codePoint, this.position);
    }
}

