/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.common.aws.s3;

public enum Size {
    BYTE(1L, "bytes", "bytes/s"),
    KB(1024L, "k", "KB/s"),
    MB(1024L * KB.getValue(), "m", "MB/s"),
    GB(1024L * MB.getValue(), "g", "GB/s"),
    TB(1024L * GB.getValue(), "terabytes", "terabytes/s"),
    PB(1024L * TB.getValue(), "petabytes", "petabyte/s"),
    EB(1024L * PB.getValue(), "exabytes", "exabytes/s");

    private long value;
    private String sizeLabel;
    private String rateLabel;

    private Size(long value, String sizeLabel, String rateLabel) {
        this.value = value;
        this.sizeLabel = sizeLabel;
        this.rateLabel = rateLabel;
    }

    public long getValue() {
        return this.value;
    }

    public String getSizeLabel() {
        return this.sizeLabel;
    }

    public String getRateLabel() {
        return this.rateLabel;
    }
}

