/*
 * Decompiled with CFR 0.152.
 */
package org.linguafranca.pwdb.kdbx.jaxb;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.apache.commons.codec.binary.Base64;
import org.linguafranca.pwdb.kdbx.SerializableDatabase;
import org.linguafranca.pwdb.kdbx.StreamEncryptor;
import org.linguafranca.pwdb.kdbx.jaxb.binding.JaxbEntryBinding;
import org.linguafranca.pwdb.kdbx.jaxb.binding.JaxbGroupBinding;
import org.linguafranca.pwdb.kdbx.jaxb.binding.KeePassFile;
import org.linguafranca.pwdb.kdbx.jaxb.binding.StringField;

public class JaxbSerializableDatabase
implements SerializableDatabase {
    protected KeePassFile keePassFile;
    private StreamEncryptor encryption;

    public JaxbSerializableDatabase load(InputStream inputStream) {
        try {
            JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{KeePassFile.class});
            Unmarshaller u = jc.createUnmarshaller();
            u.setListener(new Unmarshaller.Listener(){

                public void afterUnmarshal(Object target, Object parent) {
                    try {
                        StringField.Value value;
                        if (target instanceof StringField.Value && (value = (StringField.Value)target).getProtected() != null && value.getProtected().booleanValue()) {
                            byte[] encrypted = Base64.decodeBase64((byte[])value.getValue().getBytes());
                            String decrypted = new String(JaxbSerializableDatabase.this.encryption.decrypt(encrypted), "UTF-8");
                            value.setValue(decrypted);
                            value.setProtected(false);
                        }
                        if (target instanceof JaxbGroupBinding && parent instanceof JaxbGroupBinding) {
                            ((JaxbGroupBinding)target).parent = (JaxbGroupBinding)parent;
                        }
                        if (target instanceof JaxbEntryBinding && parent instanceof JaxbGroupBinding) {
                            ((JaxbEntryBinding)target).parent = (JaxbGroupBinding)parent;
                        }
                    }
                    catch (UnsupportedEncodingException e) {
                        throw new IllegalStateException();
                    }
                }
            });
            this.keePassFile = (KeePassFile)u.unmarshal(inputStream);
            return this;
        }
        catch (JAXBException e) {
            throw new IllegalStateException(e);
        }
    }

    public void save(OutputStream outputStream) throws IOException {
        final ArrayList<String> toEncrypt = new ArrayList<String>();
        if (this.keePassFile.getMeta().getMemoryProtection().getProtectTitle().booleanValue()) {
            toEncrypt.add("Title");
        }
        if (this.keePassFile.getMeta().getMemoryProtection().getProtectURL().booleanValue()) {
            toEncrypt.add("URL");
        }
        if (this.keePassFile.getMeta().getMemoryProtection().getProtectUserName().booleanValue()) {
            toEncrypt.add("UserName");
        }
        if (this.keePassFile.getMeta().getMemoryProtection().getProtectPassword().booleanValue()) {
            toEncrypt.add("Password");
        }
        if (this.keePassFile.getMeta().getMemoryProtection().getProtectNotes().booleanValue()) {
            toEncrypt.add("Notes");
        }
        try {
            JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{KeePassFile.class});
            Marshaller u = jc.createMarshaller();
            u.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            u.setListener(new Marshaller.Listener(){

                public void beforeMarshal(Object source) {
                    try {
                        StringField field;
                        if (source instanceof StringField && toEncrypt.contains((field = (StringField)source).getKey())) {
                            byte[] encrypted = JaxbSerializableDatabase.this.encryption.encrypt(field.getValue().getValue().getBytes());
                            String b64 = new String(Base64.encodeBase64((byte[])encrypted), "UTF-8");
                            field.getValue().setValue(b64);
                            field.getValue().setProtected(true);
                        }
                    }
                    catch (UnsupportedEncodingException e) {
                        throw new IllegalStateException();
                    }
                }
            });
            u.marshal((Object)this.keePassFile, outputStream);
        }
        catch (JAXBException e) {
            throw new IllegalStateException(e);
        }
    }

    public StreamEncryptor getEncryption() {
        return this.encryption;
    }

    public void setEncryption(StreamEncryptor encryption) {
        this.encryption = encryption;
    }

    public byte[] getHeaderHash() {
        return this.keePassFile.getMeta().getHeaderHash();
    }

    public void setHeaderHash(byte[] hash) {
        this.keePassFile.getMeta().setHeaderHash(hash);
    }

    public KeePassFile getKeePassFile() {
        return this.keePassFile;
    }

    public void setKeePassFile(KeePassFile keypassFile) {
        this.keePassFile = keypassFile;
    }
}

