/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.changelog.filter;

import java.util.Optional;
import liquibase.Scope;
import liquibase.changelog.ChangeSet;
import liquibase.changelog.DatabaseChangeLog;
import liquibase.changelog.filter.ChangeSetFilter;
import liquibase.changelog.filter.ChangeSetFilterResult;
import liquibase.exception.LiquibaseException;
import liquibase.logging.Logger;

public class SinglePendingChangeSetFilter
implements ChangeSetFilter {
    private final String id;
    private final String author;
    private final String filePath;

    public SinglePendingChangeSetFilter(String string, String string2, String string3, DatabaseChangeLog databaseChangeLog) {
        Logger logger = Scope.getCurrentScope().getLog(this.getClass());
        string = Optional.ofNullable(databaseChangeLog.getChangeSet(string3, string2, string)).orElseThrow(() -> {
            logger.warning("Unable to locate the change for " + string + "::" + string2 + "::" + string3);
            logger = this.createNotFoundErrorMessage(string, string2, string3);
            return new LiquibaseException((String)logger);
        });
        this.id = string.getId();
        this.author = string.getAuthor();
        this.filePath = string.getFilePath();
    }

    private String createNotFoundErrorMessage(String string, String string2, String string3) {
        return "The changeset targeted by '" + string + "::" + string2 + "::" + string3 + "' was not found. ";
    }

    public ChangeSetFilterResult accepts(ChangeSet changeSet) {
        String string = changeSet.toString();
        if (this.id.equalsIgnoreCase(changeSet.getId()) && this.author.equalsIgnoreCase(changeSet.getAuthor()) && this.filePath.equals(changeSet.getFilePath())) {
            return new ChangeSetFilterResult(true, "Changeset to run is ".concat(String.valueOf(string)), this.getClass());
        }
        return new ChangeSetFilterResult(false, "Changeset " + string + " will not execute", this.getClass());
    }
}

