/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.storedlogic;

import java.util.Set;
import liquibase.database.Database;
import liquibase.database.core.MSSQLDatabase;
import liquibase.diff.ObjectDifferences;
import liquibase.diff.compare.CompareControl;
import liquibase.diff.compare.DatabaseObjectComparator;
import liquibase.diff.compare.DatabaseObjectComparatorChain;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.StoredDatabaseLogic;
import liquibase.util.SqlParser;
import liquibase.util.StringClauses;

public class StoredLogicComparator
implements DatabaseObjectComparator {
    public int getPriority(Class<? extends DatabaseObject> clazz, Database database) {
        if (StoredDatabaseLogic.class.isAssignableFrom(clazz)) {
            return 1;
        }
        return -1;
    }

    public boolean isSameObject(DatabaseObject databaseObject, DatabaseObject databaseObject2, Database database, DatabaseObjectComparatorChain databaseObjectComparatorChain) {
        return databaseObjectComparatorChain.isSameObject(databaseObject, databaseObject2, database);
    }

    public String[] hash(DatabaseObject databaseObject, Database database, DatabaseObjectComparatorChain databaseObjectComparatorChain) {
        return databaseObjectComparatorChain.hash(databaseObject, database);
    }

    public ObjectDifferences findDifferences(DatabaseObject databaseObject, DatabaseObject databaseObject2, Database database, CompareControl compareControl, DatabaseObjectComparatorChain object, Set<String> object2) {
        object2.add((String)"tableSchema");
        object2.add((String)"body");
        compareControl = object.findDifferences(databaseObject, databaseObject2, database, compareControl, object2);
        object = SqlParser.parse((String)((StoredDatabaseLogic)databaseObject).getBody(), (boolean)false, (boolean)true).toString();
        object2 = SqlParser.parse((String)((StoredDatabaseLogic)databaseObject2).getBody(), (boolean)false, (boolean)true).toString();
        if (!((String)object).equals(object2)) {
            compareControl.addDifference("body", (Object)((StoredDatabaseLogic)databaseObject).getBody(), (Object)((StoredDatabaseLogic)databaseObject2).getBody());
        }
        if (compareControl.isDifferent("body") && this.standardize(databaseObject.getName(), (String)object, database).equals(this.standardize(databaseObject2.getName(), (String)object2, database))) {
            compareControl.removeDifference("body");
        }
        return compareControl;
    }

    protected String standardize(String object, String string, Database database) {
        Object object2;
        object = ((String)object).toLowerCase();
        boolean bl2 = false;
        StringClauses stringClauses = SqlParser.parse((String)string);
        StringClauses.ClauseIterator clauseIterator = stringClauses.getClauseIterator();
        while (clauseIterator.hasNext()) {
            object2 = clauseIterator.nextNonWhitespace();
            if (object2 != null) {
                if ("trigger".equalsIgnoreCase((String)object2)) {
                    bl2 = true;
                } else {
                    if ("(".equals(object2)) break;
                    if (object2.toString().toLowerCase().contains((CharSequence)object)) {
                        clauseIterator.remove();
                        break;
                    }
                }
            }
            clauseIterator.remove();
        }
        if (bl2 && clauseIterator.hasNext()) {
            boolean bl3 = false;
            object = clauseIterator.nextNonWhitespace();
            while (!bl3 && clauseIterator.hasNext()) {
                if ("on".equalsIgnoreCase((String)object)) {
                    object = clauseIterator.nextNonWhitespace();
                    clauseIterator.remove();
                    bl3 = true;
                    continue;
                }
                object = clauseIterator.nextNonWhitespace();
            }
        }
        if (stringClauses.isEmpty()) {
            object2 = string.replaceFirst("(?i)^\\s*create\\s+(\\w+)\\s+", "");
            if (!((String)object2).equals(string)) {
                return object2;
            }
            object2 = string.replaceFirst("(?i)^\\s*alter\\s+(\\w+)\\s+", "");
        } else {
            object2 = stringClauses.toString();
        }
        object2 = ((String)object2).replaceFirst("[\\s\\n\\r]*;[\\s\\n\\r]*$", "").replaceFirst("[\\s\\n\\r]+GO[\\s\\n\\r]*$", "").replaceFirst("[\\s\\n\\r]+/[\\s\\n\\r]*$", "");
        if (database instanceof MSSQLDatabase) {
            object2 = ((String)object2).replaceAll("\\[(\\w*?)\\]", "$1");
        }
        return object2;
    }
}

